<?xml version="1.0" encoding="UTF-8"?>
<!-- 
Property : eHealth
Author   : eHealth 
Date     : 01/06/2010
Version 1.0 Written for ehValidator library and tool

This is a schematron file.
The purpose of this schematron is to check sumehr rules on a kmehr file.
Checked input file must be a correct kmehr XML file.

schematron: http://www.schematron.com
Kmehr  definition: https://www.ehealth.fgov.be/standards/kmehr/en/home/home/index.xml
Sumehr definition: https://www.ehealth.fgov.be/standards/kmehr/en/transaction_detail/home/transactions/transaction_detail/Sumehr-1-1.xml
eHealth: https://www.ehealth.fgov.be
-->
<iso:schema 	xmlns="http://purl.oclc.org/dsdl/schematron"
						xmlns:iso="http://purl.oclc.org/dsdl/schematron"
						xmlns:sch="http://www.ascc.net/xml/schematron"
						xmlns:kmehr="http://www.ehealth.fgov.be/standards/kmehr/schema/v1"
						queryBinding="xslt2"
						schemaVersion="ISO19757-3" defaultPhase='#ALL'
						>
	
		<iso:title>Checking a Sumehr document</iso:title>
		<iso:ns prefix="kmehr" uri="http://www.ehealth.fgov.be/standards/kmehr/schema/v1" />
		
<!-- KMEHR ERRORS -->
<iso:pattern id="cd-hcparty.structure.checks">
	<iso:title>Kmehr icd-hcparty structure checks</iso:title>
	<iso:rule context="//*[kmehr:cd[@S = 'CD-HCPARTY']]">
			<iso:assert test="count(kmehr:cd[@S = 'CD-HCPARTY']) &lt; 2" id="Codification" role="ERROR" flag="structure" >
			"<iso:value-of select="local-name()"/>" element must have maximum one code with official CD-HCPARTY. (Number: <iso:value-of select="count(kmehr:cd[@S='CD-HCPARTY'])"/>, Codes: "<iso:value-of select="kmehr:cd[@S = 'CD-HCPARTY']"/>")_||_
			L'élément "<iso:value-of select="local-name()"/>" doit contenir au maximum un code contenant un CD-HCPARTY officiel. (Nombre: <iso:value-of select="count(kmehr:cd[@S='CD-HCPARTY'])"/>, Codes: "<iso:value-of select="kmehr:cd[@S = 'CD-HCPARTY']"/>")_||_
			Het element "<iso:value-of select="local-name()"/>" mag maximaal een code met een officiële CD-HCPARTY bevatten. (Aantal: <iso:value-of select="count(kmehr:cd[@S='CD-HCPARTY'])"/>, Codes: "<iso:value-of select="kmehr:cd[@S = 'CD-HCPARTY']"/>")_||_
			Das Element "<iso:value-of select="local-name()"/>" darf maximal einen offiziellen CD-HDPARTY-Code umfassen. (Zahl: <iso:value-of select="count(kmehr:cd[@S='CD-HCPARTY'])"/>, Codes: "<iso:value-of select="kmehr:cd[@S = 'CD-HCPARTY']"/>")</iso:assert>
	</iso:rule>
</iso:pattern>

<!-- CODIFICATION -->
<iso:pattern id="codifications.values.checks">
	<iso:title>Codifications values checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='sumehr']]//kmehr:item">
			<iso:assert test="count(kmehr:content/kmehr:cd[@S='ICPC']) &lt; 2" id="Codification" role="ERROR" flag="value"  >
			A content must have maximum one ICPC code. (Number: <iso:value-of select="count(kmehr:content/kmehr:cd[@S='ICPC'])"/>)_||_
			Un "content" doit contenir au maximum un code ICPC. (Nombre: <iso:value-of select="count(kmehr:content/kmehr:cd[@S='ICPC'])"/>)_||_
			Een "content" mag maximaal één ICPC-code omvatten. (Aantal: <iso:value-of select="count(kmehr:content/kmehr:cd[@S='ICPC'])"/>)_||_
			Ein "Content" darf maximal einen ICPC-Code umfassen. (Zahl: <iso:value-of select="count(kmehr:content/kmehr:cd[@S='ICPC'])"/>)</iso:assert>
			<iso:assert test="count(kmehr:content/kmehr:cd[@S='ICD']) &lt; 2" id="Codification" role="ERROR" flag="value"  >
			A content must have maximum one ICD code. (Number: <iso:value-of select="count(kmehr:content/kmehr:cd[@S='ICD'])"/>)_||_
			Un "content" doit contenir au maximum un code ICD. (Nombre: <iso:value-of select="count(kmehr:content/kmehr:cd[@S='ICD'])"/>)_||_
			Een "content" mag maximaal één ICD-code omvatten. (Aantal: <iso:value-of select="count(kmehr:content/kmehr:cd[@S='ICD'])"/>)_||_
			Ein "Content" darf maximal einen ICPC-Code umfassen. (Zahl: <iso:value-of select="count(kmehr:content/kmehr:cd[@S='ICD'])"/>)</iso:assert>
			<iso:assert test="count(kmehr:content/kmehr:cd[@S='CD-CLINICAL']) &lt; 2" id="Codification" role="ERROR" flag="value"  >
			A content must have maximum one IBUI code (CD-CLINICAL). (Number: <iso:value-of select="count(kmehr:content/kmehr:cd[@S='CD-CLINICAL'])"/>)_||_
			Un "content" doit contenir au maximum un code IBUI (CD-CLINICAL). (Nombre: <iso:value-of select="count(kmehr:content/kmehr:cd[@S='CD-CLINICAL'])"/>)_||_
			Een "content" mag maximaal één IBUI-code (CD-CLINICAL) omvatten. (Aantal: <iso:value-of select="count(kmehr:content/kmehr:cd[@S='CD-CLINICAL'])"/>)_||_
			Ein "Content" darf maximal einen IBUI-Code (CD-CLINICAL) umfassen. (Zahl: <iso:value-of select="count(kmehr:content/kmehr:cd[@S='CD-CLINICAL'])"/>)</iso:assert>
	</iso:rule>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='sumehr']]//kmehr:item/kmehr:content/kmehr:cd[not(@S = 'LOCAL')]">
			<iso:assert test="	(current()/@S = 'ICPC' and current()/@SV = '2' ) or 
										(current()/@S = 'ICD' and current()/@SV = '10' ) or
										(current()/@S = 'CD-CLINICAL' ) or 
										(current()/@S = 'CD-ATC' ) or 
										(current()/@S = 'CD-PATIENTWILL' ) or 
										(current()/@S = 'CD-VACCINEINDICATION' )" 
					id="Codification" role="ERROR" flag="value"  >
			"Codification / Version" used in "content" elements must be one of these: "ICPC 2", "ICD 10". (S="<iso:value-of select="current()/@S"/>" and SV="<iso:value-of select="current()/@SV"/>")_||_
			La "Codification / Version" utilisée dans les éléments "content" doit être une de celles-ci: "ICPC 2", "ICD 10". (S="<iso:value-of select="current()/@S"/>" et  SV="<iso:value-of select="current()/@SV"/>")_||_
			De in de "content"-elementen gebruikte codificatie/versie moet één van de volgende zijn: "ICPC 2", "ICD 10". (S="<iso:value-of select="current()/@S"/>" et  SV="<iso:value-of select="current()/@SV"/>")_||_
			Die in den "Content"-Elementen benutzte Kodifikation/Version muss eine der folgenden sein: ICPC 2, "ICD 10". (S="<iso:value-of select="current()/@S"/>" et  SV="<iso:value-of select="current()/@SV"/>")</iso:assert>
	</iso:rule>
</iso:pattern>	

<!-- FOLDER -->
<iso:pattern id="folder.structure.checks" role="folder">
	<iso:title>Transaction structure checks</iso:title>
	<iso:rule context="kmehr:kmehrmessage" >
			<iso:assert test="count(kmehr:folder) = 1" id="Folder" role="ERROR" flag="structure" >
			A Sumehr must have only one folder. (Number: <iso:value-of select="count(kmehr:folder)"/>)_||_
			Un Sumehr doit contenir un seul élément "folder" (Nombre: <iso:value-of select="count(kmehr:folder)"/>)_||_
			Een Sumehr mag maar één enkel element "folder" bevatten. (Aantal: <iso:value-of select="count(kmehr:folder)"/>)_||_
			Ein Sumehr-Bericht darf nur ein Element "Mappe" ("Folder") umfassen. (Zahl: <iso:value-of select="count(kmehr:folder)"/>)</iso:assert>
	</iso:rule>
	<iso:rule context="kmehr:folder" >
			<iso:assert test="count(kmehr:transaction) = 1" id="Folder" role="ERROR" flag="structure" >
			A "folder" element must have one transaction and only one. (Number: <iso:value-of select="count(kmehr:transaction)"/>)_||_
			L'élément "folder" doit contenir une et une seule "transaction". (Nombre: <iso:value-of select="count(kmehr:transaction)"/>)_||_
			Het element "folder" mag slechts één enkele "transactie" bevatten. (Aantal: <iso:value-of select="count(kmehr:transaction)"/>)_||_
			Das Element darf nur eine "Transaction" umfassen. (Zahl: <iso:value-of select="count(kmehr:transaction)"/>)</iso:assert>
	</iso:rule>
</iso:pattern>

<!-- TRANSACTION -->
<iso:pattern id="transaction.structure.checks" role="transaction">
	<iso:title>Transaction structure checks</iso:title>
	
	<!--  Date and time managed by schema
	<iso:rule context="kmehr:folder/kmehr:transaction" >
		<iso:assert test="number(substring(kmehr:date,1,4)) = floor(number(substring(kmehr:date,1,4))) and substring(kmehr:date,5,1)='-' and number(substring(kmehr:date,6,2)) = floor(number(substring(kmehr:date,6,2))) and substring(kmehr:date,8,1)='-' and number(substring(kmehr:date,9,2)) = floor(number(substring(kmehr:date,9,2))) and number(substring(kmehr:time,1,2)) = floor(number(substring(kmehr:time,1,2))) and substring(kmehr:time,3,1)=':' and number(substring(kmehr:time,4,2)) = floor(number(substring(kmehr:time,4,2))) and substring(kmehr:time,6,1)=':' and number(substring(kmehr:time,7,2)) = floor(number(substring(kmehr:time,7,2)))"  id="Transaction" role="ERROR" flag="structure" >Sumehr date and time must be complete and correct._||_french message_||_dutch message_||_german message</iso:assert>
	</iso:rule> -->
	<iso:rule context="kmehr:folder/kmehr:transaction/kmehr:cd[@S='CD-TRANSACTION']" >
			<iso:assert test="current() = 'sumehr'"  id="Transaction" role="ERROR" flag="structure" >
			All transactions in Sumehr must have official "sumehr" codification. (CD-TRANSACTION here: "<iso:value-of select="current()"/>")_||_
			Toutes les "transactions" dans le Sumehr doivent avoir une codification "sumehr" officielle. (CD-TRANSACTION ici: "<iso:value-of select="current()"/>")_||_
			Alle "transacties" in het Sumehr moeten een officiële "Sumehr" codificatie hebben. (CD-TRANSACTION hier "<iso:value-of select="current()"/>")_||_
			Alle "Transaktionen" im Sumehr-Bericht müssen eine offizielle "Sumehr" Kodifikation haben. (CD-TRANSACTION hier "<iso:value-of select="current()"/>")</iso:assert>
	</iso:rule>
</iso:pattern>

<iso:pattern id="transaction.values.checks">
	<iso:title>Transaction values checks</iso:title>
	<iso:rule context="kmehr:folder/kmehr:transaction">
		    <iso:assert test="kmehr:iscomplete[.= 'true']" id="Transaction" role="ERROR" flag="value" >
		    Sumehr transaction must be Complete."_||_
		    Une transaction "Sumehr" doit être "complète"_||_
		    Een Sumehr-transactie moet volledig zijn._||_
		    Eine Sumehr-Transaktion muss vollständig sein.</iso:assert>
		    <iso:assert test="kmehr:isvalidated[.= 'true']" id="Transaction" role="ERROR" flag="value" >
		    Sumehr transaction must be Validated._||_
		    Une transaction "Sumehr" doit être "validée"_||_
		    Een Sumehr-transactie moet gevalideerd zijn._||_
		    Eine Sumehr-Transaktion muss validiert werden.</iso:assert>
	</iso:rule>
</iso:pattern>


<!-- PATIENT -->
<iso:pattern id="patient.structure.checks">
	<iso:title>Patient structure checks</iso:title>
	<iso:rule context="kmehr:patient">
			<!-- Duplicate test with kmehr rule at the beginning... -->
			<iso:assert test="( count(kmehr:id[@S = 'ID-PATIENT']) + count(kmehr:id[@S = 'INSS']) )=1" id="Patient" role="ERROR" flag="structure" >
			Patient must have one INSS and only one. (Number: <iso:value-of select="count(kmehr:id[@S = 'ID-PATIENT']) + count(kmehr:id[@S = 'INSS'])"/>)_||_
			Le patient doit avoir un et un seul NISS (Nombre: <iso:value-of select="count(kmehr:id[@S = 'ID-PATIENT']) + count(kmehr:id[@S = 'INSS'])"/>)._||_
			De patiënt mag een enkel INSZ hebben (Aantal: <iso:value-of select="count(kmehr:id[@S = 'ID-PATIENT']) + count(kmehr:id[@S = 'INSS'])"/>)._||_
			Der Patient darf nur eine INSS haben (Zahl: <iso:value-of select="count(kmehr:id[@S = 'ID-PATIENT']) + count(kmehr:id[@S = 'INSS'])"/>)</iso:assert>
			<iso:assert test="kmehr:birthdate" id="Patient" role="ERROR" flag="structure" >
			Patient must have a birthdate._||_
			Le patient doit avoir une date de naissance._||_
			De patiënt moet een geboortedatum hebben._||_
			Der Patient muss ein Geburtsdatum haben.</iso:assert>
	</iso:rule>
</iso:pattern>

<iso:pattern id="patient.structure.warnings.checks">
	<iso:title>Patient warnings checks</iso:title>
	<iso:rule context="kmehr:patient">
			<iso:assert test="kmehr:usuallanguage" id="Patient" role="WARNING" flag="structure" >
			Patient should have an usual language._||_
			Le patient devrait avoir une langue maternelle._||_
			De patient moet een moedertaal hebben._||_
			Der Patient muss eine Muttersprache haben.</iso:assert>
	</iso:rule>
</iso:pattern>


<!-- AUTHOR -->
<iso:pattern id="author.structure.checks">
	<iso:title>Author structure checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='sumehr']]/kmehr:author/kmehr:hcparty[last()]">
			<!-- Duplicate test with kmehr rule at the beginning... -->
			<iso:assert test="count(kmehr:id[@S = 'ID-HCPARTY'])=1" id="Author" role="ERROR" flag="structure" >
			Author last hcparty must have one INAMI/RIZIV and only one. (Number: <iso:value-of select="count(kmehr:id[@S = 'ID-HCPARTY'])"/>)_||_
			Le dernier élément "hcparty" de l'élément "author" doit contenir un et un seul INAMI/RIZIV (Nombre: <iso:value-of select="count(kmehr:id[@S = 'ID-HCPARTY'])"/>)_||_
			Het laatste element "hcparty" van het element "author" mag maar één enkel RIZIV nummer hebben (Aantal: <iso:value-of select="count(kmehr:id[@S = 'ID-HCPARTY'])"/>)_||_
			Das letzte Element "hcparty" im Element "author" darf nur einen Code LIKIV umfassen (Zahl: <iso:value-of select="count(kmehr:id[@S = 'ID-HCPARTY'])"/>)</iso:assert>
			<!-- Local id: we don't check
			<iso:assert test="count(kmehr:cd[@S = 'LOCAL' and @SL = 'ID-PATIENT']) &lt; 2" id="Author" role="ERROR" flag="structure" >Author hcparty must have maxmum one INSS._||_french message_||_dutch message_||_german message</iso:assert> -->
			<iso:assert test="kmehr:familyname" id="Author" role="ERROR" flag="structure" >
			Author last hcparty must have a familyname (and firstnames)._||_
			Le dernier élément "hcparty" de l'élément "author" doit contenir un nom de famille (et prénoms)._||_
			Het laatste element "hcparty" van het element "author" moet een familienaam (en voornamen) bevatten._||_
			Das letzte Element "hcparty" im Element "author" muss einen familiennamen (und Vornamen) umfassen.</iso:assert>
			<iso:assert test="kmehr:cd[@S = 'CD-HCPARTY' and .='persphysician']" id="Author" role="ERROR" flag="structure" >
			Author last hcparty must have a "persphysician" CD-HCPARTY code. (Codes: "<iso:value-of select="kmehr:cd[@S = 'CD-HCPARTY']"/>")_||_
			Le dernier élément "hcparty" de l'élément "author" doit contenir un code CD-HCPARTY "persphysician". (Codes: "<iso:value-of select="kmehr:cd[@S = 'CD-HCPARTY']"/>")_||_
			Het laatste element "hcparty" van het element "author" moet een code CD-HCPARTY "persphysician" bevatten. (Codes: "<iso:value-of select="kmehr:cd[@S = 'CD-HCPARTY']"/>")_||_
			Das letzte Element "hcparty" im Element "author" muss einen Code CD-HCPARTY "persphysician" umfassen. (Codes: "<iso:value-of select="kmehr:cd[@S = 'CD-HCPARTY']"/>")</iso:assert>
	</iso:rule>
	<!-- No more used
	<iso:rule context="kmehr:author/kmehr:hcparty[last()]/kmehr:cd[@S = 'CD-HCPARTY']">
			<iso:assert test="starts-with(current(),'pers')" id="Author" role="ERROR" flag="structure" >Author last hcparty CD-HCPARTY code must start by "pers". (Code: "<iso:value-of select="current()"/>")_||_french message_||_dutch message_||_german message</iso:assert>
	</iso:rule> -->
</iso:pattern>

<iso:pattern id="author.structure.warnings.checks">
	<iso:title>Author warnings checks</iso:title>
	<iso:rule context="kmehr:author/kmehr:hcparty[last()]">
			<iso:assert test="kmehr:id[@S = 'INSS']" id="Author" role="WARNING" flag="structure" >
			Author last hcparty should have a INSS._||_
			Le dernier élément "hcparty" de l'élément "author" devrait contenir un numéro NISS._||_
			Het laatste element "hcparty" van het element "author" moet een INSZ-nummer omvatten._||_
			Das letzte Element "hcparty" im Element "author" muss eine INSS-Nummer umfassen.</iso:assert>
			<iso:assert test="kmehr:address" id="Author" role="WARNING" flag="structure" >
			Author last hcparty should have at least one address._||_
			Le dernier élément "hcparty" de l'élément "author" devrait contenir au moins une adresse._||_
			Het laatste element "hcparty" van het element "author" moet minstens een adres omvatten._||_
			Das letzte Element "hcparty" im Element "author" muss mindestens eine Adresse umfassen. </iso:assert>
			<iso:assert test="kmehr:telecom" id="Author" role="WARNING" flag="structure" >
			Author last hcparty should have at least one telecom._||_
			Le dernier élément "hcparty" de l'élément "author" devrait contenir au moins un moyen de télécommunication._||_
			Het laatste element "hcparty" van het element "author" moet minstens een telecommunicatiemiddel omvatten._||_
			Das letzte Element "hcparty" im Element "author" muss mindestens ein Telekommunikationsmittel umfassen. </iso:assert>
	</iso:rule>
</iso:pattern>


<!-- ITEMS -->
<iso:pattern id="items.structure.checks">
	<iso:title>Items structure checks</iso:title>
	<!-- not useful, kmehr schema is enough: at least one folder : at least one  transaction : at least one item <iso:rule context="kmehr:transaction">
			  <iso:assert test="count(//kmehr:item) > 0" id="Item" role="ERROR" flag="structure"  >Sumehr must have at least one item._||_french message_||_dutch message_||_german message</iso:assert>
	</iso:rule> -->
	<iso:rule context="kmehr:item">
			<iso:assert test="count(kmehr:cd[@S = 'CD-ITEM']) = 1" id="Item" role="ERROR" flag="structure"  >
			All items in Sumehr must be codified by one code CD-ITEM and only one. (Number: <iso:value-of select="count(kmehr:cd[@S = 'CD-ITEM'])"/>)_||_
			Tous les éléments "items" doivent être catégorisés par un et un seul code CD-ITEM, (Nombre: <iso:value-of select="count(kmehr:cd[@S = 'CD-ITEM'])"/>)_||_
			Alle elementen "items" moeten onder één enkele code CD-ITEM worden ondergebracht. (Aantal: <iso:value-of select="count(kmehr:cd[@S = 'CD-ITEM'])"/>)_||_
			Alle Elemente "Themen" ("Items") müssen unter einem einzigen Code kategorisiert werden.(Zahl: <iso:value-of select="count(kmehr:cd[@S = 'CD-ITEM'])"/>)</iso:assert>
	</iso:rule>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='sumehr']]//kmehr:item/kmehr:cd[@S = 'CD-ITEM']"> <!-- We checked before that all items have @S='CD-ITEM'... maybe it's not usefull to specify it again-->
			<!-- <iso:assert test="document('sumehr-validation-annex.xml')//kmehr:item/kmehr:cd[@S = 'CD-ITEM']=current()" id="Item" role="ERROR" flag="structure"  >Item code  in Sumehr must exist in annex. (CD-ITEM: "<iso:value-of select="current()"/>")_||_french message_||_dutch message_||_german message</iso:assert> -->
			<iso:assert test="	(current()='adr') or 
								(current()='allergy') or 
								(current()='socialrisk') or 
								(current()='risk') or 
								(current()='contactperson') or 
								(current()='contacthcparty') or 
								(current()='gmdmanager') or 
								(current()='healthcareelement') or 
								(current()='vaccine') or 
								(current()='medication') or
								(current()='patientwill')" 
			id="Item" role="ERROR" flag="structure"  >
			Item code in Sumehr must be one of these: "adr", "allergy", "socialrisk", "risk", "contactperson", "contacthcparty", "gmdmanager", "healthcareelement", "vaccine", "medication","patientwill" . (CD-ITEM: "<iso:value-of select="current()"/>")_||_
			Le code d'un item dans le Sumehr doit être un de ceux-ci: "adr", "allergy", "socialrisk", "risk", "contactperson", "contacthcparty", "gmdmanager", "healthcareelement", "vaccine", "medication" . (CD-ITEM: "<iso:value-of select="current()"/>")_||_
			De code van een item in het Sumehr moet één van de volgende zijn: "adr", "allergy", "socialrisk", "risk", "contactperson", "contacthcparty", "gmdmanager", "healthcareelement", "vaccine", "medication" . (CD-ITEM: "<iso:value-of select="current()"/>")_||_
			Der Code eines Themas im Sumehr-Bericht muss einer der folgenden sein: adr, "allergy", "socialrisk", "risk", "contactperson", "contacthcparty", "gmdmanager", "healthcareelement", "vaccine", "medication" . (CD-ITEM: "<iso:value-of select="current()"/>")</iso:assert>
	</iso:rule>
</iso:pattern>

<!-- CONTACT HC PARTY -->
<iso:pattern id="contacthcparty.structure.checks">
	<iso:title>Contacts hcparty structure checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='sumehr']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='contacthcparty']]">
			<iso:assert test="count(kmehr:content/kmehr:hcparty) = 1" id="Contact Hcparty" role="ERROR" flag="structure"  >
			Contact Hcparty must have one content with "hcparty" element and only one. (Number: <iso:value-of select="count(kmehr:content/kmehr:hcparty)"/>)_||_
			Un item "contact prestataire de soins" doit contenir un et un seul "content" contenant un élément "hcparty". (Nombre: <iso:value-of select="count(kmehr:content/kmehr:hcparty)"/>)_||_
			Een item "contact-zorgverlener" mag een enkel "content" met een element "hcparty" omvatten. (Aantal: <iso:value-of select="count(kmehr:content/kmehr:hcparty)"/>)_||_
			Ein Thema "Kontakt - Pflegeanbieter" darf nur einen "Content" mit einem "hcparty"-Element umfassen. (Zahl: <iso:value-of select="count(kmehr:content/kmehr:hcparty)"/>)</iso:assert>
	</iso:rule>	
</iso:pattern>

<iso:pattern id="contacthcparty-contents.structure.checks">
	<iso:title>Contacts hcparty content structure checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='sumehr']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='contacthcparty']]/kmehr:content/*">
			<iso:assert test="(local-name()='hcparty')" id="Contact Hcparty" role="ERROR" flag="structure"  >
			A "Contact Hcparty" content can contain only element "hcparty". (Element: "<iso:value-of select="local-name()"/>")_||_
			L'élément "content" d'un item "contact-prestataire de soin" ne peut contenir que des éléments "hcparty". (Elément: "<iso:value-of select="local-name()"/>")_||_
			Het "content"-element van een item "contact-zorgverlener" mag enkel "hcparty"-elementen bevatten. (Element: "<iso:value-of select="local-name()"/>")_||_
			Das "Content"-Element im Thema "Kontakt - Pflegeanbieter" darf nur  "hcparty"-Elemente umfassen. (Element: "<iso:value-of select="local-name()"/>")</iso:assert>
			<iso:assert test="kmehr:familyname" id="Contact Hcparty" role="ERROR" flag="structure"  >
			Contact Hcparty must have a familyname (and firstnames)._||_
			Un item "contact prestataire de soins" doit contenir un nom de famille (et prénoms)._||_
			Een item "contact-zorgverlener" moet een familienaam (en voornamen) omvatten._||_
			Ein Thema "Kontakt - Pflegeanbieter" muss einen Familiennamen (und Vornamen) umfassen.</iso:assert>
	</iso:rule>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='sumehr']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='contacthcparty']]/kmehr:content/kmehr:hcparty/kmehr:cd[@S='CD-HCPARTY']">
			<iso:assert test="starts-with(current(),'pers')" id="Contact Hcparty" role="ERROR" flag="structure"  >
			A Contact Hcparty "role" (official CD-HCPARTY) must start with "pers". (Code: "<iso:value-of select="current()"/>")_||_
			Le rôle d'un contact prestataire de soins (CD-HCPARTY) doit commencer par "pers". (Code: "<iso:value-of select="current()"/>")_||_
			De rol van een "contact-zorgverlener" (CD-HCPARTY) moet beginnen met "pers". Code: "<iso:value-of select="current()"/>")_||_
			Die Rolle eines "Kontakt - Pflegeanbieters" muss anfangen mit "Pers". (Code: "<iso:value-of select="current()"/>")</iso:assert>
	</iso:rule>	
</iso:pattern>

<iso:pattern id="contacthcparty.structure.warnings.checks">
	<iso:title>Contacts hcparty warnings checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='sumehr']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='contacthcparty']]/kmehr:content/kmehr:hcparty">
			<iso:assert test="kmehr:id[@S = 'ID-HCPARTY']" id="Contact Hcparty" role="WARNING" flag="structure"  >
			Contact Hcparty should have one INAMI/RIZIV number._||_
			Un item "contact prestataire de soins" devrait contenir un numéro INAMI/RIZIV._||_
			Een item "contact-zorgverlener" zou minstens een RIZIV-nummer moeten hebben._||_
			Ein thema "kontakt - pflegeanbieter" sollte eine LIKIV-Nummer haben.</iso:assert>
			<iso:assert test="kmehr:address" id="Contact Hcparty" role="WARNING" flag="structure"  >
			Contact Hcparty should have at least one address._||_
			Un item  "contact prestataire de soins" devrait contenir au moins une adresse._||_
			Een item "contact-zorgverlener" zou minstens een adres moeten hebben._||_
			Ein thema "kontakt - pflegeanbieter" sollte mindestens eine Adresse haben.</iso:assert>
			<iso:assert test="kmehr:telecom" id="Contact Hcparty" role="WARNING" flag="structure"  >
			Contact Hcparty should have at least one telecom._||_
			Un item "contact prestataire de soins" devrait contenir au moins un moyen de télécommunication._||_
			Een item "contact-zorgverlener" zou minstens een telecommunicatiemiddel moeten hebben._||_
			Ein thema "kontakt - pflegeanbieter" sollte mindestens ein Telekommunikationsmittel haben.</iso:assert>
	</iso:rule>
</iso:pattern>

<!-- CONTACTPERSON -->
<iso:pattern id="contactperson.structure.checks">
	<iso:title>Contact Person structure checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='sumehr']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='contactperson']]">
			<iso:assert test="count(kmehr:content/kmehr:person) = 1" id="Contact Person" role="ERROR" flag="structure"  >
			Contact Person must have one content person and only one. (Number: <iso:value-of select="count(kmehr:content/kmehr:person)"/>)_||_
			Un item "personne de contact" doit contenir un et un seul élément "content". (Nombre: <iso:value-of select="count(kmehr:content/kmehr:person)"/>)_||_
			Een item "contactpersoon" mag maar één enkel "content"-element bevatten. (Aantal: <iso:value-of select="count(kmehr:content/kmehr:person)"/>)_||_
			Ein thema "Kontaktperson" darf nur ein "Content"-Element umfassen. (Zahl: <iso:value-of select="count(kmehr:content/kmehr:person)"/>)</iso:assert>
	</iso:rule>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='sumehr']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='contactperson']]/kmehr:content/*">
			<iso:assert test="(local-name()='person')" id="Contact Person" role="ERROR" flag="structure"  >
			A "Contact Person" content can contain only element "person". (Element: "<iso:value-of select="local-name()"/>")_||_
			L'élement "content" d'un item personne de contact ne peut contenir qu'un élément "person". (Elément: "<iso:value-of select="local-name()"/>")_||_
			Het "content"-element van een item "contactpersoon" mag maar één "person"-element bevatten. (Element: "<iso:value-of select="local-name()"/>")_||_
			Das "Content"-Element im Thema "Kontaktperson" darf nur ein "Content"-Element umfassen. (Element: "<iso:value-of select="local-name()"/>")</iso:assert>
	</iso:rule>
</iso:pattern>

<iso:pattern id="contactperson.structure.warnings.checks">
	<iso:title>Contact Person warnings checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='sumehr']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='contactperson']]">
			<iso:assert test="kmehr:cd[@S='CD-CONTACT-PERSON']" id="Contact Person" role="WARNING" flag="structure"  >
			Contact Person should have a code (CD-CONTACT-PERSON) to describe the family tie._||_
			Un item  "personne de contact" devrait contenir un code (CD-CONTACT-PERSON) pour décrire son lien familial._||_
			Een item "contactpersoon" zou een code (CD-CONTACT-PERSON) moeten bevatten om de gezinsrelatie te beschrijven. _||_
			Ein thema "Kontaktperson" darf nur "Person"-Elemente umfassen.</iso:assert>
	</iso:rule>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary'  or .='sumehr']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='contactperson']]/kmehr:content/kmehr:person">
			<iso:assert test="kmehr:address" id="Contact Person" role="WARNING" flag="structure"  >
			Contact Person should have at least one address._||_
			Un item "personne de contact" devrait contenir au moins une adresse._||_
			Een item "contactpersoon" zou minstens een adres moeten bevatten._||_
			Ein Thema "Kontaktperson" sollte mindestens eine Adresse umfassen. </iso:assert>
			<iso:assert test="kmehr:telecom" id="Contact Person" role="WARNING" flag="structure"  >
			Contact Person should have at least one telecom._||_
			Un item  "personne de contact" devrait contenir au moins un moyen de télécommunication._||_
			Een item "contactpersoon" zou minstens een communicatiemiddel moeten bevatten._||_
			Ein Thema "Kontaktperson" sollte mindestens ein Kommunikationsmittel umfassen. </iso:assert>
	</iso:rule>
</iso:pattern>

<!-- GMDMANAGER -->
<iso:pattern id="gmdmanager.structure.checks">
	<iso:title>GMD Manager structure checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='sumehr']]">
			<iso:assert test="count(//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='gmdmanager']]) &lt; 2" id="GMD Manager" role="ERROR" flag="structure"  >
			There can be maximum one GMD Manager. (Number: <iso:value-of select="count(//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='gmdmanager']])"/>)_||_
			Il ne peut y avoir au maximum un item "détenteur de DMG". (Nombre: <iso:value-of select="count(//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='gmdmanager']])"/>)_||_
			Er mag maximaal één item "GMD-houder" zijn. (Aantal: <iso:value-of select="count(//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='gmdmanager']])"/>)_||_
			Es gibt maximal ein thema "Inhaber des GMD". (Zahl: <iso:value-of select="count(//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='gmdmanager']])"/>)</iso:assert>
	</iso:rule>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='sumehr']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='gmdmanager']]">
			<iso:assert test="count(kmehr:content/kmehr:hcparty) = 1" id="GMD Manager" role="ERROR" flag="structure"  >
			GMD Manager must have one content hcparty and only one. (Number: <iso:value-of select="count(kmehr:content/kmehr:hcparty)"/>)_||_
			Un item "détenteur de DMG" contient un et un seul élément 'content' de type 'hcparty'.(Nombre: <iso:value-of select="count(kmehr:content/kmehr:hcparty)"/>)_||_
			Een item "GMD-houder" mag maar één enkel "content"-element van het type "hcparty" omvatten. (Aantal: <iso:value-of select="count(kmehr:content/kmehr:hcparty)"/>)_||_
			Ein thema "Inhaber des GMD" umfaßt nur ein "Content"-Element vom Typ "hcparty". (Zahl: <iso:value-of select="count(kmehr:content/kmehr:hcparty)"/>)</iso:assert>
	</iso:rule>
</iso:pattern>

<iso:pattern id="gmdmanager-contents.structure.checks">
	<iso:title>GMD Manager content structure checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='sumehr']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='gmdmanager']]/kmehr:content/kmehr:hcparty">
			<iso:assert test="count(kmehr:id[@S = 'ID-HCPARTY']) > 0" id="GMD Manager" role="ERROR" flag="structure"  >
			GMD Manager must have one INAMI/RIZIV number and only one. (Number: <iso:value-of select="count(kmehr:id[@S = 'ID-HCPARTY'])"/>)_||_
			Un  item "detenteur de DMG" doit contenir un et un seul numéro INAMI/RIZIV. (Nombre: <iso:value-of select="count(kmehr:id[@S = 'ID-HCPARTY'])"/>)_||_
			Een item "GMD-houder" moet één enkel RIZIV-nummer bevatten. (Aantal: <iso:value-of select="count(kmehr:id[@S = 'ID-HCPARTY'])"/>)_||_
			Ein thema "Inhaber des GMD" darf nur eine LIKIV-Nummer umfassen. (Zahl: <iso:value-of select="count(kmehr:id[@S = 'ID-HCPARTY'])"/>)</iso:assert>
	</iso:rule>	
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='sumehr']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='gmdmanager']]/kmehr:content/kmehr:hcparty[kmehr:familyname]/kmehr:cd[@S='CD-HCPARTY']">
			<iso:assert test="current()='persphysician'" id="GMD Manager" role="ERROR" flag="structure"  >
			If GMD Manager is a person (with familyname) then his "role" (official CD-HCPARTY) must be "persphysician". (Code: "<iso:value-of select="current()"/>")_||_
			Si un item "détenteur de DMG" est une personne (avec un nom de famille) alors son "rôle" (CD-HCPARTY officiel) doit être "persphysician". (Code: "<iso:value-of select="current()"/>")_||_
			Indien een item "GMD-houder" een persoon (met familienaam) is, dan moet zijn "rol" (officiële CD-HCPARTY) "persphysician" zijn. (Code: "<iso:value-of select="current()"/>")_||_
			Wenn ein thema "Inhaber des GMD" eine Person mit einem Familiennamen ist, dann muss seine offizielle Rolle "persphysician" sein. (Code: "<iso:value-of select="current()"/>")</iso:assert>
	</iso:rule>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='sumehr']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='gmdmanager']]/kmehr:content/*">
			<iso:assert test="(local-name()='hcparty')" id="GMD Manager" role="ERROR" flag="structure"  >
			A "GMD Manager" content can contain only element "hcparty". (Element: "<iso:value-of select="local-name()"/>")_||_
			L'élément content d'un item "détenteur de DMG" ne peut contenir que des éléments "hcparty". (Elément: "<iso:value-of select="local-name()"/>")_||_
			Het "content"-element van een item "GMD-houder" kan enkel "hcparty"-elementen omvatten. (Element: "<iso:value-of select="local-name()"/>")_||_
			Das "Content"-Element eines Themas "Inhaber des GMD" kann nur "hcparty"-Elemente umfassen. (Element: "<iso:value-of select="local-name()"/>")</iso:assert>
	</iso:rule>
</iso:pattern>

<iso:pattern id="gmdmanager.structure.warnings.checks">
	<iso:title>GMD Manager warnings checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary'  or .='sumehr']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='gmdmanager']]/kmehr:content/kmehr:hcparty">
			<iso:assert test="kmehr:address" id="GMD Manager" role="WARNING" flag="structure"  >
			GMD Manager should have at least one address._||_
			Un item "détenteur de DMG" devrait contenir au moins une adresse._||_
			Een item "GMD-houder" zou minstens een adres moeten bevatten._||_
			Ein thema "Inhaber des GMD" sollte mindestens eine Adresse umfassen.</iso:assert>
			<iso:assert test="kmehr:telecom" id="GMD Manager" role="WARNING" flag="structure"  >
			GMD Manager should have at least one telecom._||_
			Un item "détenteur de DMG" devrait contenir au moins un moyen de télécommunication._||_
			Een item "GMD-houder" zou minstens een telecommunicatiemiddel moeten bevatten._||_
			Ein thema "Inhaber des GMD" sollte mindestens ein Telekommunikationsmittel umfassen.</iso:assert>
	</iso:rule>
</iso:pattern> 

<!-- HEALTHCARELEMENTS -->
<iso:pattern id="healthcareelement.structure.checks">
	<iso:title>Healthcare Element structure checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='sumehr']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='healthcareelement']]">
			<iso:assert test="count(kmehr:content[kmehr:text]) = 1" id="Healthcare Element" role="ERROR" flag="structure"  >
			Healthcare Element must have one and only one content with "text" elements (label). (Number: <iso:value-of select="count(kmehr:content[kmehr:text])"/>)_||_
			Un item "Problème actuel" ou "Elément de soin passif" doit contenir un et un seul "content" contenant des éléments "text"(label). (Nombre: <iso:value-of select="count(kmehr:content[kmehr:text])"/>)_||_
			Een item "huidig probleem" of "passief zorgelement" mag één enkel "content" met een "text"-elementen (label) bevatten. (Aantal: <iso:value-of select="count(kmehr:content[kmehr:text])"/>)_||_
			Ein thema "heutiges Problem" oder "passives Sorgeelement" darf nur einen "Content" mit einem "Text"-Elementen (Label) umfassen. (Zahl: <iso:value-of select="count(kmehr:content[kmehr:text])"/>)</iso:assert>
			<iso:assert test="count(kmehr:content[kmehr:cd]) &lt; 2" id="Healthcare Element" role="ERROR" flag="structure"  >
			Healthcare Element must have maximum one content with "cd" elements (codification). (Number: <iso:value-of select="count(kmehr:content[kmehr:cd])"/>)_||_
			Un  item "Problème actuel" ou "Elément de soin passif"  doit contenir au plus un "content" constitué d'éléments "cd"(codification). (Nombre: <iso:value-of select="count(kmehr:content[kmehr:cd])"/>)_||_
			Een item "huidig probleem" of "passief zorgelement" mag maximaal een "content" met "cd"-elementen (codificatie) omvatten. (Aantal: <iso:value-of select="count(kmehr:content[kmehr:cd])"/>)_||_
			Ein thema "heutiges Problem" oder "passives Sorgeelement" darf maximal einen "Content" mit "CD"-Elementen (Kodifikation) umfassen. (Zahl: <iso:value-of select="count(kmehr:content[kmehr:cd])"/>)</iso:assert>
			<iso:assert test="kmehr:lifecycle/kmehr:cd[@S='CD-LIFECYCLE']='active' or kmehr:lifecycle/kmehr:cd[@S='CD-LIFECYCLE']='inactive'" id="Healthcare Element" role="ERROR" flag="structure"  >
			Healthcare Element must have one element "lifecycle", either "active" or "inactive". _||_
			Un  item "Problème actuel" ou "Elément de soin passif" contient un élément "lifecycle", soit "active" ou "inactive"._||_
			Een item "huidig probleem" of "passief zorgelement" bevat een element "lifecycle", ofwel "actief" of "non-actief"._||_
			Ein Thema "heutiges Problem" oder "passives Sorgeelement" umfaßt ein Element "Lifecycle", entweder "aktiv" oder "nicht aktiv".</iso:assert>
	</iso:rule>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='sumehr']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='healthcareelement']]/kmehr:content/*">
			<iso:assert test="(local-name()='cd' or local-name()='text')" id="Healthcare Element" role="ERROR" flag="structure"  >
			A "<iso:value-of select="../../kmehr:cd[@S='CD-ITEM']"/>" content can contain only elements "text" or "cd". (Element: "<iso:value-of select="local-name()"/>")_||_
			Un content "<iso:value-of select="../../kmehr:cd[@S='CD-ITEM']"/>" ne peut contenir que des éléments "text" ou "cd". (Elément: "<iso:value-of select="local-name()"/>")_||_
			Een content "<iso:value-of select="../../kmehr:cd[@S='CD-ITEM']"/>" kan enkel "text"- of "cd"-elementen bevatten. (Element: "<iso:value-of select="local-name()"/>")_||_
			Ein "Content" "<iso:value-of select="../../kmehr:cd[@S='CD-ITEM']"/>" kann nur "Text"- oder "CD"-Elemente umfassen. (Element: "<iso:value-of select="local-name()"/>")</iso:assert>
	</iso:rule>
</iso:pattern>

<iso:pattern id="healthcareelement.structure.warnings.checks">
	<iso:title>Healthcare Element checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='sumehr']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='healthcareelement']]">
			<iso:assert test="kmehr:content/kmehr:cd" id="Healthcare Element" role="WARNING" flag="structure"  >
			Healthcare Element should have a content with codified informations (cd). (Label: "<iso:value-of select="kmehr:content/kmehr:text"/>")_||_
			Un item "Problème actuel" ou "Elément de soin passif" devrait contenir un élément "content" contenant un "cd". (Label: "<iso:value-of select="kmehr:content/kmehr:text"/>")_||_
			Een item "huidig probleem" of "passief zorgelement" zou een element "content" met een "cd"-element moeten bevatten. (Label: "<iso:value-of select="kmehr:content/kmehr:text"/>")_||_
			Ein Thema "heutiges Problem" oder "passives Sorgeelement" sollte ein Element "Content" mit einem "CD"-Element umfassen. (Label: "<iso:value-of select="kmehr:content/kmehr:text"/>")</iso:assert>
	</iso:rule>
</iso:pattern>

<!-- CURRENT PROBLEMS -->
<iso:pattern id="currentproblems.structure.checks">
	<iso:title>Current Problems structure checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='sumehr']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='healthcareelement'] and kmehr:lifecycle[kmehr:cd[ @S ='CD-LIFECYCLE' and .='active' ]]]">
			<iso:assert test="kmehr:beginmoment" id="Healthcare Element" role="ERROR" flag="structure"  >
			Current Problem must have a "beginmoment"._||_
			Un item "Problème actuel" doit contenir un "beginmoment"._||_
			Een item "huidig probleem" moet een beginmoment hebben._||_
			Ein Thema "heutiges Problem" muss einen "Anfangmoment" haben.</iso:assert>
	</iso:rule>
</iso:pattern>

<!-- RELEVANT PASSIVE CARE ELEMENT -->
<iso:pattern id="relevantpassivecareelements.warning.checks">
	<iso:title>Relevant Passive Care Elements structure checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='sumehr']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='healthcareelement'] and kmehr:lifecycle[kmehr:cd[ @S ='CD-LIFECYCLE' and .='inactive' ]]]">
			<iso:assert test="kmehr:endmoment" id="Healthcare Element" role="WARNING" flag="structure"  >
			Relevant Passive Care Element should have an "endmoment"._||_
			Un item "Elément de soin passif" devrait avoir une fin ("endmoment")._||_
			Een item "passief zorgelement" zou een einde ("endmoment") moeten hebben._||_
			Ein Thema "passives Sorgeelement" sollte ein Ende ("Endmoment") haben.</iso:assert>
	</iso:rule>
</iso:pattern>

<!-- RISKS -->
<iso:pattern id="risks.structure.checks">
	<iso:title>Risks structure checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='sumehr']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and ( (.='adr') or (.='allergy') or (.='socialrisk') or (.='risk') )]]">
			<iso:assert test="count(kmehr:content[kmehr:text]) = 1" id="Risk" role="ERROR" flag="structure"  >
			"<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" must have one content and only one with "text" element (label).  (Number: <iso:value-of select="count(kmehr:content[kmehr:text])"/>)_||_
			"<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" doit contenir un et un seul "content" contenant un élément "text" (label). (Nombre: <iso:value-of select="count(kmehr:content[kmehr:text])"/>)_||_
			"<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" moet één "content" met één enkel "text"-element bevatten (label). (Aantal: <iso:value-of select="count(kmehr:content[kmehr:text])"/>)_||_
			"<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" darf nur einen "Content" mit einem einzigen "Text"-Element umfassen (Label). (Zahl: <iso:value-of select="count(kmehr:content[kmehr:text])"/>)</iso:assert>
			<iso:assert test="count(kmehr:content[kmehr:cd]) &lt; 2" id="Risk" role="ERROR" flag="structure"  >
			"<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" must have maximum one content with "cd" elements (codification). (Number: <iso:value-of select="count(kmehr:content[kmehr:cd])"/>)_||_
			"<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" doit contenir au maximum un élément "content" contenant des éléments "cd" (codification). (Nombre: <iso:value-of select="count(kmehr:content[kmehr:cd])"/>)_||_
			"<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" mag maximaal een "content"-element met cd-elementen bevatten (codificatie). (Aantal: <iso:value-of select="count(kmehr:content[kmehr:cd])"/>)_||_
			"<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" darf maximal ein "Content"-Element mit CD-Elementen umfassen (Kodifikation). (Zahl): <iso:value-of select="count(kmehr:content[kmehr:cd])"/>)</iso:assert>
			<!-- Duplicate test with kmehr rule at the beginning...
			<iso:assert test="count(kmehr:content/kmehr:cd[@S='LOCAL' and not(@DN)])=0" id="Risk" role="ERROR" flag="structure"  >When local codification with "<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>", "cd" element must have attribute DN to describe. (Label: "<iso:value-of select="kmehr:content/kmehr:text"/>")_||_french message_||_dutch message_||_german message</iso:assert> -->
	</iso:rule>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='sumehr']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and ( (.='adr') or (.='allergy') or (.='socialrisk') or (.='risk') )]]/kmehr:content/*">
		<iso:assert test="(local-name()='cd' or local-name()='text')" id="Risk" role="ERROR" flag="structure"  >
		A "<iso:value-of select="../../kmehr:cd[@S='CD-ITEM']"/>" content can contain only elements "text" or "cd". (Element: "<iso:value-of select="local-name()"/>")_||_
		Un élément "content" "<iso:value-of select="../../kmehr:cd[@S='CD-ITEM']"/>" peut seulement contenir des éléments "text" ou "cd". (Elément: "<iso:value-of select="local-name()"/>")_||_
		Een "content"-element "<iso:value-of select="../../kmehr:cd[@S='CD-ITEM']"/>" mag enkel "text"- of "cd"-elementen bevatten. (Element: "<iso:value-of select="local-name()"/>")_||_
		Ein "Content"-Element  "<iso:value-of select="../../kmehr:cd[@S='CD-ITEM']"/>" darf nur "Text"- oder "CD"-Elemente umfassen. (Element: "<iso:value-of select="local-name()"/>")</iso:assert>
	</iso:rule>
</iso:pattern>

<iso:pattern id="risks.structure.warnings.checks">
	<iso:title>Risks warnings checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='sumehr']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and ( (.='adr') or (.='allergy') or (.='socialrisk') or (.='risk') )]]">
			<iso:assert test="kmehr:content/kmehr:cd" id="Risk" role="WARNING" flag="structure"  >
			"<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" should have a content with codified informations (cd). (Label: "<iso:value-of select="kmehr:content/kmehr:text"/>")_||_
			"<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" devrait contenir un élément "content" avec des informations codifiées (cd). (Label: "<iso:value-of select="kmehr:content/kmehr:text"/>")_||_
			"<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" zou een "content"-element met gecodificeerde informatie moeten bevatten (cd). (Label: "<iso:value-of select="kmehr:content/kmehr:text"/>")_||_
			"<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" sollte ein "Content"-Element mit kodifizierten Informationen umfassen (CD). (Label: "<iso:value-of select="kmehr:content/kmehr:text"/>")</iso:assert>
	</iso:rule>
</iso:pattern>

<!-- MEDICATION -->
<iso:pattern id="medication.structure.checks">
	<iso:title>Medication structure checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='sumehr']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='medication']]">
			<iso:assert test="count(kmehr:content[kmehr:text]) = 1" id="Medication" role="ERROR" flag="structure"  >
			Medication must contain one (and only one) textual content corresponding to the medication label. (Number: <iso:value-of select="count(kmehr:content[kmehr:text])"/>)_||_
			Un item "médication" doit contenir un et un seul content textuel correspondant au label "medication". (Nombre: <iso:value-of select="count(kmehr:content[kmehr:text])"/>)_||_
			Een item "medicatie" moet één enkele textuele inhoud hebben die overeenstemt met de label "medicatie". (Aantal: <iso:value-of select="count(kmehr:content[kmehr:text])"/>)_||_
			Ein thema "Medikation" muss nur einen textuellen Inhalt haben, welcher mit dem Label "Medikation" übereinstimmt. (Zahl: <iso:value-of select="count(kmehr:content[kmehr:text])"/>) </iso:assert>
			<iso:assert test="count(kmehr:content[kmehr:cd[@S='CD-ATC']]) &lt; 2" id="Medication" role="ERROR" flag="structure"  >
			Medication must have maximum one content with codified ATC. (Number: <iso:value-of select="count(kmehr:content[kmehr:cd[@S='CD-ATC']])"/>)_||_
			Un item "médication" contient au plus un élément "content" contenant un code ATC. (Nombre: <iso:value-of select="count(kmehr:content[kmehr:cd[@S='CD-ATC']])"/>)_||_
			Een item "medicatie" bevat maximaal een "content"-element met een ATC-code. (Aantal: <iso:value-of select="count(kmehr:content[kmehr:cd[@S='CD-ATC']])"/>)_||_
			Ein Thema "Medikation" umfaßt maximal ein "Content"-Element mit einem ATC-Code. (Zahl: <iso:value-of select="count(kmehr:content[kmehr:cd[@S='CD-ATC']])"/>) </iso:assert>
			<iso:assert test="count(kmehr:content[kmehr:medicinalproduct or kmehr:substanceproduct or kmehr:compoundprescription]) &lt; 2" id="Medication" role="ERROR" flag="structure"  >
			Medication must contain maximum one content "medicinalproduct" or "substanceproduct" or "compoundprescription". (Number: <iso:value-of select="count(kmehr:content[kmehr:medicinalproduct or kmehr:substanceproduct or kmehr:compoundprescription])"/>)_||_
			Un item "médication" doit contenir au maximum un content "medicinalproduct", "substanceproduct" ou "compoundprescription". (Nombre: <iso:value-of select="count(kmehr:content[kmehr:medicinalproduct or kmehr:substanceproduct or kmehr:compoundprescription])"/>)_||_
			Een item "medicatie" mag maar één inhoud "medicinalproduct", "substanceproduct" of "compoundprescription" bevatten. (Aantal: <iso:value-of select="count(kmehr:content[kmehr:medicinalproduct or kmehr:substanceproduct or kmehr:compoundprescription])"/>)_||_
			Ein thema "Medikation" sollte nur ein Inhalt "medicinalproduct", "substanceproduct" oder "compoundprescription" haben. (Zahl: <iso:value-of select="count(kmehr:content[kmehr:medicinalproduct or kmehr:substanceproduct or kmehr:compoundprescription])"/>) </iso:assert>
	</iso:rule>
</iso:pattern>

<iso:pattern id="medication-contents.structure.checks">
	<iso:title>Medication content structure checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='sumehr']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='medication']]/kmehr:content">
			<iso:assert test="count(kmehr:cd[@S='CD-ATC']) &lt; 2" id="Medication" role="ERROR" flag="structure"  >
			Medication content must have maximum one codified ATC. (Number: <iso:value-of select="count(kmehr:cd[@S='CD-ATC'])"/>)_||_
			Un item "médication" doit contenir au maximum un code ATC. (Nombre: <iso:value-of select="count(kmehr:cd[@S='CD-ATC'])"/>)_||_
			Een item "medicatie" mag maximaal één ATC-code bevatten. (Aantal: <iso:value-of select="count(kmehr:cd[@S='CD-ATC'])"/>)_||_
			Ein thema "Medikation" darf nur einen textuellen Inhalt haben, welcher mit dem Label "Medikation" übereinstimmt. (Zahl: <iso:value-of select="count(kmehr:cd[@S='CD-ATC'])"/>) </iso:assert>
	</iso:rule>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='sumehr']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='medication']]/kmehr:content/*">
			<iso:assert test="(local-name()='text' or local-name()='medicinalproduct' or local-name()='substanceproduct' or local-name()='compoundprescription' or ( local-name()='cd' and @S='CD-ATC' ) )" id="Medication" role="ERROR" flag="structure"  >
			A "<iso:value-of select="../../kmehr:cd[@S='CD-ITEM']"/>" content can contain only elements "text", "medicinalproduct",  "substanceproduct", "compoundprescription" or "cd ATC". (Element: "<iso:value-of select="local-name()"/><iso:value-of select="@S"/>")_||_
			Un content "<iso:value-of select="../../kmehr:cd[@S='CD-ITEM']"/>" ne peut contenir que des éléments "text", "medicinalproduct", "substanceproduct", "compoundprescription" ou "cd ATC". (Elément: "<iso:value-of select="local-name()"/><iso:value-of select="@S"/>")_||_
			Een content "<iso:value-of select="../../kmehr:cd[@S='CD-ITEM']"/>" mag enkel de elementen "text", "medicinalproduct", "substanceproduct", "compoundprescription" of "cd ATC" bevatten. (Element: "<iso:value-of select="local-name()"/><iso:value-of select="@S"/>")_||_
			Ein Content "<iso:value-of select="../../kmehr:cd[@S='CD-ITEM']"/>" darf nur die Elemente "text", "medicinalproduct", "substanceproduct", "compoundprescription" oder "cd ATC" umfassen. (Element: "<iso:value-of select="local-name()"/><iso:value-of select="@S"/>")</iso:assert>
	</iso:rule>
</iso:pattern>

<iso:pattern id="medication.structure.warnings.checks">
	<iso:title>Medication warnings checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='sumehr']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='medication']]">
			<iso:assert test="count(kmehr:content[kmehr:medicinalproduct or kmehr:substanceproduct or kmehr:compoundprescription]) &gt; 0" id="Medication" role="WARNING" flag="structure"  >
			Medication should contain at least one content "medicinalproduct" or "substanceproduct" or "compoundprescription". (Number: <iso:value-of select="count(kmehr:content[kmehr:medicinalproduct or kmehr:substanceproduct or kmehr:compoundprescription])"/>)_||_
			Un item "médication" devrait contenir au moins un content "medicinalproduct", "substanceproduct" ou "compoundprescription". (Nombre: <iso:value-of select="count(kmehr:content[kmehr:medicinalproduct or kmehr:substanceproduct or kmehr:compoundprescription])"/>)_||_
			Een item "medicatie"  zou maar één inhoud "medicinalproduct", "substanceproduct" of "compoundprescription" mogen bevatten. (Aantal: <iso:value-of select="count(kmehr:content[kmehr:medicinalproduct or kmehr:substanceproduct or kmehr:compoundprescription])"/>)_||_
			Ein thema "Medikation" sollte nur ein Inhalt "medicinalproduct", "substanceproduct" oder "compoundprescription" haben. (Zahl: <iso:value-of select="count(kmehr:content[kmehr:medicinalproduct or kmehr:substanceproduct or kmehr:compoundprescription])"/>) </iso:assert>
			<iso:assert test="kmehr:content[kmehr:cd[@S='CD-ATC']]" id="Medication" role="WARNING" flag="structure"  >
			Medication should have one content with codified ATC._||_
			Un item "médication" devrait contenir un élément "content" contenant un code ATC._||_
			Een item "medicatie" zou één enkel "content"-element met een ATC-code moeten hebben._||_
			Ein thema "Medikation" darf nur einen "Content"-Element mit einem ATC-Code haben. </iso:assert>			
			<iso:assert test="kmehr:beginmoment" id="Medication" role="WARNING" flag="structure"  >
			Medication should have one "beginmoment"._||_
			Un item "médication" devrait contenir un élément "beginmoment"._||_
			Een item "medication" zou een "beginmoment" moeten hebben._||_
			Ein thema "Medikation" darf nur einen "beginmoment"-Element haben. </iso:assert>
			<iso:assert test="kmehr:endmoment" id="Medication" role="WARNING" flag="structure"  >
			Medication should have one "endmoment"._||_
			Un item "médication" devrait contenir un élément "endmoment"._||_
			Een item "medication" zou een "endmoment" moeten hebben._||_
			Ein thema "Medikation" darf nur einen "endmoment"-Element haben. </iso:assert>
	</iso:rule>
</iso:pattern>


<!-- VACCINE -->
<iso:pattern id="vaccine.structure.checks">
	<iso:title>Vaccine structure checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='sumehr']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='vaccine']]">
			<iso:assert test="kmehr:content[kmehr:cd[@S='CD-VACCINEINDICATION']]" id="Vaccine" role="ERROR" flag="structure"  >
			Vaccine must have at least one content code CD-VACCINEINDICATION"._||_
			Un item  "vaccin administré" doit contenir au moins un élément "content" contenant un code de CD-VACCINEINDICATION_||_
			Een item "toegediende vaccin" moet minstens een "content"-element met een  CD-VACCINEINDICATION-code hebben._||_
			Ein Thema "durchgeführte Impfung" muss mindestens ein "Content"-Element mit einem CD-VACCINEINDICATION-Code haben.</iso:assert>
			<iso:assert test="count(kmehr:content[kmehr:medicinalproduct or kmehr:substanceproduct]) &lt; 2" id="Vaccine" role="ERROR" flag="structure"  >
			Vaccine must contain maximum one content "medicinalproduct" or "substanceproduct". (Number: <iso:value-of select="count(kmehr:content[kmehr:medicinalproduct or kmehr:substanceproduct])"/>)_||_
			Un item  "vaccin administré" doit contenir au maximum un content "medicinalproduct" ou "substanceproduct". (Nombre: <iso:value-of select="count(kmehr:content[kmehr:medicinalproduct or kmehr:substanceproduct])"/>)_||_
			Een item "toegediende vaccin"  mag maximaal één inhoud "medicinalproduct" of "substanceproduct" bevatten. (Aantal: <iso:value-of select="count(kmehr:content[kmehr:medicinalproduct or kmehr:substanceproduct])"/>)_||_
			Ein thema "durchgeführte Impfung" soll nur ein Inhalt "medicinalproduct" oder "substanceproduct" haben. (Zahl: <iso:value-of select="count(kmehr:content[kmehr:medicinalproduct or kmehr:substanceproduct])"/>)</iso:assert>
			<iso:assert test="count(kmehr:content[kmehr:cd[@S='CD-ATC']]) &lt; 2" id="Vaccine" role="ERROR" flag="structure"  >
			Vaccine must have maximum one content with codified ATC. (Number: <iso:value-of select="count(kmehr:content[kmehr:cd[@S='CD-ATC']])"/>)_||_
			Un item "vaccin administré" doit contenir au maximum un élément "content" contenant un code ATC. (Nombre: <iso:value-of select="count(kmehr:content[kmehr:cd[@S='CD-ATC']])"/>)_||_
			Een item "toegediende vaccin" mag maximaal een "content"-element met een ATC-code hebben. (Aantal: <iso:value-of select="count(kmehr:content[kmehr:cd[@S='CD-ATC']])"/>)_||_
			Ein thema "durchgeführte Impfung" darf maximal ein "Content"-Element mit einem ATC-Code haben. (Zahl:  <iso:value-of select="count(kmehr:content[kmehr:cd[@S='CD-ATC']])"/>)</iso:assert>
	</iso:rule>	
</iso:pattern>

<iso:pattern id="vaccine-contents.structure.checks">
	<iso:title>Vaccine content structure checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='sumehr']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='vaccine']]/kmehr:content">
			<iso:assert test="count(kmehr:cd[@S='CD-ATC']) &lt; 2" id="Vaccine" role="ERROR" flag="structure"  >
			Vaccine content must have maximum one codified ATC. (Number: <iso:value-of select="count(kmehr:cd[@S='CD-ATC'])"/>)_||_
			Un item "vaccin administré" doit contenir au maximum un code ATC. (Nombre: <iso:value-of select="count(kmehr:cd[@S='CD-ATC'])"/>)_||_
			Een item "toegediende vaccin" mag maximaal een ATC-code hebben. (Aantal: <iso:value-of select="count(kmehr:cd[@S='CD-ATC'])"/>)_||_
			Ein thema "durchgeführte Impfung" darf maximal ein "ATC-Code haben. (Zahl:  <iso:value-of select="count(kmehr:cd[@S='CD-ATC'])"/>)</iso:assert>
	</iso:rule>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary'  or .='sumehr']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='vaccine']]/kmehr:content/*">
		<iso:assert test="(local-name()='medicinalproduct' or local-name()='substanceproduct' or ( local-name()='cd' and (@S='CD-ATC' or @S='CD-VACCINEINDICATION') ) )" id="Vaccine" role="ERROR" flag="structure"  >
		A "<iso:value-of select="../../kmehr:cd[@S='CD-ITEM']"/>" content can contain only elements "medicinalproduct",  "substanceproduct", "cd VACCINEINDICATION" or "cd ATC". (Element: "<iso:value-of select="local-name()"/><iso:value-of select="@S"/>")_||_
		Un content "<iso:value-of select="../../kmehr:cd[@S='CD-ITEM']"/>" ne peut contenir que des éléments "medicinalproduct", "substanceproduct", "cd VACCINEINDICATION" ou "cd ATC". (Elément: "<iso:value-of select="local-name()"/><iso:value-of select="@S"/>")_||_
		Een content "<iso:value-of select="../../kmehr:cd[@S='CD-ITEM']"/>" mag enkel  de elementen "medicinalproduct", "substanceproduct", "cd VACCINEINDICATION" of "cd ATC" bevatten. (Element: "<iso:value-of select="local-name()"/><iso:value-of select="@S"/>")_||_
		Ein Content "<iso:value-of select="../../kmehr:cd[@S='CD-ITEM']"/>" darf nur die Elemente "medicinalproduct", "substanceproduct", "cd VACCINEINDICATION" oder "cd ATC" umfassen. (Element: "<iso:value-of select="local-name()"/><iso:value-of select="@S"/>")</iso:assert>
	</iso:rule>
</iso:pattern>

<iso:pattern id="vaccine.structure.warnings.checks">
	<iso:title>Vaccine warnings checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='sumehr']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='vaccine']]">
			<iso:assert test="count(kmehr:content[kmehr:medicinalproduct or kmehr:substanceproduct]) &gt; 0" id="Vaccine" role="WARNING" flag="structure"  >
			Vaccine should contain at least one content "medicinalproduct" or "substanceproduct". (Number: <iso:value-of select="count(kmehr:content[kmehr:medicinalproduct or kmehr:substanceproduct])"/>)_||_
			Un item  "vaccin administré" devrait contenir au moins un content "medicinalproduct" ou "substanceproduct". (Nombre: <iso:value-of select="count(kmehr:content[kmehr:medicinalproduct or kmehr:substanceproduct])"/>)_||_
			Een item "toegediende vaccin"  zou één enkele inhoud "medicinalproduct" of "substanceproduct" mogen bevatten. (Aantal: <iso:value-of select="count(kmehr:content[kmehr:medicinalproduct or kmehr:substanceproduct])"/>)_||_
			Ein thema "durchgeführte Impfung" sollte nur einen Inhalt "medicinalproduct" oder "substanceproduct" haben. (Zahl: <iso:value-of select="count(kmehr:content[kmehr:medicinalproduct or kmehr:substanceproduct])"/>)</iso:assert>			
			<iso:assert test="kmehr:content[kmehr:cd[@S='CD-ATC']]" id="Vaccine" role="WARNING" flag="structure"  >
			Vaccine should have one content with codified ATC._||_
			Un item "vaccin administré" devrait contenir un élément "content" contenant un code ATC._||_
			Een item "toegediende vaccin"  zou een "content"-element met een ATC-code moeten bevatten._||_
			Ein thema "durchgeführte Impfung" sollte ein "Content"-Element mit einem ATC-Code haben.</iso:assert>
			<iso:assert test="kmehr:beginmoment" id="Vaccine" role="WARNING" flag="structure"  >
			Vaccine should have a "beginmoment"._||_
			Un item  "vaccin administré" devrait contenir une date d'administration ("beginmoment")._||_
			Een item "toegediende vaccin"  zou een datum van toediening moeten bevatten. ("begin moment")._||_
			Ein Thema "durchgeführte Impfung" sollte ein Impfungsdatum haben.("begin moment")</iso:assert>
	</iso:rule>
</iso:pattern>

<!-- PATIENTWILL -->
<iso:pattern id="patientwill.structure.checks">
	<iso:title>Patientwill structure checks</iso:title>	
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary'  or .='sumehr']]//kmehr:item[kmehr:cd[@S ='CD-ITEM' and .='patientwill']]">
			<iso:assert test="count(kmehr:content[kmehr:cd]) = 1" id="Patient Will" role="ERROR" flag="structure" >
			Patient Will must have one and only one content with "cd" elements (code). (Number: <iso:value-of select="count(kmehr:content[kmehr:cd])"/>)_||_
			Un item  "volonté du patient" doit contenir un et un seul élément "content" contenant des éléments "cd" (code). (Nombre: <iso:value-of select="count(kmehr:content[kmehr:cd])"/>)_||_
			Een item "wil van de patiënt" mag één enkel "content"-element met "cd"-elementen (code) bevatten (Aantal: <iso:value-of select="count(kmehr:content[kmehr:cd])"/>)_||_
			Ein Thema "Patientenwille" darf nur ein "Content"-Element mit "CD"-Elementen (Code) umfassen. (Zahl: <iso:value-of select="count(kmehr:content[kmehr:cd])"/>)</iso:assert>		
			<iso:assert test="count(kmehr:content[kmehr:text]) &lt; 2" id="Patient Will" role="ERROR" flag="structure" >
			Patient Will must have maximum one content with "text" elements. (Number: <iso:value-of select="count(kmehr:content[kmehr:text])"/>)_||_
			Un item "volonté du patient" doit contenir au maximum un élément "content" contenant des éléments "text". (Nombre: <iso:value-of select="count(kmehr:content[kmehr:text])"/>)_||_
			Een item "wil van de patiënt" mag maximaal één "content"-element met "text"-elementen (code) bevatten (Aantal: <iso:value-of select="count(kmehr:content[kmehr:text])"/>)_||_
			Ein Thema "Patientenwille" darf maximal ein "Content"-Element mit "Text"-Elementen (Code) umfassen. (Zahl: <iso:value-of select="count(kmehr:content[kmehr:text])"/>)</iso:assert>
	</iso:rule>
</iso:pattern>

<iso:pattern id="patientwill-contents.structure.checks">
	<iso:title>Patientwill content structure checks</iso:title>	
		<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='sumehr']]/kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='patientwill']]/kmehr:content/*">
			<iso:assert test="((local-name()='cd' and current()[@S ='CD-PATIENTWILL']) or local-name()='text' or local-name()='boolean')" id="Patient Will" role="ERROR" flag="structure"  >
			A "<iso:value-of select="../../kmehr:cd[@S='CD-ITEM']"/>" content can contain only elements "text", "boolean" or "cd" with CD-PATIENTWILL codification. (Element: "<iso:value-of select="local-name()"/>")_||_
			Un content "<iso:value-of select="../../kmehr:cd[@S='CD-ITEM']"/>" ne peut contenir que des éléments "text", "boolean" ou "cd" contenant un code de CD-PATIENTWILL. (Elément: "<iso:value-of select="local-name()"/>")_||_
			Een content "<iso:value-of select="../../kmehr:cd[@S='CD-ITEM']"/>" mag enkel "text"-, "boolean"- of "cd"-elementen met een code CD-PATIENTWILL bevatten. (Element: "<iso:value-of select="local-name()"/>")_||_
			Ein Inhalt "<iso:value-of select="../../kmehr:cd[@S='CD-ITEM']"/>" darf nur "Text"-, "Boolean"- oder "CD"-Elemente mit einem CD-PATIENTWILL-Code umfassen. (Element: "<iso:value-of select="local-name()"/>")</iso:assert>		
	</iso:rule>
</iso:pattern>

</iso:schema>