<?xml version="1.0" encoding="UTF-8"?>
<!-- 
Property : eHealth
Author   : eHealth 
Date     : 01/07/2011
Version 1.0 Written for ehValidator library and tool

This is a schematron file.
The purpose of this schematron is to check sumehr rules on a kmehr file.
Checked input file must be a correct kmehr XML file.

schematron: http://www.schematron.com
Kmehr  definition: https://www.ehealth.fgov.be/standards/kmehr/en/home/home/index.xml
SMF definition: https://www.ehealth.fgov.be/standards/kmehr/content/website/home/rules/specialmessages/GP_software_migration.xml
eHealth: https://www.ehealth.fgov.be
-->
<iso:schema 	xmlns="http://purl.oclc.org/dsdl/schematron"
						xmlns:iso="http://purl.oclc.org/dsdl/schematron"
						xmlns:sch="http://www.ascc.net/xml/schematron"
						xmlns:kmehr="http://www.ehealth.fgov.be/standards/kmehr/schema/v1"
						queryBinding="xslt2"
						schemaVersion="ISO19757-3" defaultPhase='#ALL'
						>
	
		<iso:title>Checking a SMF document</iso:title>
		<iso:ns prefix="kmehr" uri="http://www.ehealth.fgov.be/standards/kmehr/schema/v1" />
		
<!-- CONFIDENTIALITY -->
<iso:pattern id="confidentiality.structure.checks">
	<iso:title>Confidentiality structure checks</iso:title>
	<iso:rule context="kmehr:confidentiality">
			<iso:assert test="count(kmehr:hcparty) = 1" id="Confidentiality" role="ERROR" flag="structure"  >
			Element "confidentiality" must have one and only one hcparty. (Number: <iso:value-of select="count(kmehr:hcparty)"/>)_||_
			Un élément "confidentiality" doit avoir un et un seul élément "contact-prestataire de soin". (Nombre: <iso:value-of select="count(kmehr:hcparty)"/>)_||_
			Een element "confidentiality" moet één enkel element "hcparty" bevatten. (Aantal: <iso:value-of select="count(kmehr:hcparty)"/>)_||_
			Element "confidentiality" kann nur ein hcparty element umfassen. (Nummer: <iso:value-of select="count(kmehr:hcparty)"/>)
			</iso:assert>
	</iso:rule>
	<iso:rule context="kmehr:confidentiality/kmehr:hcparty/kmehr:cd[@S='CD-HCPARTY']">
			<iso:assert test="starts-with(current(),'pers')" id="Confidentiality" role="ERROR" flag="structure"  >
			A Contact Hcparty "role" (official CD-HCPARTY) in a "confidentiality" element must start with "pers". (Code: "<iso:value-of select="current()"/>")_||_
			Le rôle d'un item "contact-prestataire de soin" (CD-HCPARTY officiel) dans un élément "confidentiality" doit commencer par "pers". (Code: "<iso:value-of select="current()"/>")_||_
			De rol van een item "hcparty" in een "confidential" element moet starten met "pers". (Code: "<iso:value-of select="current()"/>")_||_
			Eine Rolle "Contact" fur ein Hcparty (offizielles CD-HCPARTY) in ein Element "confidentiality" sollte beginnen mit "pers". (Code: "<iso:value-of select="current()"/>")
			</iso:assert>
	</iso:rule>	
</iso:pattern>

<!-- STANDARD -->
<iso:pattern id="standard.structure.checks" role="specilisation">
	<iso:title>Standard structure checks</iso:title>
	<iso:rule context="kmehr:header/kmehr:standard[kmehr:cd[@S='CD-STANDARD']]" >
			<iso:assert test="kmehr:cd[@S='CD-STANDARD' and .&gt; '20110700']" id="Standard" role="ERROR" flag="structure" >
			"standard" element must be equal or higher than "20110701"._||_
			L'élément "standard" doit être égal ou plus grand que "20110701"._||_
			het element "standard" moet gelijk zijn of hoger dan "20110701"._||_
			Das Element "standard" sollte egal oder grosser sein als "20110701".</iso:assert>
	</iso:rule>
</iso:pattern>

<!-- SPECIALISATION -->
<iso:pattern id="specialisation.structure.checks" role="specialisation">
	<iso:title>Specialisation structure checks</iso:title>
	<iso:rule context="kmehr:header/kmehr:standard[kmehr:cd[@S='CD-STANDARD']]" >
			<iso:assert test="kmehr:specialisation" id="Specialisation" role="ERROR" flag="structure" >
			SMF format must have a "specialisation" element._||_
			Un format SMF doit avoir un élément "specialisation"._||_
			SMF formaat moet een "specialisation" element bevatten._||_
			Das PMF Format sollte ein "specialisation" Element umfassen.</iso:assert>
	</iso:rule>
	<iso:rule context="kmehr:header/kmehr:standard[kmehr:cd[@S='CD-STANDARD']]/kmehr:specialisation" >
			<iso:assert test="kmehr:cd[@S='CD-MESSAGE' and .='gpsoftwaremigration']" id="Specialisation" role="ERROR" flag="structure" >
			The specialisation must be 'gpsoftwaremigration'. (Code: "<iso:value-of select="kmehr:cd"/>")_||_
			La spécialisation doit être 'gpsoftwaremigration'. (Code: "<iso:value-of select="kmehr:cd"/>")_||_
			De specialisatie moet zijn 'gpsoftwaremigration'. (Code: "<iso:value-of select="kmehr:cd"/>")_||_
			Die Spezialisierung sollte 'gpsoftwaremigration' sein. (Code: "<iso:value-of select="kmehr:cd"/>")</iso:assert>
	</iso:rule>
</iso:pattern>


<!-- FOLDER -->
<iso:pattern id="folder.structure.checks" role="folder">
	<iso:title>Folder structure checks</iso:title>
	<iso:rule context="kmehr:kmehrmessage" >
			<iso:assert test="count(kmehr:folder) = 1" id="Folder" role="ERROR" flag="structure" >
			SMF format must have only one folder. (Number: <iso:value-of select="count(kmehr:folder)"/>)_||_
			Un format SMF doit contenir un seul élément "folder" (Nombre: <iso:value-of select="count(kmehr:folder)"/>)_||_
			SMF formaat mag maar één folder bevatten (Aantal: <iso:value-of select="count(kmehr:folder)"/>)_||_
			Das PMF Format sollte nur ein Folder umfassen. (Zahl: <iso:value-of select="count(kmehr:folder)"/>)</iso:assert>
	</iso:rule>
</iso:pattern>

<!-- TRANSACTION -->
<iso:pattern id="transaction.structure.checks" role="transaction">
	<iso:title>Transaction structure checks</iso:title>
	<iso:rule context="kmehr:transaction/kmehr:cd[@S = 'CD-TRANSACTION']" >
			<iso:assert test="local-name()='cd' and .='clinicalsummary' or .='labresult' or .='result' or .='note' or .='contactreport' or .='pharmaceuticalprescription' or .='report' or .='notification' or .='prescription'" id="Transaction" role="ERROR" flag="structure" >
			Transaction must be one of these: "clinicalsummary", "labresult", "result", "note", "contactreport", "pharmaceuticalprescription", "report", "notification", "prescription". (Actual: <iso:value-of select="."/>)_||_
			Une transaction doit faire partie de celles-ci: "clinicalsummary", "labresult", "result", "note", "contactreport", "pharmaceuticalprescription", "report", "notification", "prescription". (Actuel: <iso:value-of select="."/>)_||_
			De toegelaten transacties zijn: "clinicalsummary", "labresult", "result", "note", "contactreport", "pharmaceuticalprescription", "report", "notification", "prescription". (Actueel: <iso:value-of select="."/>)_||_
			Die Transaktion sollte einer dieze sein: "clinicalsummary", "labresult", "result", "note", "contactreport", "pharmaceuticalprescription", "report", "notification", "prescription". (Aktuell: <iso:value-of select="."/>)</iso:assert>
	</iso:rule>
	<iso:rule context="kmehr:folder" >
			<iso:assert test="count(kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary']]) = 1" id="Transaction" role="ERROR" flag="structure" >
			SMF format must contain one and only one "clinicalsummary" transaction. (Number: <iso:value-of select="count(kmehr:transaction/kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary'])"/>)_||_
			Un format SMF doit contenir une et une seule transaction "clinicalsummary". (Nombre: <iso:value-of select="count(kmehr:transaction/kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary'])"/>)_||_
			Het SMF formaat moet één enkele "clinicalsummary" transactie bevatten. (Aantal: <iso:value-of select="count(kmehr:transaction/kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary'])"/>)_||_
			PMF Format sollte nur ein "clinicalsummary" Transaktion umfassen. (Zahl: <iso:value-of select="count(kmehr:transaction/kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary'])"/>)</iso:assert>		
	</iso:rule>
</iso:pattern>

<iso:pattern id="transaction.structure.warnings.checks" role="transaction">
	<iso:title>Transaction structure warnings checks</iso:title>	
	<iso:rule context="kmehr:transaction[kmehr:cd[@S = 'CD-TRANSACTION' and .='clinicalsummary' or .='contactreport' or .='labresult' or .='result' or .='note' or .='pharmaceuticalprescription' or .='report' or .='notification' or .='prescription']]" >
			<iso:assert test="kmehr:id[@S='LOCAL' and @SL='MF-ID']" id="Transaction" role="WARNING" flag="structure"  >		
			Transaction should have a "MF-ID"._||_
			Une transaction devrait avoir un "MF-ID"._||_
			Een transactie mag een MF-ID bevatten._||_
			Die Transaktion sollte ein MF-ID umfassen.</iso:assert>
	</iso:rule>
</iso:pattern>

<!-- PATIENT -->
<iso:pattern id="patient.structure.checks">
	<iso:title>Patient structure checks</iso:title>
	<iso:rule context="kmehr:patient">
			 <iso:assert test="kmehr:id[@S='LOCAL']" id="Patient" role="ERROR" flag="structure" >
			The software specific identifer must be specified by a local id._||_
			L'identifiant spécifique du software doit être précisé par un "id" local._||_
			De software-specifieke identificatie moet door een lokale identifier gedefiniëerd zijn._||_
			Die Software-specifische Kennzeichnung sollte ein lokalen ID nützen.</iso:assert>
			<iso:assert test="kmehr:recorddatetime" id="Patient" role="ERROR" flag="structure" >
			Patient must have a recorddatetime._||_
			Le patient doit avoir une date d'enregistrement._||_
			De patiënt moet een registratiedatum hebben._||_
			Patient sollte ein "recorddatetime" umfassen.</iso:assert>
	</iso:rule>
</iso:pattern>

<!-- CLINICALSUMMARY -->
<iso:pattern id="clinicalsummary.structure.checks">
	<iso:title>Clinicalsummary structure checks</iso:title>
	<!--<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary']]//kmehr:item/kmehr:cd[@S = 'CD-ITEM']">
			<iso:assert test="	 
								(current()='adr') or 
								(current()='allergy') or 
								(current()='careplansubscription') or 
								(current()='contacthcparty') or
								(current()='contactperson') or  
								(current()='familyrisk') or 
								(current()='gmdmanager') or
								(current()='healthcareelement') or
								(current()='insurancystatus') or 
								(current()='medication') or
								(current()='patientwill') or 
								(current()='professionalrisk') or
								(current()='risk') or
								(current()='socialrisk') or  
								(current()='vaccine')" 
					id="Item" role="ERROR" flag="structure"  >
					Item code must be one of these: "adr", "allergy", "careplansubscription", "contacthcparty", "contactperson", "familyrisk", "gmdmanager", "healthcareelement", "insurancystatus", "medication", "patientwill", "professionalrisk", "risk", "socialrisk", "vaccine". (CD-ITEM: "<iso:value-of select="current()"/>")_||_
					Le code d'un item doit être un de ceux-ci: "adr", "allergy", "careplansubscription", "contacthcparty", "contactperson", "familyrisk", "gmdmanager", "healthcareelement", "insurancystatus", "medication", "patientwill", "professionalrisk", "risk", "socialrisk", "vaccine". (CD-ITEM: "<iso:value-of select="current()"/>")_||_
					De code van een item moet één van de volgende zijn: "adr", "allergy", "careplansubscription", "contacthcparty", "contactperson", "familyrisk", "gmdmanager", "healthcareelement", "insurancystatus", "medication", "patientwill", "professionalrisk", "risk", "socialrisk", "vaccine". (CD-ITEM: "<iso:value-of select="current()"/>")_||_
					Der Code eines Themas muss einer der folgenden sein: "adr", "allergy", "careplansubscription", "contacthcparty", "contactperson", "familyrisk", "gmdmanager", "healthcareelement", "insurancystatus", "medication", "patientwill", "professionalrisk", "risk", "socialrisk", "vaccine". (CD-ITEM: "<iso:value-of select="current()"/>")</iso:assert>
	</iso:rule>-->
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary']]">
			<iso:assert test="count(//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='insurancystatus']]) = 1" id="Insurancy Status" role="ERROR" flag="structure"  >
			Clinical summary must contain one and only one Insurancy status. (Number: <iso:value-of select="count(//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='insurancystatus']])"/>)_||_
			Une transaction "clinicalsummary" doit contenir un et un seul item "insurancystatus". (Nombre: <iso:value-of select="count(//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='insurancystatus']])"/>)_||_
			Een transactie van het type 'clinicalsummary' moet één enkel "insurancystatus' bevatten. (Aantal: <iso:value-of select="count(//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='insurancystatus']])"/>)_||_
			Ein Transaktion "clinicalsummary" sollte exact ein Thema "insurancystatus" umfassen. (Zahl: <iso:value-of select="count(//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='insurancystatus']])"/>)</iso:assert>
	</iso:rule>
</iso:pattern>

<!-- CONTACT REPORT -->
<iso:pattern id="contactreport.structure.checks">
	<iso:title>ContactReport structure checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='contactreport']]">
			<iso:assert test="count(kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='encountertype']]) &lt; 2" id="Encounter Type" role="ERROR" flag="structure"  >
			Contact report must contain maximum one "encountertype". (Number: <iso:value-of select="count(kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='encountertype']])"/>)_||_
			Une transaction "contactreport" doit contenir au maximum un item "encountertype". (Nombre: <iso:value-of select="count(kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='encountertype']])"/>)_||_
			Een transactie van het type 'contactreport' moet één enkel "encountertype' bevatten. (Aantal: <iso:value-of select="count(kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='encountertype']])"/>)_||_
			Ein Transaktion "contactreport" kann nur ein "encountertype" umfassen. (Zahl: <iso:value-of select="count(kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='encountertype']])"/>)</iso:assert>
			<iso:assert test="count(kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='encounterdatetime']]) = 1" id="Encounter Date Time" role="ERROR" flag="structure"  >
			Contact report must contain one and only one "encounterdatetime". (Number: <iso:value-of select="count(kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='encounterdatetime']])"/>)_||_
			Une transaction "contactreport" doit contenir un et un seul item "encounterdatetime". (Nombre: <iso:value-of select="count(kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='encounterdatetime']])"/>)_||_
			Een transactie van het type 'contactreport' moet één enkel "encounterdatetime' bevatten. (Aantal: <iso:value-of select="count(kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='encounterdatetime']])"/>)_||_
			Ein Transaktion 'contactreport' sollte nur ein "encounterdatetime' umfassen. (Zahl: <iso:value-of select="count(kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='encounterdatetime']])"/>)_||_</iso:assert>
	</iso:rule>
</iso:pattern>

<!-- AUTHOR -->
<iso:pattern id="author.value.checks">
	<iso:title>Author value checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary']]//kmehr:author/kmehr:hcparty/kmehr:cd[@S='CD-HCPARTY']">
			<iso:assert test="current()='persphysician'" id="Author" role="ERROR" flag="structure"  >
			The "role" (official CD-HCPARTY) of the author of the clinicalsummary must be "persphysician". (Code: "<iso:value-of select="current()"/>")_||_
			Le rôle d'un item "contact-prestataire de soin" (CD-HCPARTY officiel)  de l'auteur de la transaction "clinicalsummary" doit être "persphysician". (Code: "<iso:value-of select="current()"/>")_||_
			De "role" (officiële CD-HCPARTY) van de auteur van de clinicalsummary moet "persphysician" zijn. (Code: "<iso:value-of select="current()"/>")_||_
			Die Rolle "role" (offizielles CD-HCPARTY) den Author eines "clinicalsummary" sollte ein "persphysician" sein. (Kode: "<iso:value-of select="current()"/>")</iso:assert>
	</iso:rule>
</iso:pattern>

<!-- ITEMS -->
<iso:pattern id="items.structure.checks">
	<iso:title>Items structure checks</iso:title>
	<iso:rule context="kmehr:item">
			<iso:assert test="count(kmehr:cd[@S = 'CD-ITEM']) = 1" id="Item" role="ERROR" flag="structure"  >
			All items must be codified by one code CD-ITEM and only one. (Number: <iso:value-of select="count(kmehr:cd[@S = 'CD-ITEM'])"/>)_||_
			Tous les éléments "items" doivent être catégorisés par un et un seul code CD-ITEM, (Nombre: <iso:value-of select="count(kmehr:cd[@S = 'CD-ITEM'])"/>)_||_
			Alle elementen "items" moeten onder één enkele code CD-ITEM worden ondergebracht. (Aantal: <iso:value-of select="count(kmehr:cd[@S = 'CD-ITEM'])"/>)_||_
			Alle Elemente "Themen" ("Items") müssen unter einem einzigen Code kategorisiert werden.(Zahl: <iso:value-of select="count(kmehr:cd[@S = 'CD-ITEM'])"/>)</iso:assert>
	</iso:rule>
</iso:pattern>

<!-- MEDICAL ITEMS -->
<iso:pattern id="medicalitems.structure.checks">
	<iso:title>Medical items structure checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary' or .='contactreport']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and ( (.='adr') or (.='allergy') or (.='clinical') or (.='evolution') or (.='familyrisk') or (.='habit') or (.='healthissue') or (.='healthcareelement') or (.='incapacity') or (.='medication') or (.='parameter') or (.='patientwill') or (.='professionalrisk') or (.='risk') or (.='socialrisk') or (.='technical') or (.='treatment') or (.='vaccine') )]]">
			<iso:assert test="kmehr:recorddatetime" id="Medical Items" role="ERROR" flag="structure"  >		
			Medical item "<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" must contain a record date ('recorddatetime')._||_
			Un item médical "<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" doit avoir une date d'enregistrement._||_
			Een medisch item "<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" moet een registratiedatum ('recorddatetime') gedefinieerd hebben._||_
			medizinische Themen "<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" mussen ein 'recorddatetime' umfassen.</iso:assert>
			<iso:assert test="kmehr:id[@S='LOCAL' and @SL='MF-ID']" id="Medical Items" role="ERROR" flag="structure"  >		
			Medical item "<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" must have a "MF-ID"._||_
			Un item médical "<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" doit avoir un "MF-ID"._||_
			Een medisch item "<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" moeten een MF-ID bevatten._||_
			medizinische Themen "<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" mussen ein MF-ID umfassen.</iso:assert>
	</iso:rule>
</iso:pattern>

<iso:pattern id="medicalitems.structure.warnings.checks">
	<iso:title>Medical items structure warnings checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary' or .='contactreport']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and ( (.='adr') or (.='allergy') or (.='clinical') or (.='evolution') or (.='familyrisk') or (.='habit') or (.='healthissue') or (.='healthcareelement') or (.='incapacity') or (.='medication') or (.='parameter') or (.='patientwill') or (.='professionalrisk') or (.='risk') or (.='socialrisk') or (.='technical') or (.='treatment') or (.='vaccine') )]]">
			<iso:assert test="kmehr:beginmoment" id="Medical Items" role="WARNING" flag="structure"  >		
			Medical item "<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" should have a beginmoment._||_
			Un item médical "<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" devrait avoir une date de début._||_
			Een medische item "<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" zouden een begindatum moeten hebben ('beginmoment')._||_
			medizinische Themen "<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" sollen ein "beginmoment" umfassen.</iso:assert>
	</iso:rule>
</iso:pattern>

<iso:pattern id="medicalitems.values.warnings.checks">
	<iso:title>Medical items values warnings checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary' or .='contactreport']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and ( (.='adr') or (.='allergy') or (.='clinical') or (.='evolution') or (.='familyrisk') or (.='habit') or (.='healthissue') or (.='healthcareelement') or (.='incapacity') or (.='medication') or (.='parameter') or (.='patientwill') or (.='professionalrisk') or (.='risk') or (.='socialrisk') or (.='technical') or (.='treatment') or (.='vaccine') )] and kmehr:lifecycle[kmehr:cd[@S='CD-LIFECYCLE' and .='inactive']]]">
			<iso:assert test="kmehr:endmoment" id="Medical Items" role="WARNING" flag="structure"  >		
			Medical item "<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" should have a endmoment when the item is inactive._||_
			Un item médical "<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" devrait avoir une date de fin quand l'item est inactif._||_
			Een Medisch "<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" item zouden een einddatum moeten hebben, wanneer het element inactief is._||_
			Ein medizinisches Thema (item) "<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" sollte ein "enddate" umfassen, wenn das Element inaktiv ist.</iso:assert>
	</iso:rule>
</iso:pattern>

<!-- CONTACTHCPARTY -->
<iso:pattern id="contacthcparty.structure.checks">
	<iso:title>Contacts hcparty structure checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='contacthcparty']]">
			<iso:assert test="count(kmehr:content/kmehr:hcparty) = 1" id="Contact Hcparty" role="ERROR" flag="structure"  >
			Contact Hcparty must have one content with "hcparty" element and only one. (Number: <iso:value-of select="count(kmehr:content/kmehr:hcparty)"/>)_||_
			Un item "contact prestataire de soins" doit contenir un et un seul "content" contenant un élément "hcparty". (Nombre: <iso:value-of select="count(kmehr:content/kmehr:hcparty)"/>)_||_
			Een item "contact-zorgverlener" mag een enkel "content" met een element "hcparty" omvatten. (Aantal: <iso:value-of select="count(kmehr:content/kmehr:hcparty)"/>)_||_
			Ein Thema "Kontakt - Pflegeanbieter" darf nur einen "Content" mit einem "hcparty"-Element umfassen. (Zahl: <iso:value-of select="count(kmehr:content/kmehr:hcparty)"/>)</iso:assert>
	</iso:rule>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='contacthcparty']]/kmehr:content/kmehr:hcparty">
			<iso:assert test="kmehr:familyname" id="Contact Hcparty" role="ERROR" flag="structure"  >
			Contact Hcparty must have a familyname (and firstnames)._||_
			Un item "contact prestataire de soins" doit contenir un nom de famille (et prénoms)._||_
			Een item "contact-zorgverlener" moet een familienaam (en voornamen) omvatten._||_
			Ein Thema "Kontakt - Pflegeanbieter" muss einen Familiennamen (und Vornamen) umfassen.</iso:assert>
	</iso:rule>	
</iso:pattern>

<iso:pattern id="contacthcparty-contents.structure.checks">
	<iso:title>Contacts hcparty content structure checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='contacthcparty']]/kmehr:content/*">
			<iso:assert test="(local-name()='hcparty')" id="Contact Hcparty" role="ERROR" flag="structure"  >
			A "Contact Hcparty" content can contain only element "hcparty". (Element: "<iso:value-of select="local-name()"/>")_||_
			L'élément "content" d'un item "contact-prestataire de soin" ne peut contenir que des éléments "hcparty". (Elément: "<iso:value-of select="local-name()"/>")_||_
			Het "content"-element van een item "contact-zorgverlener" mag enkel "hcparty"-elementen bevatten. (Element: "<iso:value-of select="local-name()"/>")_||_
			Das "Content"-Element im Thema "Kontakt - Pflegeanbieter" darf nur  "hcparty"-Elemente umfassen. (Element: "<iso:value-of select="local-name()"/>")</iso:assert>
	</iso:rule>
</iso:pattern>

<iso:pattern id="contacthcparty.structure.warnings.checks">
	<iso:title>Contacts hcparty warnings checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='contacthcparty']]/kmehr:content/kmehr:hcparty">
			<iso:assert test="kmehr:id[@S = 'ID-HCPARTY']" id="Contact Hcparty" role="WARNING" flag="structure"  >
			Contact Hcparty should have one INAMI/RIZIV number._||_
			Un item "contact prestataire de soins" devrait contenir un numéro INAMI/RIZIV._||_
			Een item "contact-zorgverlener" zou minstens een RIZIV-nummer moeten hebben._||_
			Ein thema "kontakt - pflegeanbieter" sollte eine LIKIV-Nummer haben.</iso:assert>
			<iso:assert test="kmehr:address" id="Contact Hcparty" role="WARNING" flag="structure"  >
			Contact Hcparty should have at least one address._||_
			Un item  "contact prestataire de soins" devrait contenir au moins une adresse._||_
			Een item "contact-zorgverlener" zou minstens een adres moeten hebben._||_
			Ein thema "kontakt - pflegeanbieter" sollte mindestens eine Adresse haben.</iso:assert>
			<iso:assert test="kmehr:telecom" id="Contact Hcparty" role="WARNING" flag="structure"  >
			Contact Hcparty should have at least one telecom._||_
			Un item "contact prestataire de soins" devrait contenir au moins un moyen de télécommunication._||_
			Een item "contact-zorgverlener" zou minstens een telecommunicatiemiddel moeten hebben._||_
			Ein thema "kontakt - pflegeanbieter" sollte mindestens ein Telekommunikationsmittel haben.</iso:assert>
			<iso:assert test="kmehr:id[@S='LOCAL']" id="Contact Hcparty" role="WARNING" flag="structure"  >
			Contact Hcparty should have a "LOCAL" ID._||_
			Un item "contact-prestataire de soin" devrait avoir un "id" local._||_
			Een Hcparty contact zou een "LOCAL" ID moeten hebben. _||_
			Ein HcParty Kontact sollte ein "LOCAL" ID umfassen.</iso:assert>
	</iso:rule>
</iso:pattern>

<!-- CONTACTPERSON -->
<iso:pattern id="contactperson.structure.checks">
	<iso:title>Contact Person structure checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='contactperson']]">
			<iso:assert test="count(kmehr:content/kmehr:person) = 1" id="Contact Person" role="ERROR" flag="structure"  >
			Contact Person must have one content person and only one. (Number: <iso:value-of select="count(kmehr:content/kmehr:person)"/>)_||_
			Un item "personne de contact" doit contenir un et un seul élément "content". (Nombre: <iso:value-of select="count(kmehr:content/kmehr:person)"/>)_||_
			Een item "contactpersoon" mag maar één enkel "content"-element bevatten. (Aantal: <iso:value-of select="count(kmehr:content/kmehr:person)"/>)_||_
			Ein thema "Kontaktperson" darf nur ein "Content"-Element umfassen. (Zahl: <iso:value-of select="count(kmehr:content/kmehr:person)"/>)</iso:assert>
	</iso:rule>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='contactperson']]/kmehr:content/*">
			<iso:assert test="(local-name()='person')" id="Contact Person" role="ERROR" flag="structure"  >
			A "Contact Person" content can contain only element "person". (Element: "<iso:value-of select="local-name()"/>")_||_
			L'élement "content" d'un item personne de contact ne peut contenir qu'un élément "person". (Elément: "<iso:value-of select="local-name()"/>")_||_
			Het "content"-element van een item "contactpersoon" mag maar één "person"-element bevatten. (Element: "<iso:value-of select="local-name()"/>")_||_
			Das "Content"-Element im Thema "Kontaktperson" darf nur ein "Content"-Element umfassen. (Element: "<iso:value-of select="local-name()"/>")</iso:assert>
	</iso:rule>
</iso:pattern>

<iso:pattern id="contactperson.clinical.structure.warnings.checks">
	<iso:title>Contact Person warnings checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='contactperson']]">
			<iso:assert test="kmehr:cd[@S='CD-CONTACT-PERSON']" id="Contact Person" role="WARNING" flag="structure"  >
			Contact Person should have a code (CD-CONTACT-PERSON) to describe the family tie._||_
			Un item  "personne de contact" devrait contenir un code (CD-CONTACT-PERSON) pour décrire son lien familial._||_
			Een item "contactpersoon" zou een code (CD-CONTACT-PERSON) moeten bevatten om de gezinsrelatie te beschrijven. _||_
			Ein thema "Kontaktperson" darf nur "Person"-Elemente umfassen.</iso:assert>
	</iso:rule>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='contactperson']]/kmehr:content/kmehr:person">
			<iso:assert test="kmehr:address" id="Contact Person" role="WARNING" flag="structure"  >
			Contact Person should have at least one address._||_
			Un item "personne de contact" devrait contenir au moins une adresse._||_
			Een item "contactpersoon" zou minstens een adres moeten bevatten._||_
			Ein Thema "Kontaktperson" sollte mindestens eine Adresse umfassen. </iso:assert>
			<iso:assert test="kmehr:telecom" id="Contact Person" role="WARNING" flag="structure"  >
			Contact Person should have at least one telecom._||_
			Un item  "personne de contact" devrait contenir au moins un moyen de télécommunication._||_
			Een item "contactpersoon" zou minstens een communicatiemiddel moeten bevatten._||_
			Ein Thema "Kontaktperson" sollte mindestens ein Kommunikationsmittel umfassen. </iso:assert>
	</iso:rule>
</iso:pattern>

<iso:pattern id="contactperson.structure.warnings.checks">
	<iso:title>Contact Person warnings checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary' or .='contactreport']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='contactperson']]/kmehr:content/kmehr:person">
			<iso:assert test="kmehr:id[@S='LOCAL']" id="Contact Person" role="WARNING" flag="structure"  >
			Contact Person should have a "LOCAL" ID._||_
			Un item  "personne de contact" devrait contenir un "id" local._||_
			Een item "contactpersoon" zou een lokaal ID moeten bevatten om. _||_
			Ein Thema "Kontaktperson" sollte ein 'LOCAL' ID umfassen.</iso:assert>
	</iso:rule>
</iso:pattern>

<!-- GMD MANAGER -->
<iso:pattern id="gmdmanager.structure.checks">
	<iso:title>GMD Manager structure checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary']]">
			<iso:assert test="count(//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='gmdmanager']]) &lt; 2" id="GMD Manager" role="ERROR" flag="structure"  >
			There can be maximum one GMD Manager. (Number: <iso:value-of select="count(//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='gmdmanager']])"/>)_||_
			Il ne peut y avoir au maximum un item "détenteur de DMG". (Nombre: <iso:value-of select="count(//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='gmdmanager']])"/>)_||_
			Er mag maximaal één item "GMD-houder" zijn. (Aantal: <iso:value-of select="count(//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='gmdmanager']])"/>)_||_
			Es konnte maximal ein thema "Inhaber des GMD" sein. (Zahl: <iso:value-of select="count(//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='gmdmanager']])"/>)</iso:assert>
	</iso:rule>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='gmdmanager']]">
			<iso:assert test="count(kmehr:content/kmehr:hcparty) = 1" id="GMD Manager" role="ERROR" flag="structure"  >
			GMD Manager must have one content hcparty and only one. (Number: <iso:value-of select="count(kmehr:content/kmehr:hcparty)"/>)_||_
			Un item "détenteur de DMG" contient un et un seul élément 'content' de type 'hcparty'.(Nombre: <iso:value-of select="count(kmehr:content/kmehr:hcparty)"/>)_||_
			Een item "GMD-houder" mag maar één enkel "content"-element van het type "hcparty" omvatten. (Aantal: <iso:value-of select="count(kmehr:content/kmehr:hcparty)"/>)_||_
			Ein thema "Inhaber des GMD" umfaßt nur ein "Content"-Element vom Typ "hcparty". (Zahl: <iso:value-of select="count(kmehr:content/kmehr:hcparty)"/>)</iso:assert>
	</iso:rule>
</iso:pattern>

<iso:pattern id="gmdmanager-contents.structure.checks">
	<iso:title>GMD Manager content structure checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='gmdmanager']]/kmehr:content/kmehr:hcparty">
			<iso:assert test="count(kmehr:id[@S = 'ID-HCPARTY']) > 0" id="GMD Manager" role="ERROR" flag="structure"  >
			GMD Manager must have one INAMI/RIZIV number and only one. (Number: <iso:value-of select="count(kmehr:id[@S = 'ID-HCPARTY'])"/>)_||_
			Un  item "detenteur de DMG" doit contenir un et un seul numéro INAMI/RIZIV. (Nombre: <iso:value-of select="count(kmehr:id[@S = 'ID-HCPARTY'])"/>)_||_
			Een item "GMD-houder" moet één enkel RIZIV-nummer bevatten. (Aantal: <iso:value-of select="count(kmehr:id[@S = 'ID-HCPARTY'])"/>)_||_
			Ein thema "Inhaber des GMD" darf nur eine LIKIV-Nummer umfassen. (Zahl: <iso:value-of select="count(kmehr:id[@S = 'ID-HCPARTY'])"/>)</iso:assert>
	</iso:rule>	
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='gmdmanager']]/kmehr:content/kmehr:hcparty[kmehr:familyname]/kmehr:cd[@S='CD-HCPARTY']">
			<iso:assert test="current()='persphysician'" id="GMD Manager" role="ERROR" flag="structure"  >
			If GMD Manager is a person (with familyname) then his "role" (official CD-HCPARTY) must be "persphysician". (Code: "<iso:value-of select="current()"/>")_||_
			Si un item "détenteur de DMG" est une personne (avec un nom de famille) alors son "rôle" (CD-HCPARTY officiel) doit être "persphysician". (Code: "<iso:value-of select="current()"/>")_||_
			Indien een item "GMD-houder" een persoon (met familienaam) is, dan moet zijn "rol" (officiële CD-HCPARTY) "persphysician" zijn. (Code: "<iso:value-of select="current()"/>")_||_
			Wenn ein thema "Inhaber des GMD" eine Person mit einem Familiennamen ist, dann muss seine offizielle Rolle "persphysician" sein. (Code: "<iso:value-of select="current()"/>")</iso:assert>
	</iso:rule>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='gmdmanager']]/kmehr:content/*">
			<iso:assert test="(local-name()='hcparty' or local-name()='date' or local-name()='time')" id="GMD Manager" role="ERROR" flag="structure"  >
			A "GMD Manager" content can contain only element "hcparty", "date" or "time". (Element: "<iso:value-of select="local-name()"/>")_||_
			L'élément content d'un item "détenteur de DMG" ne peut contenir que des éléments "hcparty", "date" et "time". (Elément: "<iso:value-of select="local-name()"/>")_||_
			Het "content"-element van een item "GMD-houder" kan enkel "hcparty", "date" en "time" elementen omvatten. (Element: "<iso:value-of select="local-name()"/>")_||_
			Das "Content"-Element eines Themas "Inhaber des GMD" kann nur "hcparty", "date", "time" Elemente umfassen. (Element: "<iso:value-of select="local-name()"/>")</iso:assert>
	</iso:rule>
</iso:pattern>

<iso:pattern id="gmdmanager.structure.warnings.checks">
	<iso:title>GMD Manager warnings checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='gmdmanager']]/kmehr:content/kmehr:hcparty">
			<iso:assert test="kmehr:address" id="GMD Manager" role="WARNING" flag="structure"  >
			GMD Manager should have at least one address._||_
			Un item "détenteur de DMG" devrait contenir au moins une adresse._||_
			Een item "GMD-houder" zou minstens een adres moeten bevatten._||_
			Ein thema "Inhaber des GMD" sollte mindestens eine Adresse umfassen.</iso:assert>
			<iso:assert test="kmehr:telecom" id="GMD Manager" role="WARNING" flag="structure"  >
			GMD Manager should have at least one telecom._||_
			Un item "détenteur de DMG" devrait contenir au moins un moyen de télécommunication._||_
			Een item "GMD-houder" zou minstens een telecommunicatiemiddel moeten bevatten._||_
			Ein thema "Inhaber des GMD" sollte mindestens ein Telekommunikationsmittel umfassen.</iso:assert>
	</iso:rule>
</iso:pattern> 

<!-- RISKS -->
<iso:pattern id="risks.structure.checks">
	<iso:title>Risks structure checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and ( (.='adr') or (.='allergy') or (.='socialrisk') or (.='risk') or (.='professionalrisk') or (.='familyrisk') )]]">
			<iso:assert test="count(kmehr:content[kmehr:text]) = 1" id="Risk" role="ERROR" flag="structure"  >
			"<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" must have one content and only one with "text" elements (label).  (Number: <iso:value-of select="count(kmehr:content[kmehr:text])"/>)_||_
			"<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" doit contenir un et un seul "content" contenant des éléments "text" (label). (Nombre: <iso:value-of select="count(kmehr:content[kmehr:text])"/>)_||_
			"<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" moet één "content" met één enkel "text"-elementen bevatten (label). (Aantal: <iso:value-of select="count(kmehr:content[kmehr:text])"/>)_||_
			"<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" darf nur einen "Content" mit einem einzigen "Text"-Elementen umfassen (Label). (Zahl: <iso:value-of select="count(kmehr:content[kmehr:text])"/>)</iso:assert>
			<iso:assert test="count(kmehr:content[kmehr:cd]) &lt; 2" id="Risk" role="ERROR" flag="structure"  >
			"<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" must have maximum one content with "cd" elements (codification). (Number: <iso:value-of select="count(kmehr:content[kmehr:cd])"/>)_||_
			"<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" doit contenir au maximum un élément "content" contenant des éléments "cd" (codification). (Nombre: <iso:value-of select="count(kmehr:content[kmehr:cd])"/>)_||_
			"<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" mag maximaal een "content"-element met cd-elementen bevatten (codificatie). (Aantal: <iso:value-of select="count(kmehr:content[kmehr:cd])"/>)_||_
			"<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" darf maximal ein "Content"-Element mit CD-Elementen umfassen (Kodifikation). (Zahl): <iso:value-of select="count(kmehr:content[kmehr:cd])"/>)</iso:assert>
	</iso:rule>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and ( (.='adr') or (.='allergy') or (.='socialrisk') or (.='risk') or (.='professionalrisk') or (.='familyrisk') )]]/kmehr:content/*">
			<iso:assert test="(local-name()='cd' or local-name()='text')" id="Risk" role="ERROR" flag="structure"  >
			A "<iso:value-of select="../../kmehr:cd[@S='CD-ITEM']"/>" content can contain only elements "text" or "cd". (Element: "<iso:value-of select="local-name()"/>")_||_
			Un élément "content" "<iso:value-of select="../../kmehr:cd[@S='CD-ITEM']"/>" peut seulement contenir des éléments "text" ou "cd". (Elément: "<iso:value-of select="local-name()"/>")_||_
			Een "content"-element "<iso:value-of select="../../kmehr:cd[@S='CD-ITEM']"/>" mag enkel "text"- of "cd"-elementen bevatten. (Element: "<iso:value-of select="local-name()"/>")_||_
			Ein "Content"-Element  "<iso:value-of select="../../kmehr:cd[@S='CD-ITEM']"/>" darf nur "Text"- oder "CD"-Elemente umfassen. (Element: "<iso:value-of select="local-name()"/>")</iso:assert>
	</iso:rule>
</iso:pattern>
	
<iso:pattern id="risks.structure.warnings.checks">
	<iso:title>Risks structure warnings checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and ( (.='adr') or (.='allergy') or (.='socialrisk') or (.='risk') or (.='professionalrisk') or (.='familyrisk') )]]">
			<iso:assert test="count(kmehr:content[kmehr:cd]) &gt; 0" id="Risk" role="WARNING" flag="structure"  >
			"<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" should have at least one content with "cd" elements (codification). (Number: <iso:value-of select="count(kmehr:content[kmehr:cd])"/>)_||_
			"<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" devrait avoir au moins un élément "content" contenant des éléments "cd" (codification). (Nombre: <iso:value-of select="count(kmehr:content[kmehr:cd])"/>)_||_
			"<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>"  "content"-element moet cd-elementen bevatten (codificatie). (Aantal: <iso:value-of select="count(kmehr:content[kmehr:cd])"/>)_||_
			"<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>"  "Content"-Element mit CD-Elementen umfassen (Kodifikation). (Zahl): <iso:value-of select="count(kmehr:content[kmehr:cd])"/>)</iso:assert>
	</iso:rule>
</iso:pattern>

<!-- HEALTHCARELEMENTS -->
<iso:pattern id="healthcareelement.structure.checks">
	<iso:title>Healthcare Element structure checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='healthcareelement']]">
			<iso:assert test="count(kmehr:content[kmehr:text]) = 1" id="Healthcare Element" role="ERROR" flag="structure"  >
			Healthcare Element must have one and only one content with "text" elements (label). (Number: <iso:value-of select="count(kmehr:content[kmehr:text])"/>)_||_
			Un item "Problème actuel" ou "Elément de soin passif" doit contenir un et un seul "content" contenant des éléments "text"(label). (Nombre: <iso:value-of select="count(kmehr:content[kmehr:text])"/>)_||_
			Een item "huidig probleem" of "passief zorgelement" mag één enkel "content" met een "text"-elementen (label) bevatten. (Aantal: <iso:value-of select="count(kmehr:content[kmehr:text])"/>)_||_
			Ein thema "heutiges Problem" oder "passives Sorgeelement" darf nur einen "Content" mit einem "Text"-Elementen (Label) umfassen. (Zahl: <iso:value-of select="count(kmehr:content[kmehr:text])"/>)</iso:assert>
			<iso:assert test="count(kmehr:content[kmehr:cd]) &lt; 2" id="Healthcare Element" role="ERROR" flag="structure"  >
			Healthcare Element must have maximum one content with "cd" elements (codification). (Number: <iso:value-of select="count(kmehr:content[kmehr:cd])"/>)_||_
			Un  item "Problème actuel" ou "Elément de soin passif"  doit contenir au plus un "content" constitué d'éléments "cd"(codification). (Nombre: <iso:value-of select="count(kmehr:content[kmehr:cd])"/>)_||_
			Een item "huidig probleem" of "passief zorgelement" mag maximaal een "content" met "cd"-elementen (codificatie) omvatten. (Aantal: <iso:value-of select="count(kmehr:content[kmehr:cd])"/>)_||_
			Ein thema "heutiges Problem" oder "passives Sorgeelement" darf maximal einen "Content" mit "CD"-Elementen (Kodifikation) umfassen. (Zahl: <iso:value-of select="count(kmehr:content[kmehr:cd])"/>)</iso:assert>
			<iso:assert test="kmehr:lifecycle/kmehr:cd[@S='CD-LIFECYCLE']='active' or kmehr:lifecycle/kmehr:cd[@S='CD-LIFECYCLE']='inactive'" id="Healthcare Element" role="ERROR" flag="structure"  >
			Healthcare Element must have one element "lifecycle", either "active" or "inactive". (Number: <iso:value-of select="count(kmehr:lifecycle/kmehr:cd[@S='CD-LIFECYCLE'])"/>, Value: "<iso:value-of select="kmehr:lifecycle/kmehr:cd[@S='CD-LIFECYCLE']"/>")_||_
			Un  item "Problème actuel" ou "Elément de soin passif" contient un élément "lifecycle", soit "active" ou "inactive". (Nombre: <iso:value-of select="count(kmehr:lifecycle/kmehr:cd[@S='CD-LIFECYCLE'])"/>, Valeur: "<iso:value-of select="kmehr:lifecycle/kmehr:cd[@S='CD-LIFECYCLE']"/>")_||_
			Een item "huidig probleem" of "passief zorgelement" bevat een element "lifecycle", ofwel "actief" of "non-actief". (Aantal: <iso:value-of select="count(kmehr:lifecycle/kmehr:cd[@S='CD-LIFECYCLE'])"/>, Waarde: "<iso:value-of select="kmehr:lifecycle/kmehr:cd[@S='CD-LIFECYCLE']"/>")_||_
			Ein Thema "heutiges Problem" oder "passives Sorgeelement" umfaßt ein Element "Lifecycle", entweder "aktiv" oder "nicht aktiv" (Zahl: <iso:value-of select="count(kmehr:lifecycle/kmehr:cd[@S='CD-LIFECYCLE'])"/>, Werte: "<iso:value-of select="kmehr:lifecycle/kmehr:cd[@S='CD-LIFECYCLE']"/>")</iso:assert>
			<iso:assert test="kmehr:isrelevant" id="Healthcare Element" role="ERROR" flag="structure"  >
			Healthcare Element must have a "isrelevant" element._||_
			Un  item "Problème actuel" ou "Elément de soin passif" doit contenir un élément "isrelevant"._||_
			Een Healthcare Element moet een "isrelevant" element omvatten._||_
			Ein Healthcare Element sollte ein Element "isrelevant" umfassen.</iso:assert>
	</iso:rule>	
</iso:pattern>

<iso:pattern id="healthcareelement-contents.structure.checks">
	<iso:title>Healthcare Element content structure checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='healthcareelement']]/kmehr:content/*">
			<iso:assert test="(local-name()='cd' or local-name()='text')" id="Healthcare Element" role="ERROR" flag="structure"  >
			A "<iso:value-of select="../../kmehr:cd[@S='CD-ITEM']"/>" content can contain only elements "text" or "cd". (Element: "<iso:value-of select="local-name()"/>")_||_
			Un content "<iso:value-of select="../../kmehr:cd[@S='CD-ITEM']"/>" ne peut contenir que des éléments "text" ou "cd". (Elément: "<iso:value-of select="local-name()"/>")_||_
			Een content "<iso:value-of select="../../kmehr:cd[@S='CD-ITEM']"/>" kan enkel "text"- of "cd"-elementen bevatten. (Element: "<iso:value-of select="local-name()"/>")_||_
			Ein "Content" "<iso:value-of select="../../kmehr:cd[@S='CD-ITEM']"/>" kann nur "Text"- oder "CD"-Elemente umfassen. (Element: "<iso:value-of select="local-name()"/>")</iso:assert>
			
	</iso:rule>
</iso:pattern>

<iso:pattern id="healthcareelement.structure.warnings.checks">
	<iso:title>Healthcare Element checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='healthcareelement']]">
			<iso:assert test="kmehr:content/kmehr:cd" id="Healthcare Element" role="WARNING" flag="structure"  >
			Healthcare Element should have a content with codified informations (cd)._||_
			Un item "Problème actuel" ou "Elément de soin passif" devrait contenir un élément "content" contenant un "cd"._||_
			Een item "huidig probleem" of "passief zorgelement" zou een element "content" met een "cd"-element moeten bevatten._||_
			Ein Thema "heutiges Problem" oder "passives Sorgeelement" sollte ein Element "Content" mit einem "CD"-Element umfassen.</iso:assert>
	</iso:rule>
</iso:pattern>

<!--
<iso:pattern id="healthcareelement.values.checks">
	<iso:title>Healthcare values checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='healthcareelement'] and kmehr:isrelevant[.='false'] and kmehr:lifecycle]">
			<iso:assert test="kmehr:lifecycle[kmehr:cd[ @S ='CD-LIFECYCLE' and .='inactive' ]]" id="Healthcare Element" role="ERROR" flag="structure"  >
			Element "isrelevant" is set to false so the lifecycle must be "inactive"._||_
			L'élément "isrelevant" est défini comme "false", alors l'élément "lifecycle" doit être "inactive"._||_
			Het element "isrelevant" is "false", dus de lifecycle moet "inactive" zijn._||_
			Das Element "isrelevant" ist falsch, also "lifecycle" muss "inactive" sein.</iso:assert>
	</iso:rule>
</iso:pattern>
-->

<!-- CURRENT PROBLEMS -->
<iso:pattern id="currentproblems.structure.checks">
	<iso:title>Current Problems structure checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='healthcareelement'] and kmehr:lifecycle[kmehr:cd[ @S ='CD-LIFECYCLE' and .='active' ]]]">
			<iso:assert test="kmehr:beginmoment" id="Healthcare Element" role="ERROR" flag="structure"  >
			Current Problem must have a "beginmoment"._||_
			Un item "Problème actuel" doit contenir un "beginmoment"._||_
			Een item "huidig probleem" moet een beginmoment hebben._||_
			Ein Thema "heutiges Problem" muss einen "Anfangmoment" haben.</iso:assert>
	</iso:rule>
</iso:pattern>

<!-- RELEVANT PASSIVE CARE ELEMENT -->
<iso:pattern id="relevantpassivecareelements.warning.checks">
	<iso:title>Relevant Passive Care Elements structure checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='healthcareelement'] and kmehr:lifecycle[kmehr:cd[ @S ='CD-LIFECYCLE' and .='inactive' ]]]">
			<iso:assert test="kmehr:endmoment" id="Healthcare Element" role="WARNING" flag="structure"  >
			Relevant Passive Care Element should have an "endmoment"._||_
			Un item "Elément de soin passif" devrait avoir une fin ("endmoment")._||_
			Een item "passief zorgelement" zou een einde ("endmoment") moeten hebben._||_
			Ein Thema "passives Sorgeelement" sollte ein Ende ("Endmoment") haben.</iso:assert>
	</iso:rule>
</iso:pattern>

<!-- MEDICATION  -->
<iso:pattern id="medication.structure.checks">
	<iso:title>Medication structure checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='medication']]">
			<iso:assert test="count(kmehr:content[kmehr:text]) = 1" id="Medication" role="ERROR" flag="structure"  >
			Medication must contain one (and only one) textual content corresponding to the medication label. (Number: <iso:value-of select="count(kmehr:content[kmehr:text])"/>)_||_
			Un item "médication" doit contenir un et un seul content textuel correspondant au label "medication". (Nombre: <iso:value-of select="count(kmehr:content[kmehr:text])"/>)_||_
			Een item "medicatie" moet één enkele textuele inhoud hebben die overeenstemt met de label "medicatie". (Aantal: <iso:value-of select="count(kmehr:content[kmehr:text])"/>)_||_
			Ein thema "Medikation" muss nur einen textuellen Inhalt haben, welcher mit dem Label "Medikation" übereinstimmt. (Zahl: <iso:value-of select="count(kmehr:content[kmehr:text])"/>) </iso:assert>
			<iso:assert test="count(kmehr:content[kmehr:cd[@S='CD-ATC']]) &lt; 2" id="Medication" role="ERROR" flag="structure"  >
			Medication must have maximum one content with codified ATC. (Number: <iso:value-of select="count(kmehr:content[kmehr:cd[@S='CD-ATC']])"/>)_||_
			Un item "médication" contient au plus un élément "content" contenant un code ATC. (Nombre: <iso:value-of select="count(kmehr:content[kmehr:cd[@S='CD-ATC']])"/>)_||_
			Een item "medicatie" bevat maximaal een "content"-element met een ATC-code. (Aantal: <iso:value-of select="count(kmehr:content[kmehr:cd[@S='CD-ATC']])"/>)_||_
			Ein Thema "Medikation" umfaßt maximal ein "Content"-Element mit einem ATC-Code. (Zahl: <iso:value-of select="count(kmehr:content[kmehr:cd[@S='CD-ATC']])"/>) </iso:assert>
			<iso:assert test="count(kmehr:content[kmehr:medicinalproduct or kmehr:substanceproduct or kmehr:compoundprescription]) &lt; 2" id="Medication" role="ERROR" flag="structure"  >
			Medication must contain maximum one content "medicinalproduct" or "substanceproduct" or "compoundprescription". (Number: <iso:value-of select="count(kmehr:content[kmehr:medicinalproduct or kmehr:substanceproduct or kmehr:compoundprescription])"/>)_||_
			Un item "médication" doit contenir au maximum un content "medicinalproduct", "substanceproduct" ou "compoundprescription". (Nombre: <iso:value-of select="count(kmehr:content[kmehr:medicinalproduct or kmehr:substanceproduct or kmehr:compoundprescription])"/>)_||_
			Een item "medicatie" mag maar één inhoud "medicinalproduct", "substanceproduct" of "compoundprescription" bevatten. (Aantal: <iso:value-of select="count(kmehr:content[kmehr:medicinalproduct or kmehr:substanceproduct or kmehr:compoundprescription])"/>)_||_
			Ein thema "Medikation" sollte nur ein Inhalt "medicinalproduct", "substanceproduct" oder "compoundprescription" haben. (Zahl: <iso:value-of select="count(kmehr:content[kmehr:medicinalproduct or kmehr:substanceproduct or kmehr:compoundprescription])"/>) </iso:assert>
			<iso:assert test="kmehr:lifecycle" id="Medication" role="ERROR" flag="structure" >
			Medication must have a "lifecycle" element._||_
			Un  item "medication" doit contenir un élément "lifecycle"._||_
			"medication" moet een "lifecycle" element bevatten._||_
			Ein thema "Medikation" sollte ein "Lifecycle" Element umfassen</iso:assert>
			<iso:assert test="kmehr:isrelevant" id="Medication" role="ERROR" flag="structure" >
			Medication must have a "isrelevant" element._||_
			Un  item "medication" doit contenir un élément "isrelevant"._||_
			"medication" moet een "isrelevant" element bevatten_||_
			Ein thema "Medikation" sollte ein "isrelevant" Element umfassen.</iso:assert>
	</iso:rule>	
</iso:pattern>

<iso:pattern id="medication.values.checks">
	<iso:title>Medication values checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='medication'] and kmehr:isrelevant[.='false']]">
			<iso:assert test="kmehr:lifecycle[kmehr:cd[ @S ='CD-LIFECYCLE' and .='inactive' ]]" id="Medication" role="ERROR" flag="structure"  >
			Element "isrelevant" is set to false so the lifecycle must be "inactive"._||_
			L'élément "isrelevant" est défini comme "false", alors l'élément "lifecycle" doit être "inactive"._||_
			Het element "isrelevant" is 'false', dus het element "lifecycle" moet "inactive" zijn._||_
			Das Element "isrelevant" ist falsch, also "lifecycle" muss "inactive" sein.</iso:assert>
	</iso:rule>
</iso:pattern>

<iso:pattern id="medication-contents.structure.checks">
	<iso:title>Medication content structure checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='medication']]/kmehr:content/*">
			<iso:assert test="(local-name()='text' or local-name()='medicinalproduct' or local-name()='substanceproduct' or local-name()='compoundprescription' or ( local-name()='cd' and @S='CD-ATC' ) )" id="Medication" role="ERROR" flag="structure"  >
			A "<iso:value-of select="../../kmehr:cd[@S='CD-ITEM']"/>" content can contain only elements "text", "medicinalproduct",  "substanceproduct", "compoundprescription" or "cd ATC". (Element: "<iso:value-of select="local-name()"/><iso:value-of select="@S"/>")_||_
			Un content "<iso:value-of select="../../kmehr:cd[@S='CD-ITEM']"/>" ne peut contenir que des éléments "text", "medicinalproduct", "substanceproduct", "compoundprescription" ou "cd ATC". (Elément: "<iso:value-of select="local-name()"/><iso:value-of select="@S"/>")_||_
			Een content "<iso:value-of select="../../kmehr:cd[@S='CD-ITEM']"/>" mag enkel de elementen "text", "medicinalproduct", "substanceproduct", "compoundprescription" of "cd ATC" bevatten. (Element: "<iso:value-of select="local-name()"/><iso:value-of select="@S"/>")_||_
			Ein Content "<iso:value-of select="../../kmehr:cd[@S='CD-ITEM']"/>" darf nur die Elemente "text", "medicinalproduct", "substanceproduct", "compoundprescription" oder "cd ATC" umfassen. (Element: "<iso:value-of select="local-name()"/><iso:value-of select="@S"/>")</iso:assert>				
	</iso:rule>
</iso:pattern>

<iso:pattern id="medication.structure.warnings.checks">
	<iso:title>Medication warnings checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='medication']]">
			<iso:assert test="count(kmehr:content[kmehr:medicinalproduct or kmehr:substanceproduct or kmehr:compoundprescription]) &gt; 0" id="Medication" role="WARNING" flag="structure"  >
			Medication should contain at least one content "medicinalproduct" or "substanceproduct" or "compoundprescription"_||_
			Un item "médication" devrait contenir au moins un content "medicinalproduct", "substanceproduct" ou "compoundprescription"._||_
			Een item "medicatie"  zou maar één inhoud "medicinalproduct", "substanceproduct" of "compoundprescription" mogen bevatten._||_
			Ein thema "Medikation" sollte nur ein Inhalt "medicinalproduct", "substanceproduct" oder "compoundprescription" haben. </iso:assert>
			<iso:assert test="kmehr:content[kmehr:cd[@S='CD-ATC']]" id="Medication" role="WARNING" flag="structure"  >
			Medication should have one content with codified ATC._||_
			Un item "médication" devrait contenir un élément "content" contenant un code ATC._||_
			Een item "medicatie" zou één enkel "content"-element met een ATC-code moeten hebben._||_
			Ein thema "Medikation" darf nur einen "Content"-Element mit einem ATC-Code haben. </iso:assert>
	</iso:rule>
</iso:pattern>


<!-- VACCINE -->
<iso:pattern id="vaccine.structure.checks">
	<iso:title>Vaccine structure checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='vaccine']]">
			<iso:assert test="kmehr:content[kmehr:cd[@S='CD-VACCINEINDICATION']]" id="Vaccine" role="ERROR" flag="structure"  >
			Vaccine must have at least one content code CD-VACCINEINDICATION"._||_
			Un item  "vaccin administré" doit contenir au moins un élément "content" contenant un code de CD-VACCINEINDICATION_||_
			Een item "toegediende vaccin" moet minstens een "content"-element met een  CD-VACCINEINDICATION-code hebben._||_
			Ein Thema "durchgeführte Impfung" muss mindestens ein "Content"-Element mit einem CD-VACCINEINDICATION-Code haben.</iso:assert>
			<iso:assert test="count(kmehr:content[kmehr:medicinalproduct or kmehr:substanceproduct]) &lt; 2" id="Vaccine" role="ERROR" flag="structure"  >
			Vaccine must contain maximum one content "medicinalproduct" or "substanceproduct". (Number: <iso:value-of select="count(kmehr:content[kmehr:medicinalproduct or kmehr:substanceproduct])"/>)_||_
			Un item  "vaccin administré" doit contenir au maximum un content "medicinalproduct" ou "substanceproduct". (Nombre: <iso:value-of select="count(kmehr:content[kmehr:medicinalproduct or kmehr:substanceproduct])"/>)_||_
			Een item "toegediende vaccin"  mag maximaal één inhoud "medicinalproduct" of "substanceproduct" bevatten. (Aantal: <iso:value-of select="count(kmehr:content[kmehr:medicinalproduct or kmehr:substanceproduct])"/>)_||_
			Ein Thema "durchgeführte Impfung" soll nur ein Inhalt "medicinalproduct" oder "substanceproduct" haben. (Zahl: <iso:value-of select="count(kmehr:content[kmehr:medicinalproduct or kmehr:substanceproduct])"/>)</iso:assert>
			<iso:assert test="count(kmehr:content[kmehr:cd[@S='CD-ATC']]) &lt; 2" id="Vaccine" role="ERROR" flag="structure"  >
			Vaccine must have maximum one content with codified ATC. (Number: <iso:value-of select="count(kmehr:content[kmehr:cd[@S='CD-ATC']])"/>)_||_
			Un item "vaccin administré" doit contenir au maximum un élément "content" contenant un code ATC. (Nombre: <iso:value-of select="count(kmehr:content[kmehr:cd[@S='CD-ATC']])"/>)_||_
			Een item "toegediende vaccin" mag maximaal een "content"-element met een ATC-code hebben. (Aantal: <iso:value-of select="count(kmehr:content[kmehr:cd[@S='CD-ATC']])"/>)_||_
			Ein Thema "durchgeführte Impfung" darf maximal ein "Content"-Element mit einem ATC-Code haben. (Zahl:  <iso:value-of select="count(kmehr:content[kmehr:cd[@S='CD-ATC']])"/>)</iso:assert>
			<iso:assert test="count(kmehr:content[kmehr:text]) &lt; 2" id="Vaccine" role="ERROR" flag="structure"  >
			Vaccine must have maximum one content with "text"._||_
			Un item "vaccine" doit avoir au maximum un content textuel._||_
			"vaccine" mag maximaal één "content" omvatten met 'text'._||_
			Das Thema "vaccine" darf am meistens ein "content" umfassen mit "text"</iso:assert>
			<iso:assert test="kmehr:lifecycle" id="Vaccine" role="ERROR" flag="structure" >
			Vaccine must have a "lifecycle" element._||_
			Un  item "vaccine" doit contenir un élément "lifecycle"._||_
			"vaccine" moet een "lifecycle" element bevatten._||_
			Das Thema "vaccine" sollte ein "lifecycle" Element umfassen.</iso:assert>
	</iso:rule>
</iso:pattern>

<iso:pattern id="vaccine-contents.structure.checks">
	<iso:title>Vaccine content structure checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='vaccine']]/kmehr:content">
			<iso:assert test="count(kmehr:cd[@S='CD-ATC']) &lt; 2" id="Vaccine" role="ERROR" flag="structure"  >
			Vaccine content must have maximum one codified ATC. (Number: <iso:value-of select="count(kmehr:cd[@S='CD-ATC'])"/>)_||_
			Un item "vaccin administré" doit contenir au maximum un code ATC. (Nombre: <iso:value-of select="count(kmehr:cd[@S='CD-ATC'])"/>)_||_
			Een item "toegediende vaccin" mag maximaal een ATC-code hebben. (Aantal: <iso:value-of select="count(kmehr:cd[@S='CD-ATC'])"/>)_||_
			Ein thema "durchgeführte Impfung" darf maximal ein "ATC-Code haben. (Zahl:  <iso:value-of select="count(kmehr:cd[@S='CD-ATC'])"/>)</iso:assert>
	</iso:rule>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='vaccine']]/kmehr:content/*">
		<iso:assert test="(local-name()='medicinalproduct' or local-name()='substanceproduct' or local-name()='text' or ( local-name()='cd' and (@S='CD-ATC' or @S='CD-VACCINEINDICATION') ) )" id="Vaccine" role="ERROR" flag="structure"  >
		A "<iso:value-of select="../../kmehr:cd[@S='CD-ITEM']"/>" content can contain only elements "medicinalproduct",  "substanceproduct", "text", "cd VACCINEINDICATION" or "cd ATC". (Element: "<iso:value-of select="local-name()"/><iso:value-of select="@S"/>")_||_
		Un content "<iso:value-of select="../../kmehr:cd[@S='CD-ITEM']"/>" ne peut contenir que des éléments "medicinalproduct", "substanceproduct", "text", "cd VACCINEINDICATION" ou "cd ATC". (Elément: "<iso:value-of select="local-name()"/><iso:value-of select="@S"/>")_||_
		Een content "<iso:value-of select="../../kmehr:cd[@S='CD-ITEM']"/>" mag enkel  de elementen "medicinalproduct", "substanceproduct", "text", "cd VACCINEINDICATION" of "cd ATC" bevatten. (Element: "<iso:value-of select="local-name()"/><iso:value-of select="@S"/>")_||_
		Ein Content "<iso:value-of select="../../kmehr:cd[@S='CD-ITEM']"/>" darf nur die Elemente "medicinalproduct", "substanceproduct", "text", "cd VACCINEINDICATION" oder "cd ATC" umfassen. (Element: "<iso:value-of select="local-name()"/><iso:value-of select="@S"/>")</iso:assert>
	</iso:rule>
</iso:pattern>

<iso:pattern id="vaccine.structure.warnings.checks">
	<iso:title>Vaccine warnings checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='vaccine']]">
			<iso:assert test="count(kmehr:content[kmehr:medicinalproduct or kmehr:substanceproduct]) &gt; 0" id="Vaccine" role="WARNING" flag="structure"  >
			Vaccine should contain at least one content "medicinalproduct" or "substanceproduct". (Number: <iso:value-of select="count(kmehr:content[kmehr:medicinalproduct or kmehr:substanceproduct])"/>)_||_
			Un item  "vaccin administré" devrait contenir au moins un content "medicinalproduct" ou "substanceproduct". (Nombre: <iso:value-of select="count(kmehr:content[kmehr:medicinalproduct or kmehr:substanceproduct])"/>)_||_
			Een item "toegediende vaccin"  zou één enkele inhoud "medicinalproduct" of "substanceproduct" mogen bevatten. (Aantal: <iso:value-of select="count(kmehr:content[kmehr:medicinalproduct or kmehr:substanceproduct])"/>)_||_
			Ein thema "durchgeführte Impfung" sollte nur einen Inhalt "medicinalproduct" oder "substanceproduct" haben. (Zahl: <iso:value-of select="count(kmehr:content[kmehr:medicinalproduct or kmehr:substanceproduct])"/>)</iso:assert>			
	</iso:rule>
</iso:pattern>

<iso:pattern id="vaccine.values.warnings.checks">
	<iso:title>Vaccine values warnings checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='vaccine'] and kmehr:lifecycle[kmehr:cd[@S = 'CD-LIFECYCLE' and .='administrated']]]">
			<iso:assert test="kmehr:batch" id="Vaccine" role="WARNING" flag="structure"  >
			Administrated Vaccine should have a "batch" element._||_
			Un vaccin administré devrait avoir un élément "batch"._||_
			Een toegediend vaccin ('administrated') mag een "batch" element bevatten._||_
			Ein durchgeführte Impfung sollte ein Element "batch" umfassen.</iso:assert>
	</iso:rule>
</iso:pattern>

<!-- PATIENTWILL -->
<iso:pattern id="patientwill.structure.checks">
	<iso:title>Patientwill structure checks</iso:title>	
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary']]//kmehr:item[kmehr:cd[@S ='CD-ITEM' and .='patientwill']]">
			<iso:assert test="count(kmehr:content[kmehr:cd]) = 1" id="Patient Will" role="ERROR" flag="structure" >
			Patient Will must have one and only one content with "cd" elements (code). (Number: <iso:value-of select="count(kmehr:content[kmehr:cd])"/>)_||_
			Un item  "volonté du patient" doit contenir un et un seul élément "content" contenant des éléments "cd" (code). (Nombre: <iso:value-of select="count(kmehr:content[kmehr:cd])"/>)_||_
			Een item "wil van de patiënt" mag één enkel "content"-element met "cd"-elementen (code) bevatten (Aantal: <iso:value-of select="count(kmehr:content[kmehr:cd])"/>)_||_
			Ein Thema "Patientenwille" darf nur ein "Content"-Element mit "CD"-Elementen (Code) umfassen. (Zahl: <iso:value-of select="count(kmehr:content[kmehr:cd])"/>)</iso:assert>		
			<iso:assert test="count(kmehr:content[kmehr:text]) &lt; 2" id="Patient Will" role="ERROR" flag="structure" >
			Patient Will must have maximum one content with "text" elements. (Number: <iso:value-of select="count(kmehr:content[kmehr:text])"/>)_||_
			Un item "volonté du patient" doit contenir au maximum un élément "content" contenant des éléments "text". (Nombre: <iso:value-of select="count(kmehr:content[kmehr:text])"/>)_||_
			Een item "wil van de patiënt" mag maximaal één "content"-element met "text"-elementen (code) bevatten (Aantal: <iso:value-of select="count(kmehr:content[kmehr:text])"/>)_||_
			Ein Thema "Patientenwille" darf maximal ein "Content"-Element mit "Text"-Elementen (Code) umfassen. (Zahl: <iso:value-of select="count(kmehr:content[kmehr:text])"/>)</iso:assert>
			<iso:assert test="kmehr:recorddatetime" id="Patient Will" role="ERROR" flag="structure" >
			Patient Will must have a recorddatetime._||_
			Un item "volonté du patient" doit avoir une date d'enregistrement._||_
			Een item "patientwill" moet een registratiedatum hebben._||_
			Ein thema "patientwill" muss ein Erfassungsdatum haben.</iso:assert>
	</iso:rule>
</iso:pattern>

<iso:pattern id="patientwill-contents.structure.checks">
	<iso:title>Patientwill content structure checks</iso:title>	
		<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary']]/kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='patientwill']]/kmehr:content/*">
			<iso:assert test="((local-name()='cd' and current()[@S ='CD-PATIENTWILL']) or local-name()='text' or local-name()='boolean')" id="Patient Will" role="ERROR" flag="structure"  >
			A "<iso:value-of select="../../kmehr:cd[@S='CD-ITEM']"/>" content can contain only elements "text", "boolean" or "cd" with CD-PATIENTWILL codification. (Element: "<iso:value-of select="local-name()"/>")_||_
			Un content "<iso:value-of select="../../kmehr:cd[@S='CD-ITEM']"/>" ne peut contenir que des éléments "text", "boolean" ou "cd" contenant un code de CD-PATIENTWILL. (Elément: "<iso:value-of select="local-name()"/>")_||_
			Een content "<iso:value-of select="../../kmehr:cd[@S='CD-ITEM']"/>" mag enkel "text"-, "boolean"- of "cd"-elementen met een code CD-PATIENTWILL bevatten. (Element: "<iso:value-of select="local-name()"/>")_||_
			Ein Inhalt "<iso:value-of select="../../kmehr:cd[@S='CD-ITEM']"/>" darf nur "Text"-, "Boolean"- oder "CD"-Elemente mit einem CD-PATIENTWILL-Code umfassen. (Element: "<iso:value-of select="local-name()"/>")</iso:assert>		
	</iso:rule>
</iso:pattern>

<!--<iso:pattern id="patientwill.structure.warnings.checks">
	<iso:title>Patientwill strcuture warnings checks</iso:title>	
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary']]//kmehr:item[kmehr:cd[@S ='CD-ITEM' and .='patientwill']]">
			<iso:assert test="not(kmehr:content/kmehr:boolean)" id="Patient Will" role="WARNING" flag="structure" >
			An element "boolean" is present in Patient Will._||_
			Un élément "boolean" est présent dans l'item "volonté du patient"._||_
			Een 'boolean' element is aanwezig in 'patientwill'._||_
			Es gibt ein Element "boolean" in dat thema "patientwill".</iso:assert>
	</iso:rule>
</iso:pattern>-->

<!-- INSURANCYSTATUS -->
<iso:pattern id="insurancystatus.structure.checks">
	<iso:title>Insurancystatus structure checks</iso:title>	
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary']]//kmehr:item[kmehr:cd[@S ='CD-ITEM' and .='insurancystatus']]">
			<iso:assert test="count(kmehr:content[kmehr:insurance]) = 1" id="Insurancy Status" role="ERROR" flag="structure" >
			Insurancy Status must have one and only one content with "insurance" element. (Number: <iso:value-of select="count(kmehr:content[kmehr:insurance])"/>)_||_
			Un item  "insurancystatus" doit contenir un et un seul élément "content" contenant un élément "insurance". (Nombre: <iso:value-of select="count(kmehr:content[kmehr:insurance])"/>)_||_
			Een item "insurancystatus" mag één enkel "content"-element met één "insurance"-element bevatten (Aantal: <iso:value-of select="count(kmehr:content[kmehr:insurance])"/>)_||_
			Ein Thema "insurancystatus" darf nur ein "Content"-Element mit einem "insurance"-Element umfassen. (Zahl: <iso:value-of select="count(kmehr:content[kmehr:insurance])"/>)</iso:assert>
	</iso:rule>
</iso:pattern>

<!-- CAREPLANSUBSCRIPTION -->
<iso:pattern id="careplansubscription.structure.checks">
	<iso:title>Careplansubscription structure checks</iso:title>	
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='clinicalsummary']]/kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='careplansubscription']]">
			<iso:assert test="count(kmehr:content[kmehr:cd]) = 1" id="Careplan Subscription" role="ERROR" flag="structure"  >
			Careplan Subscription must contain one (and only one) cd content. (Number: <iso:value-of select="count(kmehr:content[kmehr:cd])"/>)_||_
			Un item  "careplansubscription" doit contenir un et un seul élément "content" contenant un élément "cd". (Nombre: <iso:value-of select="count(kmehr:content[kmehr:cd])"/>)_||_
			Careplan Subscription mag slechts één enkele cd content bevatten. (Aantal: <iso:value-of select="count(kmehr:content[kmehr:cd])"/>)_||_
			Ein Thema "careplansubscription" darf nur ein cd content umfassen. (Zahl: <iso:value-of select="count(kmehr:content[kmehr:cd])"/>) </iso:assert>
			<iso:assert test="count(kmehr:content[kmehr:text]) &lt; 2" id="Careplan Subscription" role="ERROR" flag="structure"  >
			Careplan Subscription must contain maximum one text content. (Number: <iso:value-of select="count(kmehr:content[kmehr:text])"/>)_||_
			Un item "careplansubscription" doit contenir un et un seul content textuel. (Nombre: <iso:value-of select="count(kmehr:content[kmehr:text])"/>)_||_
			Careplan Subscription mag maximaal één "text" content bevatten. (Aantal: <iso:value-of select="count(kmehr:content[kmehr:text])"/>)_||_
			Ein Thema "careplansubscription" darf nur ein text Inhalt umfassen. (Zahl: <iso:value-of select="count(kmehr:content[kmehr:text])"/>) </iso:assert>
			<iso:assert test="kmehr:isrelevant" id="Careplan Subscription" role="ERROR" flag="structure"  >
			Careplan Subscription must have a "isrelevant" element._||_
			Un item "careplansubscription" doit contenir un élément "isrelevant"._||_
			Careplan Subscription moet een "isrelevant" element bevatten._||_
			Ein Thema "careplansubscription" sollte ein "isrelevant" Element umfassen. </iso:assert>
			<iso:assert test="kmehr:lifecycle" id="Careplan Subscription" role="ERROR" flag="structure"  >
			Careplan Subscription must have a "lifecycle" element._||_
			Un item "careplansubscription" doit contenir un élément "lifecycle"._||_
			Careplan Subscription moet een "lifecycle" element bevatten._||_
			Ein Thema "careplansubscription" sollte ein "lifecycle" Element umfassen. </iso:assert>
			<iso:assert test="kmehr:recorddatetime" id="Careplan Subscription" role="ERROR" flag="structure"  >
			Careplan Subscription must have a recorddatetime._||_
			Un item "careplansubscription" doit avoir une date d'enregistrement._||_
			Een item "Careplansubscription" moet een registratiedatum hebben._||_
			Ein Thema "careplansubscription" solle ein "recorddatetime" umfassen.</iso:assert>
	</iso:rule>
</iso:pattern>

<!-- CONTACT REPORT -->

<!-- ENCOUNTERTYPE -->
<iso:pattern id="encountertype.structure.checks">
	<iso:title>Encountertype structure checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='contactreport']]/kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='encountertype']]">
			<iso:assert test="count(kmehr:content[kmehr:text or kmehr:cd]) = 1" id="Encountertype" role="ERROR" flag="structure"  >
			Encounter type content must contain one (and only one) textual or cd content. (Number: <iso:value-of select="count(kmehr:content[kmehr:text or kmehr:cd])"/>)_||_
			Un item "encountertype" doit contenir un et un seul élément "content" contenant un élément "text" ou "cd". (Nombre: <iso:value-of select="count(kmehr:content[kmehr:text or kmehr:cd])"/>)_||_
			De "encountertype" moet één enkele "text" of "cd" content bevatten. (Aantal: <iso:value-of select="count(kmehr:content[kmehr:text or kmehr:cd])"/>)_||_
			ein Thema "encountertype" darf nur ein text oder ein CD content umfassen. (Zahl: <iso:value-of select="count(kmehr:content[kmehr:text or kmehr:cd])"/>) </iso:assert>
	</iso:rule>
</iso:pattern>

<!-- ENCOUNTERDATETIME -->
<iso:pattern id="encounterdatetime.structure.checks">
	<iso:title>Encounterdatetime structure checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='contactreport']]/kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='encounterdatetime']]">
			<iso:assert test="count(kmehr:content[kmehr:date and kmehr:time]) = 1" id="Encounterdatetime" role="ERROR" flag="structure"  >
			Encounter datetime must contain one (and only one) date and time content. (Number: <iso:value-of select="count(kmehr:content[kmehr:date and kmehr:time])"/>)_||_
			Un item "encounterdatetime" doit contenir un et un seul élément "content" contenant les éléments "date" et "time". (Nombre: <iso:value-of select="count(kmehr:content[kmehr:date and kmehr:time])"/>)_||_
			Encounter datetime moet één enkele "date" en "time" content bevatten. (Aantal: <iso:value-of select="count(kmehr:content[kmehr:date and kmehr:time])"/>)_||_
			Das Thema "encounterdatetime" darf ein "date" und "time" Einhalt umfassen. (Zahl: <iso:value-of select="count(kmehr:content[kmehr:date and kmehr:time])"/>) </iso:assert>
	</iso:rule>
</iso:pattern>

<!-- TRANSACTIONREASON -->
<iso:pattern id="transactionreason.structure.checks">
	<iso:title>Transactionreason structure checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='contactreport']]/kmehr:item[kmehr:cd[@S = 'CD-ITEM' and .='transactionreason']]">
			<iso:assert test="count(kmehr:content[kmehr:text]) &gt; 0" id="Transactionreason" role="WARNING" flag="structure"  >
			Transaction reason should contain at least one textual content corresponding._||_
			Un item "transactionreason" devrait contenir au moins un "content" textuel lui correspondant._||_
			Transaction reason zou minstens met minstens één content "text" moeten overeenkomen._||_
			Das Thema "transactionreason" sollte mindestens ein relatierten "text" oder "content" umfassen.</iso:assert>
	</iso:rule>
</iso:pattern>

<!-- RISKS CONTACT -->
<iso:pattern id="risks.structure.checks">
	<iso:title>Risks structure checks</iso:title>
	<iso:rule context="kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION' and .='contactreport']]//kmehr:item[kmehr:cd[@S = 'CD-ITEM' and ( (.='adr') or (.='risk') or (.='socialrisk') )]]">
			<iso:assert test="count(kmehr:content[kmehr:text]) = 1" id="Risk" role="ERROR" flag="structure"  >
			"<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" must have one content and only one with "text" elements (label). (Number: <iso:value-of select="count(kmehr:content[kmehr:text])"/>)_||_
			"<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" doit contenir un et un seul "content" contenant des éléments "text" (label). (Nombre: <iso:value-of select="count(kmehr:content[kmehr:text])"/>)_||_
			"<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" moet één "content" met één enkel "text"-elementen bevatten (label). (Aantal: <iso:value-of select="count(kmehr:content[kmehr:text])"/>)_||_
			"<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" darf nur einen "Content" mit einem einzigen "Text"-Elementen umfassen (Label). (Zahl: <iso:value-of select="count(kmehr:content[kmehr:text])"/>)</iso:assert>
			<iso:assert test="count(kmehr:content[kmehr:cd]) &lt; 2" id="Risk" role="ERROR" flag="structure"  >
			"<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" must have maximum one content with "cd" elements (codification). (Number: <iso:value-of select="count(kmehr:content[kmehr:cd])"/>)_||_
			"<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" doit contenir au maximum un élément "content" contenant des éléments "cd" (codification). (Nombre: <iso:value-of select="count(kmehr:content[kmehr:cd])"/>)_||_
			"<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" mag maximaal een "content"-element met cd-elementen bevatten (codificatie). (Aantal: <iso:value-of select="count(kmehr:content[kmehr:cd])"/>)_||_
			"<iso:value-of select="kmehr:cd[@S='CD-ITEM']"/>" darf maximal ein "Content"-Element mit CD-Elementen umfassen (Kodifikation). (Zahl): <iso:value-of select="count(kmehr:content[kmehr:cd])"/>)</iso:assert>
	</iso:rule>
</iso:pattern>

</iso:schema>