<?xml version="1.0" encoding="UTF-8"?>
<!-- 
Property : eHealth
Author   : eHealth 
Date     : 01/07/2011
Version 1.0 Written for ehValidator library and tool

This is a schematron file.
The purpose of this schematron is to check sumehr rules on a kmehr file.
Checked input file must be a correct kmehr XML file.

schematron: http://www.schematron.com
Kmehr  definition: https://www.ehealth.fgov.be/standards/kmehr/en/home/home/index.xml
Sumehr definition: https://www.ehealth.fgov.be/standards/kmehr/en/transaction_detail/home/transactions/transaction_detail/Sumehr-1-1.xml
eHealth: https://www.ehealth.fgov.be
-->
<iso:schema 	xmlns="http://purl.oclc.org/dsdl/schematron"
						xmlns:iso="http://purl.oclc.org/dsdl/schematron"
						xmlns:sch="http://www.ascc.net/xml/schematron"
						xmlns:kmehr="http://www.ehealth.fgov.be/standards/kmehr/schema/v1"
						queryBinding="xslt2"
						schemaVersion="ISO19757-3" defaultPhase='#ALL'
						>
	
		<iso:title>Checking a Kmehr document</iso:title>
		<iso:ns prefix="kmehr" uri="http://www.ehealth.fgov.be/standards/kmehr/schema/v1" />
		
		<!-- TODO we treat even known non usefull things. Would be insteresting to add "everywhere" //kmehr:transaction[kmehr:cd[@S='CD-TRANSACTION']='sumehr']/*/  ? -->
		
<!--KMEHR -->
<iso:pattern id="schema-kmehr.structure.checks">
	<iso:title>Kmehr schema check</iso:title>
	<iso:rule context="/*">
			<iso:assert test="kmehr:header" id="Namespace" role="ERROR" flag="structure"  >
			The correct kmehr namespace must be referenced: xmlns="http://www.ehealth.fgov.be/standards/kmehr/schema/v1"._||_
			Le "namespace" correct du Kmehr doit être référencé: xmlns="http://www.ehealth.fgov.be/standards/kmehr/schema/v1"._||_
			De correcte "namespace" van de Kmehr moet als volgt worden gereferenceerd: xmlns="http://www.ehealth.fgov.be/standards/kmehr/schema/v1"._||_
			Der korrekte Kmehr "namespace" soll wie volgt referenziert werden xmlns="http://www.ehealth.fgov.be/standards/kmehr/schema/v1".</iso:assert>
	</iso:rule>
</iso:pattern>

<!--KMEHR ERRORS -->
<iso:pattern id="id-kmehr.structure.checks">
	<iso:title>Kmehr id-kmehr structure checks for key elements</iso:title>
	<iso:rule context="*[local-name()='header' or local-name()='folder' or local-name()='transaction' or local-name()='heading' or local-name()='item']">
			<iso:assert test="count( kmehr:id[@S = 'ID-KMEHR'] ) &lt; 2" id="Identification" role="ERROR" flag="structure"  >
			"<iso:value-of select="local-name()"/>" element can be identified by maximum one 'official' id element (ID-KMEHR)._||_
			L'élément "<iso:value-of select="local-name()"/>" peut être identifié par maximum un élément "official id" (ID_KMEHR)._||_
			Het element "<iso:value-of select="local-name()"/>" kan door maximaal een "official id" (ID_KMEHR) element geïdentificeerd worden._||_
			Das Element "<iso:value-of select="local-name()"/>" kann durch maximal ein "official id" (ID_KMEHR) Element identifiziert werden.</iso:assert>
	</iso:rule>
</iso:pattern>

<iso:pattern id="local-DN.structure.checks">
	<iso:title>DN attribute for local cd structure checks</iso:title>
	<iso:rule context="kmehr:cd[@S='LOCAL' ]">
			<iso:assert test="@DN" id="Codification" role="ERROR" flag="structure"  >
			A local cd must have a "DN" attribute to describe. (Code: "<iso:value-of select="."/>")_||_
			Un cd local doit contenir un attribut "DN" pour le décrire. (Code: "<iso:value-of select="."/>")_||_
			Een lokale cd moet een "DN"-attribuut bevatten om hem te beschrijven. (Code: "<iso:value-of select="."/>")_||_
			Eine lokale CD muss ein "DN" Attribut umfassen um sie zu beschreiben. (Code: "<iso:value-of select="."/>")</iso:assert>
	</iso:rule>
</iso:pattern>

<iso:pattern id="inss.structure.checks">
	<iso:title>Kmehr inss structure checks</iso:title>
	<iso:rule context="//*[kmehr:id[@S = 'ID-PATIENT' or @S = 'INSS']]">
			<iso:assert test="count(kmehr:id[@S = 'ID-PATIENT' or @S = 'INSS']) &lt; 2" id="Identification" role="ERROR" flag="structure" >
			"<iso:value-of select="local-name()"/>" element must have maximum one INSS code. (Number: <iso:value-of select="count(kmehr:id[@S='ID-PATIENT' or @S = 'INSS'])"/>)_||_
			L'élément "<iso:value-of select="local-name()"/>" doit contenir au maximum un code NISS. (Nombre: <iso:value-of select="count(kmehr:id[@S='ID-PATIENT' or @S = 'INSS'])"/>)_||_
			Het element "<iso:value-of select="local-name()"/>" mag maximaal een INSZ-code bevatten (Aantal: <iso:value-of select="count(kmehr:id[@S='ID-PATIENT' or @S = 'INSS'])"/>)_||_
			Das Element "<iso:value-of select="local-name()"/>" darf maximal einen INSS-Code umfassen. (Zahl: <iso:value-of select="count(kmehr:id[@S='ID-PATIENT' or @S = 'INSS'])"/>)</iso:assert>
	</iso:rule>
</iso:pattern>

<iso:pattern id="inss.values.checks">
	<iso:title>Kmehr inss values checks</iso:title>
	<iso:rule context="kmehr:id[ @S = 'ID-PATIENT' or @S = 'INSS']">
			<iso:assert test="number(current()) = floor(number(current())) and number(current()) &lt; 100000000000 and ((97 - (floor(number(current()) div 100) mod 97) = (number(current()) mod 100)) or (97 - ((2000000000 + floor(number(current()) div 100)) mod 97) = (number(current()) mod 100)))" id="Identification" role="ERROR" flag="value" >
			INSS number must be correct - INSS: <iso:value-of select="."/>_||_
			Le Numéro NISS doit être correct. - NISS: <iso:value-of select="."/>_||_
			Het INSZ-nummer moet correct zijn - NISS: <iso:value-of select="."/>_||_
			Die INSS-Nummer muss richtig sein. - INSS: <iso:value-of select="."/></iso:assert>
	</iso:rule>	
</iso:pattern>

<iso:pattern id="id-hcparty.structure.checks">
	<iso:title>Kmehr id-hcparty structure checks</iso:title>
	<iso:rule context="//*[kmehr:id[@S = 'ID-HCPARTY']]">
			<iso:assert test="count(kmehr:id[@S = 'ID-HCPARTY']) &lt; 2" id="Identification" role="ERROR" flag="structure" >
			"<iso:value-of select="local-name()"/>" element must have maximum one INAMI/RIZIV code. (Number: <iso:value-of select="count(kmehr:id[@S='ID-HCPARTY'])"/>)_||_
			L'élément "<iso:value-of select="local-name()"/>" doit contenir au maximum un code INAMI. (Nombre: <iso:value-of select="count(kmehr:id[@S='ID-HCPARTY'])"/>)_||_
			Het element "<iso:value-of select="local-name()"/>" mag maximaal een RIZIV code bevatten. (Aantal: <iso:value-of select="count(kmehr:id[@S='ID-HCPARTY'])"/>)_||_
			Das Element "<iso:value-of select="local-name()"/>" darf maximal einen Code LIKIV umfassen. (Zahl: <iso:value-of select="count(kmehr:id[@S='ID-HCPARTY'])"/>)</iso:assert>
	</iso:rule>
</iso:pattern>

<iso:pattern id="id-hcparty.values.checks">
	<iso:title>Kmehr id-hcparty values checks</iso:title>
	<iso:rule context="kmehr:id[@S = 'ID-HCPARTY']">
			<iso:assert test="string-length(current()) = 0 or number(current()) = floor(number(current())) and ((( string-length(current()) = 8 or string-length(current()) = 10) and ( number(current()) mod 100) = (97 - (floor(number(current()) div 100) mod 97) ) ) or ( string-length(current()) = 11 and ( floor((number(current()) div 1000) ) mod 100) = (97 - (floor(number(current()) div 100000) mod 97) ) ))" id="Identification" role="ERROR" flag="value" >
			INAMI/RIZIV number must be correct. (id: <iso:value-of select="."/>)_||_
			Le Numéro INAMI doit être correct. - INAMI: <iso:value-of select="."/>_||_
			Het RIZIV-nummer moet correct zijn. - RIZIV: <iso:value-of select="."/>_||_
			Die LIKIV-Nummer muss richtig sein. - LIKIV: <iso:value-of select="."/></iso:assert>
	</iso:rule>
</iso:pattern>


<!--KMEHR WARNINGS -->
<iso:pattern id="id-kmehr.structure.warnings.checks">
	<iso:title>Kmehr id-kmehr structure warnings checks for key elements</iso:title>
	<iso:rule context="kmehr:*[local-name()='header' or local-name()='folder' or local-name()='transaction' or local-name()='heading' or local-name()='item']">
			<iso:assert test="kmehr:id[@S='ID-KMEHR']" id="Identification" role="WARNING" flag="structure"  >
			"<iso:value-of select="local-name()"/>" element should be identified by one 'official' id element (ID-KMEHR)._||_
			L'élément "<iso:value-of select="local-name()"/>" devrait être identifié par un élément id 'officiel' (ID-KMEHR)._||_
			Het element "<iso:value-of select="local-name()"/>" zou moeten worden geïdentificeerd aan de hand van een 'officiële' id (ID-KMEHR) element._||_
			Das Element "<iso:value-of select="local-name()"/>" sollte anhand eines 'offiziellen' id (ID-KMEHR) Elementes identifiziert werden.</iso:assert>
	</iso:rule>
</iso:pattern>

 <iso:pattern id="id-kmehr.values.warnings.checks">
	<iso:title>Kmehr id-kmehr values warnings for key elements</iso:title>
	<iso:rule context="//*[ (local-name()='folder' or local-name()='transaction' or local-name()='heading') and (count(kmehr:id[@S='ID-KMEHR'])=1) ]">
			<iso:assert test="( (count(current()/preceding-sibling::*[not(local-name()='header') and not(local-name()='item') and (count(kmehr:id[@S='ID-KMEHR'])=1)]) = 0 ) and ( number( current()/kmehr:id[@S='ID-KMEHR'] ) = 1 ) ) or ( (number( current()/kmehr:id[@S='ID-KMEHR'] ) - 1) = number(current()/preceding-sibling::*[not(local-name()='header') and not(local-name()='item') and (count(kmehr:id[@S='ID-KMEHR'])=1)][1]/kmehr:id[@S='ID-KMEHR']) )" id="Identification" role="WARNING" >
	Official id (ID-KMEHR) for "<iso:value-of select="local-name()"/>" element must be correct. ( ID's start with 1 and are sequential.) Actual id: <iso:value-of select="number( current()/kmehr:id[@S='ID-KMEHR'] )"/>. Preceding id: <iso:value-of select="number(current()/preceding-sibling::*[(count(kmehr:id[@S='ID-KMEHR'])=1)][1]/kmehr:id[@S='ID-KMEHR'])"/>. Following id: <iso:value-of select="number(current()/following-sibling::*[(count(kmehr:id[@S='ID-KMEHR'])=1)][1]/kmehr:id[@S='ID-KMEHR'])"/>._||_
	L'id officiel (ID-KMEHR) pour "<iso:value-of select="local-name()"/>" doit être correct. (les ID commencent à 1 et sont séquentiels.) id actuel: <iso:value-of select="number( current()/kmehr:id[@S='ID-KMEHR'] )"/>. id précédent: <iso:value-of select="number(current()/preceding-sibling::*[(count(kmehr:id[@S='ID-KMEHR'])=1)][1]/kmehr:id[@S='ID-KMEHR'])"/>. id suivant: <iso:value-of select="number(current()/following-sibling::*[(count(kmehr:id[@S='ID-KMEHR'])=1)][1]/kmehr:id[@S='ID-KMEHR'])"/>._||_
	De officiële id (ID-KMEHR) voor "<iso:value-of select="local-name()"/>" moet correct zijn. (de ID's beginnen met 1 en zijn sequentieel.) Actuele id: <iso:value-of select="number( current()/kmehr:id[@S='ID-KMEHR'] )"/>. Vorige id: <iso:value-of select="number(current()/preceding-sibling::*[(count(kmehr:id[@S='ID-KMEHR'])=1)][1]/kmehr:id[@S='ID-KMEHR'])"/>. Volgende id: <iso:value-of select="number(current()/following-sibling::*[(count(kmehr:id[@S='ID-KMEHR'])=1)][1]/kmehr:id[@S='ID-KMEHR'])"/>._||_
	Die offizielle ID (ID-KMEHR) für "<iso:value-of select="local-name()"/>" muss richtig sein. (Die ID fangen an mit 1 und sind sequenziell.) Heutige Id: <iso:value-of select="number( current()/kmehr:id[@S='ID-KMEHR'] )"/>. Vorherige Id: <iso:value-of select="number(current()/preceding-sibling::*[(count(kmehr:id[@S='ID-KMEHR'])=1)][1]/kmehr:id[@S='ID-KMEHR'])"/>. Folgende Id: <iso:value-of select="number(current()/following-sibling::*[(count(kmehr:id[@S='ID-KMEHR'])=1)][1]/kmehr:id[@S='ID-KMEHR'])"/>.</iso:assert>
	</iso:rule>
</iso:pattern>

 <iso:pattern id="items-id-kmehr.values.warnings.checks">
	<iso:title>Kmehr id-kmehr values warnings for items</iso:title>
	<iso:rule context="//*[ local-name()='item' and (count(kmehr:id[@S='ID-KMEHR'])=1) ]">
			<iso:assert test="( (count(current()/preceding-sibling::*[not(local-name()='header') and not(local-name()='heading') and (count(kmehr:id[@S='ID-KMEHR'])=1)]) = 0 ) and ( number( current()/kmehr:id[@S='ID-KMEHR'] ) = 1 ) ) or ( (number( current()/kmehr:id[@S='ID-KMEHR'] ) - 1) = number(current()/preceding-sibling::*[not(local-name()='header') and not(local-name()='heading') and (count(kmehr:id[@S='ID-KMEHR'])=1)][1]/kmehr:id[@S='ID-KMEHR']) )" id="Identification" role="WARNING" >
	Official id (ID-KMEHR) for "<iso:value-of select="local-name()"/>" element must be correct. ( ID's start with 1 and are sequential.) Actual id: <iso:value-of select="number( current()/kmehr:id[@S='ID-KMEHR'] )"/>. Preceding id: <iso:value-of select="number(current()/preceding-sibling::*[(count(kmehr:id[@S='ID-KMEHR'])=1)][1]/kmehr:id[@S='ID-KMEHR'])"/>. Following id: <iso:value-of select="number(current()/following-sibling::*[(count(kmehr:id[@S='ID-KMEHR'])=1)][1]/kmehr:id[@S='ID-KMEHR'])"/>._||_
	L'id officiel (ID-KMEHR) pour "<iso:value-of select="local-name()"/>" doit être correct. (les ID commencent à 1 et sont séquentiels.) id actuel: <iso:value-of select="number( current()/kmehr:id[@S='ID-KMEHR'] )"/>. id précédent: <iso:value-of select="number(current()/preceding-sibling::*[(count(kmehr:id[@S='ID-KMEHR'])=1)][1]/kmehr:id[@S='ID-KMEHR'])"/>. id suivant: <iso:value-of select="number(current()/following-sibling::*[(count(kmehr:id[@S='ID-KMEHR'])=1)][1]/kmehr:id[@S='ID-KMEHR'])"/>._||_
	De officiële id (ID-KMEHR) voor "<iso:value-of select="local-name()"/>" moet correct zijn. (de ID's beginnen met 1 en zijn sequentieel.) Actuele id: <iso:value-of select="number( current()/kmehr:id[@S='ID-KMEHR'] )"/>. Vorige id: <iso:value-of select="number(current()/preceding-sibling::*[(count(kmehr:id[@S='ID-KMEHR'])=1)][1]/kmehr:id[@S='ID-KMEHR'])"/>. Volgende id: <iso:value-of select="number(current()/following-sibling::*[(count(kmehr:id[@S='ID-KMEHR'])=1)][1]/kmehr:id[@S='ID-KMEHR'])"/>._||_
	Die offizielle ID (ID-KMEHR) für "<iso:value-of select="local-name()"/>" muss richtig sein. (Die ID fangen an mit 1 und sind sequenziell.) Heutige Id: <iso:value-of select="number( current()/kmehr:id[@S='ID-KMEHR'] )"/>. Vorherige Id: <iso:value-of select="number(current()/preceding-sibling::*[(count(kmehr:id[@S='ID-KMEHR'])=1)][1]/kmehr:id[@S='ID-KMEHR'])"/>. Folgende Id: <iso:value-of select="number(current()/following-sibling::*[(count(kmehr:id[@S='ID-KMEHR'])=1)][1]/kmehr:id[@S='ID-KMEHR'])"/>.</iso:assert>
	</iso:rule>
</iso:pattern>

<!-- TRANSACTION -->
<iso:pattern id="transaction.structure.checks">
	<iso:title>Transaction structure checks</iso:title>
	<iso:rule context="kmehr:folder/kmehr:transaction" >
			<iso:assert test="count(kmehr:cd[@S='CD-TRANSACTION']) = 1"  id="Transaction" role="ERROR"  flag="structure" >
			A transaction must contain one cd value from CD-TRANSACTION and only one. (Number: <iso:value-of select="count(kmehr:cd[@S = 'CD-TRANSACTION'])"/>)_||_
			Un élément "transaction" doit contenir une et une seule valeur de cd de CD-TRANSACTION. (Nombre: <iso:value-of select="count(kmehr:cd[@S = 'CD-TRANSACTION'])"/>)_||_
			Een element "transaction" mag maar één enkele cd-waarde van CD-TRANSACTION omvatten. (Aantal: <iso:value-of select="count(kmehr:cd[@S = 'CD-TRANSACTION'])"/>)_||_
			Ein Element "transaction" darf nur einen CD-Wert von CD-TRANSACTION umfassen. (Zahl: <iso:value-of select="count(kmehr:cd[@S = 'CD-TRANSACTION'])"/>)</iso:assert>
	</iso:rule>	
</iso:pattern>

<!-- CONTENTS  -->
<iso:pattern id="contents.structure.checks">
	<iso:title>Contents structure checks</iso:title>
	<iso:rule context="//kmehr:transaction[kmehr:cd[@S ='CD-TRANSACTION' and .='sumehr' or .='clinicalsummary' or .='contactreport']]//kmehr:item[kmehr:content]">
			<iso:assert test="count(kmehr:content[count(*) =0 ] ) = 0" id="Content" role="ERROR" flag="structure" >
			A content cannot be empty._||_
			Un élément "content" ne peut pas être vide._||_
			Een "content" element mag niet leeg zijn._||_
			Das "Content"-Element darf nicht leer sein.</iso:assert>
	</iso:rule>
</iso:pattern>

</iso:schema>

