/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.ehvalidator.validators;

import be.fgov.ehealth.ehvalidator.core.EhValidator;
import be.fgov.ehealth.ehvalidator.exceptions.EhValidatorXmlValidationException;
import be.fgov.ehealth.ehvalidator.handler.ErrorValidationHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XsdValidator {
    private static Logger logger = Logger.getLogger(EhValidator.class);
    private static final String KMEHR_VERSION = "1_14";
    private static final String KMEHR_XSD_LOCATION = "/ehealth-kmehr/XSD/kmehr_elements-1_14.xsd";
    private static ResourceBundle rb;
    private static final String[] errorTypes;

    public boolean validate(String fileName, byte[] kmehrMessage, EhValidator.Language language) throws SAXException {
        rb = ResourceBundle.getBundle("cfg/EhValidatorLang", new Locale(language.toString()));
        boolean xmlValidationOK = false;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder parser = dbf.newDocumentBuilder();
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = factory.newSchema(new StreamSource(EhValidator.class.getResource(KMEHR_XSD_LOCATION).toString()));
            Validator validator = schema.newValidator();
            ErrorValidationHandler errorValidationHandler = new ErrorValidationHandler();
            validator.setErrorHandler(errorValidationHandler);
            ByteArrayInputStream is = new ByteArrayInputStream(kmehrMessage);
            DOMSource domsrc = new DOMSource(parser.parse(new InputSource(is)));
            validator.validate(domsrc);
            if (errorValidationHandler.hasExceptions(errorTypes)) {
                logger.fatal(rb.getString("fileCheckedMsg") + fileName);
                for (String exception : errorValidationHandler.getExceptionList("WARNING")) {
                    logger.fatal(exception);
                }
                for (String exception : errorValidationHandler.getExceptionList("ERROR")) {
                    logger.fatal(exception);
                }
                for (String exception : errorValidationHandler.getExceptionList("FATAL")) {
                    logger.fatal(exception);
                }
                throw new EhValidatorXmlValidationException(fileName + " " + rb.getString("xml-validation-failed-1") + KMEHR_VERSION.replace("_", ".") + rb.getString("xml-validation-failed-2"));
            }
            logger.debug("Correct XSD validation");
            xmlValidationOK = true;
        }
        catch (IOException ioe) {
            logger.fatal(ioe);
            logger.fatal(rb.getString("fileCheckedMsg") + fileName);
            throw new EhValidatorXmlValidationException(rb.getString("xml-validation-failed-fnf-1") + " " + fileName + " : " + rb.getString("xml-validation-failed-fnf-2"));
        }
        catch (ParserConfigurationException pce) {
            logger.fatal(pce);
            logger.fatal(rb.getString("fileCheckedMsg") + fileName);
            throw new EhValidatorXmlValidationException(fileName + " " + rb.getString("xml-validation-failed"));
        }
        catch (NullPointerException npe) {
            logger.fatal(npe);
            logger.fatal(rb.getString("sch-schema-missing"));
            throw new EhValidatorXmlValidationException(rb.getString("sch-schema-missing"));
        }
        catch (SAXException e) {
            logger.fatal(e);
            throw new EhValidatorXmlValidationException(fileName + " " + rb.getString("xml-invalid"));
        }
        return xmlValidationOK;
    }

    static {
        errorTypes = new String[]{"WARNING", "ERROR", "FATAL"};
    }
}

