/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.ehvalidator.validators;

import be.fgov.ehealth.ehvalidator.core.EhValidator;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import org.apache.log4j.Logger;
import org.probatron.Session;
import org.probatron.ValidationReport;
import org.xml.sax.SAXException;

public class SchematronValidator {
    private static Logger logger = Logger.getLogger(EhValidator.class);
    private static final String SCHEMATRON_FILE_NAME = "/sch/kmehr-validation.sch";
    private static final String SUMEHR_SCHEMATRON_FILE_NAME = "/sch/sumehr-validation.sch";
    private static final String SMF_SCHEMATRON_FILE_NAME = "/sch/smf-validation.sch";
    private static final String PMF_SCHEMATRON_FILE_NAME = "/sch/pmf-validation.sch";
    private static final int SCH_TERSE_REPORT = 0;
    private static final String ALL_PHASES = "#ALL";
    private static Session theSession = new Session();
    private static URL schemaLocation;
    private static final String SMF = "SMF";
    private static final String PMF = "PMF";
    private static byte[] kmehrValReport;
    private static byte[] specificValReport;
    private static byte[] modifiedReport;

    public byte[] validate(String fileName, String rules) throws SAXException {
        logger.debug("Entering testSchematron");
        boolean validationOK = false;
        schemaLocation = EhValidator.class.getResource(SCHEMATRON_FILE_NAME);
        theSession.setUsePhysicalLocators(true);
        theSession.setReportFormat(0);
        theSession.setPhase(ALL_PHASES);
        theSession.setSchemaDoc(schemaLocation.toString());
        try {
            ValidationReport kmehrValidationreport = theSession.doValidation(fileName);
            kmehrValReport = kmehrValidationreport.reportAsBytes();
            validationOK = true;
        }
        catch (MalformedURLException malformedurlexception) {
            logger.fatal(malformedurlexception);
            return null;
        }
        catch (RuntimeException re) {
            logger.fatal(re);
            return null;
        }
        schemaLocation = SMF.equals(rules) ? EhValidator.class.getResource(SMF_SCHEMATRON_FILE_NAME) : (PMF.equals(rules) ? EhValidator.class.getResource(PMF_SCHEMATRON_FILE_NAME) : EhValidator.class.getResource(SUMEHR_SCHEMATRON_FILE_NAME));
        theSession.setSchemaDoc(schemaLocation.toString());
        try {
            ValidationReport specificValidationreport = theSession.doValidation(fileName);
            specificValReport = specificValidationreport.reportAsBytes();
            validationOK = true;
        }
        catch (MalformedURLException malformedurlexception) {
            logger.fatal(malformedurlexception);
            return null;
        }
        catch (RuntimeException re) {
            logger.fatal(re);
            return null;
        }
        logger.debug(new StringBuilder().append("Leaving testSchematron, result : ").append(validationOK));
        return SchematronValidator.modifyReport(kmehrValReport, specificValReport);
    }

    private static byte[] modifyReport(byte[] kmehrReport, byte[] specificReport) {
        String report = new String(kmehrReport).replace("</svrl:schematron-output>", "").replace("<svrl:failed-assert", "\n<svrl:failed-assert");
        kmehrReport = report.getBytes();
        report = new String(specificReport).replace("<?xml version=\"1.0\" standalone=\"yes\"?>", "");
        int begin = report.indexOf("<svrl:schematron-output");
        int end = report.indexOf("</svrl:ns-prefix-in-attribute-values>") + 37;
        String toRemove = report.substring(begin, end);
        report = report.replace(toRemove, "").replace("<svrl:failed-assert", "\n<svrl:failed-assert");
        begin = report.indexOf("\n\n");
        end = begin + 2;
        toRemove = report.substring(begin, end);
        report = report.replace(toRemove, "");
        specificReport = report.getBytes();
        modifiedReport = ByteBuffer.allocate(kmehrReport.length + specificReport.length).put(kmehrReport).array();
        int start = kmehrReport.length;
        for (int i = 0; i < specificReport.length; ++i) {
            SchematronValidator.modifiedReport[start + i] = specificReport[i];
        }
        return modifiedReport;
    }
}

