/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.ehvalidator.utils;

import be.fgov.ehealth.ehvalidator.core.EhValidator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class XsltTransformer {
    private static Logger logger = Logger.getLogger(EhValidator.class);
    private static final String TEMP_XML_REPORT = "xml_report.xml";
    private static final String SUMEHR_TRANSLATION_DICTIONARY = "/xslt/sumehr_visualization_translation.xml";
    private static final String SMF_TRANSLATION_DICTIONARY = "/xslt/smf_visualization_translation.xml";
    private static final String PMF_TRANSLATION_DICTIONARY = "/xslt/pmf_visualization_translation.xml";
    private static final String SMF = "SMF";
    private static final String PMF = "PMF";
    private static final String FLAG = "flag";

    private XsltTransformer() {
    }

    public static byte[] xsltTransform(String transformType, byte[] toTransform, EhValidator.Language language) {
        return XsltTransformer.xsltTransform(transformType, toTransform, null, language, FLAG);
    }

    public static byte[] xsltTransform(String transformType, byte[] toTransform, String fileName, EhValidator.Language language, String rules) {
        ByteArrayOutputStream bytearrayoutputstream;
        try {
            URL xsltLocation = EhValidator.class.getResource(transformType);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer(new StreamSource(xsltLocation.toURI().toString()));
            transformer.setParameter("language", language.toString());
            bytearrayoutputstream = new ByteArrayOutputStream();
            if (!FLAG.equals(rules)) {
                transformer.setParameter("xmlreport", "xml_report.xml-" + fileName);
                if (SMF.equals(rules)) {
                    transformer.setParameter("translationdictionary", SMF_TRANSLATION_DICTIONARY);
                } else if (PMF.equals(rules)) {
                    transformer.setParameter("translationdictionary", PMF_TRANSLATION_DICTIONARY);
                } else {
                    transformer.setParameter("translationdictionary", SUMEHR_TRANSLATION_DICTIONARY);
                }
                transformer.setURIResolver(XsltTransformer.getUriResolver(rules));
            }
            transformer.transform(new StreamSource(new ByteArrayInputStream(toTransform)), new StreamResult(bytearrayoutputstream));
        }
        catch (TransformerConfigurationException tce) {
            logger.fatal(tce);
            return null;
        }
        catch (TransformerException te) {
            logger.fatal(te);
            return null;
        }
        catch (URISyntaxException use) {
            logger.fatal(use);
            return null;
        }
        return bytearrayoutputstream.toByteArray();
    }

    private static URIResolver getUriResolver(final String rules) {
        URIResolver uriResolver = new URIResolver(){

            @Override
            public Source resolve(String href, String base) {
                try {
                    if (href.startsWith("xml_report.xml-")) {
                        String stringXMLReport = null;
                        stringXMLReport = EhValidator.getXMLReport(href.replaceFirst("xml_report.xml-", ""), rules);
                        return new StreamSource(new ByteArrayInputStream(stringXMLReport.getBytes()));
                    }
                    return new StreamSource(EhValidator.class.getResource(href).toString());
                }
                catch (SAXException se) {
                    logger.fatal(se);
                    return new StreamSource();
                }
                catch (FileNotFoundException fnfe) {
                    logger.fatal(fnfe);
                    return new StreamSource();
                }
                catch (IOException ioe) {
                    logger.fatal(ioe);
                    return new StreamSource();
                }
            }
        };
        return uriResolver;
    }
}

