/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.ehvalidator.handler;

import java.util.ArrayList;
import java.util.List;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ErrorValidationHandler
implements ErrorHandler {
    public static final String WARNING = "WARNING";
    public static final String ERROR = "ERROR";
    public static final String FATAL = "FATAL";
    private List<String> exceptionWarningList = new ArrayList<String>();
    private List<String> exceptionErrorList = new ArrayList<String>();
    private List<String> exceptionFatalList = new ArrayList<String>();

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        String msg = "WARNING " + this.toString(exception);
        this.exceptionWarningList.add(msg);
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        String msg = "ERROR " + this.toString(exception);
        this.exceptionErrorList.add(msg);
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        String msg = "FATAL " + this.toString(exception);
        this.exceptionFatalList.add(msg);
    }

    private String toString(SAXParseException exception) {
        return exception.getMessage();
    }

    public final List<String> getExceptionList(String ... errorType) {
        ArrayList<String> exceptionList = new ArrayList<String>();
        if (this.contains(errorType, WARNING)) {
            exceptionList.addAll(this.exceptionWarningList);
        }
        if (this.contains(errorType, ERROR)) {
            exceptionList.addAll(this.exceptionErrorList);
        }
        if (this.contains(errorType, FATAL)) {
            exceptionList.addAll(this.exceptionFatalList);
        }
        return exceptionList;
    }

    public final boolean hasExceptions(String ... errorType) {
        boolean hasException = false;
        if (this.contains(errorType, WARNING)) {
            hasException |= this.isNotEmpty(this.exceptionWarningList);
        }
        if (this.contains(errorType, ERROR)) {
            hasException |= this.isNotEmpty(this.exceptionErrorList);
        }
        if (this.contains(errorType, FATAL)) {
            hasException |= this.isNotEmpty(this.exceptionFatalList);
        }
        return hasException;
    }

    private boolean isNotEmpty(List<?> inputList) {
        return !this.isEmpty(inputList);
    }

    private boolean isEmpty(List<?> inputList) {
        return inputList.size() <= 0;
    }

    private boolean contains(Object[] array, Object objectToFind) {
        for (Object item : array) {
            if (!item.equals(objectToFind)) continue;
            return true;
        }
        return false;
    }
}

