/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.ehvalidator.core;

import be.fgov.ehealth.ehvalidator.exceptions.EhValidatorSchematronException;
import be.fgov.ehealth.ehvalidator.exceptions.EhValidatorXmlValidationException;
import be.fgov.ehealth.ehvalidator.exceptions.EhValidatorXsltTransformException;
import be.fgov.ehealth.ehvalidator.utils.DocumentUtils;
import be.fgov.ehealth.ehvalidator.utils.XsltTransformer;
import be.fgov.ehealth.ehvalidator.validators.SchematronValidator;
import be.fgov.ehealth.ehvalidator.validators.XsdValidator;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;
import org.xml.sax.SAXException;

public class EhValidator {
    private static final String XSLT_SCH_TO_HTML = "/xslt/sch_to_html.xslt";
    private static final String XSLT_SCH_TO_HTML_SMF = "/xslt/sch_to_html_smf.xslt";
    private static final String XSLT_SCH_TO_HTML_PMF = "/xslt/sch_to_html_pmf.xslt";
    private static final String XSLT_SCH_TO_XML = "/xslt/sch_to_xml.xslt";
    private static final String XSLT_SUMEHR_TO_HTML_WITH_REPORT = "/xslt/sumehr_to_html_with_report.xslt";
    private static final String XSLT_SMF_TO_HTML = "/xslt/smf_to_html.xslt";
    private static final String XSLT_PMF_TO_HTML = "/xslt/pmf_to_html.xslt";
    private static final String KMEHR_NAMESPACE = "http://www.ehealth.fgov.be/standards/kmehr/schema/v1";
    private static Logger logger = Logger.getLogger(EhValidator.class);
    private static final int APP_EXIT_FAIL = -1;
    private static final int APP_EXIT_OKAY = 0;
    private static final int VALIDATION = 0;
    private static final int REP_XML = 1;
    private static final int REP_HTML = 2;
    private static final int REP_HTML_EN = 21;
    private static final int REP_HTML_FR = 22;
    private static final int REP_HTML_NL = 23;
    private static final int REP_HTML_DE = 24;
    private static final int VIEW_HTML_EN = 3;
    private static final int VIEW_HTML_FR = 4;
    private static final int VIEW_HTML_NL = 5;
    private static final int VIEW_HTML_DE = 6;
    private static final int REP_SCH = 9;
    private static final int UNKNOWN = 999;
    private static final int REQUEST = 50;
    private static final int VERSION = 51;
    private static final int HELP = 52;
    private static final int RULES_SUMEHR = 70;
    private static final int RULES_SMF = 71;
    private static final int RULES_PMF = 72;
    private static ResourceBundle rb;
    private static String requestedRules;
    private static String xslt;
    private static final String SUMEHR = "Sumehr";
    private static final String SMF = "SMF";
    private static final String PMF = "PMF";
    private static byte[] modifiedReport;
    private static byte[] transformedReport;
    private static XsdValidator xsdValidator;
    private static SchematronValidator schematronValidator;
    private static final String PACKAGE = "be.fgov.ehealth.ehvalidator.core";

    private static String sanitizeFileName(String fileName) {
        if (fileName.indexOf(58) == -1 || fileName.indexOf(58) == 1) {
            fileName = "file:" + fileName;
        }
        return fileName;
    }

    public static String getHTMLReport(String fileName) throws SAXException, FileNotFoundException, IOException {
        return EhValidator.getHTMLReport(fileName, Language.english, SUMEHR);
    }

    public static String getHTMLReport(String fileName, Language language) throws SAXException, FileNotFoundException, IOException {
        return EhValidator.getHTMLReport(fileName, language, SUMEHR);
    }

    public static String getHTMLReport(String fileName, Language language, String rules) throws SAXException, FileNotFoundException, IOException {
        logger.debug(new StringBuilder().append("Entering getHTMLReport"));
        String report = EhValidator.getReport(fileName, 2, language, rules);
        logger.debug(new StringBuilder().append("Leaving getHTMLReport"));
        return report;
    }

    public static String getXMLReport(String fileName) throws SAXException, FileNotFoundException, IOException {
        return EhValidator.getXMLReport(fileName, SUMEHR);
    }

    public static String getXMLReport(String fileName, String rules) throws SAXException, FileNotFoundException, IOException {
        logger.debug("Entering getXMLReport");
        String report = EhValidator.getReport(fileName, 1, Language.english, rules);
        logger.debug("Leaving getXMLReport");
        return report;
    }

    private static String getReport(String fileName, int reportType, Language language, String rules) throws SAXException, FileNotFoundException, IOException {
        byte[] kmehrMessage = DocumentUtils.convertInputStreamToByteArray(new FileInputStream(fileName));
        transformedReport = null;
        boolean reportOK = false;
        String logMsg = rb.getString("producingReportMsg1").concat(fileName);
        logMsg = reportType == 2 ? logMsg.concat(" ").concat(rb.getString("producingReportMsgHTML")) : logMsg.concat(" ").concat(rb.getString("producingReportMsgXML"));
        logger.info(logMsg);
        reportOK = xsdValidator.validate(fileName, kmehrMessage, language);
        if (reportOK) {
            modifiedReport = schematronValidator.validate(fileName = EhValidator.sanitizeFileName(fileName), rules);
            if (modifiedReport.length <= 0) {
                reportOK = false;
            }
        } else {
            logger.error(fileName.concat(" ").concat(rb.getString("xmlValidationFailed")).concat(KMEHR_NAMESPACE));
            throw new EhValidatorXmlValidationException(fileName + rb.getString("xml-validation-failed"));
        }
        if (reportOK) {
            switch (reportType) {
                case 2: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    if (SMF.equals(rules)) {
                        transformedReport = XsltTransformer.xsltTransform(XSLT_SCH_TO_HTML_SMF, modifiedReport, language);
                        break;
                    }
                    if (PMF.equals(rules)) {
                        transformedReport = XsltTransformer.xsltTransform(XSLT_SCH_TO_HTML_PMF, modifiedReport, language);
                        break;
                    }
                    transformedReport = XsltTransformer.xsltTransform(XSLT_SCH_TO_HTML, modifiedReport, language);
                    break;
                }
                case 1: {
                    transformedReport = XsltTransformer.xsltTransform(XSLT_SCH_TO_XML, modifiedReport, Language.english);
                    reportOK = true;
                    break;
                }
                case 9: {
                    return new String(modifiedReport);
                }
                default: {
                    reportOK = false;
                    break;
                }
            }
        } else {
            logger.error(fileName + " is a valid Kmehr document, but doesn't pass the Schematron rules.");
            throw new EhValidatorSchematronException(fileName + " " + rb.getString("sch-validation-failed"));
        }
        if (reportOK) {
            String s = new String(transformedReport);
            return s;
        }
        throw new EhValidatorXsltTransformException(rb.getString("xslt-sch-transformation-failed-1") + " " + fileName + rb.getString("xslt-sch-transformation-failed-2"));
    }

    public static String getHTMLView(String fileName) throws EhValidatorXmlValidationException, EhValidatorSchematronException, EhValidatorXsltTransformException, FileNotFoundException, IOException, SAXException {
        return EhValidator.getHTMLView(fileName, Language.english, SUMEHR);
    }

    public static String getHTMLView(String fileName, Language language) throws EhValidatorXmlValidationException, EhValidatorSchematronException, EhValidatorXsltTransformException, FileNotFoundException, IOException, SAXException {
        return EhValidator.getHTMLView(fileName, language, SUMEHR);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getHTMLView(String fileName, Language language, String rules) throws EhValidatorXmlValidationException, EhValidatorSchematronException, EhValidatorXsltTransformException, FileNotFoundException, IOException, SAXException {
        byte[] kmehrMessage = DocumentUtils.convertInputStreamToByteArray(new FileInputStream(fileName));
        byte[] htmlView = null;
        boolean transformOK = false;
        transformOK = xsdValidator.validate(fileName, kmehrMessage, language);
        if (!transformOK) throw new EhValidatorXmlValidationException(fileName + " " + rb.getString("xml-invalid"));
        modifiedReport = schematronValidator.validate(EhValidator.sanitizeFileName(fileName), rules);
        if (modifiedReport.length <= 0) {
            transformOK = false;
        }
        if (!transformOK) throw new EhValidatorSchematronException(fileName + " " + rb.getString("sch-invalid"));
        xslt = SMF.equals(rules) ? XSLT_SMF_TO_HTML : (PMF.equals(rules) ? XSLT_PMF_TO_HTML : XSLT_SUMEHR_TO_HTML_WITH_REPORT);
        try {
            htmlView = XsltTransformer.xsltTransform(xslt, kmehrMessage, fileName, language, rules);
            if (htmlView.length > 0) {
                transformOK = true;
            }
        }
        catch (EhValidatorSchematronException ese) {
            throw new EhValidatorSchematronException(fileName + " " + rb.getString("sch-invalid"));
        }
        if (!transformOK) throw new EhValidatorXsltTransformException(rb.getString("xslt-html-transformation-failed-1") + " " + fileName + " " + rb.getString("xslt-html-transformation-failed-2"));
        return new String(htmlView);
    }

    public static ValidationResult validate(String fileName) throws EhValidatorXmlValidationException, EhValidatorSchematronException, IOException, SAXException {
        return EhValidator.validate(fileName, SUMEHR);
    }

    public static ValidationResult validate(String fileName, String rules) throws EhValidatorXmlValidationException, EhValidatorSchematronException, IOException, SAXException {
        byte[] kmehrMessage = DocumentUtils.convertInputStreamToByteArray(new FileInputStream(fileName));
        boolean transformOK = false;
        transformOK = xsdValidator.validate(fileName, kmehrMessage, Language.english);
        if (transformOK) {
            modifiedReport = schematronValidator.validate(EhValidator.sanitizeFileName(fileName), rules);
            if (modifiedReport.length > 0) {
                transformOK = true;
            }
        } else {
            throw new EhValidatorXmlValidationException(fileName + " " + rb.getString("xml-invalid"));
        }
        if (transformOK) {
            return EhValidator.getReportValidity(modifiedReport);
        }
        throw new EhValidatorSchematronException(fileName + " " + rb.getString("sch-invalid-2"));
    }

    private static ValidationResult getReportValidity(byte[] report) throws EhValidatorSchematronException {
        Document argReport;
        logger.debug("Entering getReportValidity");
        int iNumberErrors = 0;
        int iNumberWarnings = 0;
        boolean isValid = false;
        try {
            transformedReport = XsltTransformer.xsltTransform(XSLT_SCH_TO_XML, report, Language.english);
            if (transformedReport.length > 0) {
                isValid = true;
            }
            argReport = DocumentHelper.parseText(new String(transformedReport));
        }
        catch (DocumentException e) {
            logger.debug(e.getMessage());
            throw new EhValidatorSchematronException(e.getMessage());
        }
        List list = argReport.selectNodes("//report/header/validationResult/errors");
        ArrayList<Node> nodeList = new ArrayList<Node>();
        for (Object nodeErr : list) {
            nodeList.add((Node)nodeErr);
        }
        Node node = (Node)nodeList.get(0);
        iNumberErrors = Integer.parseInt(node.getText());
        list = argReport.selectNodes("//report/header/validationResult/warnings");
        nodeList = new ArrayList();
        for (Object nodeWar : list) {
            nodeList.add((Node)nodeWar);
        }
        node = (Node)nodeList.get(0);
        iNumberWarnings = Integer.parseInt(node.getText());
        logger.debug("Number of errors found in the report: " + iNumberErrors + ", number of warnings : " + iNumberWarnings);
        logger.debug(new StringBuilder().append("Leaving checkReportValidity, result : ").append(isValid));
        if (iNumberErrors > 0) {
            return ValidationResult.NOK;
        }
        if (iNumberWarnings > 0) {
            return ValidationResult.OK_WARN;
        }
        return ValidationResult.OK;
    }

    private static void showUsage() {
        String usageExplanation = "Usage: " + Package.getPackage(PACKAGE).getImplementationTitle() + "-" + Package.getPackage(PACKAGE).getImplementationVersion() + ".jar [option] [choice] [inputfile]" + "\n" + "\nOptions:" + "\n\t-v|--version :\t\t\tShow version info and halt" + "\n\t-h|--help|-? :\t\t\tShow usage" + "\n\t-r|--request <choice> <file> :\tExecute validation" + "\n" + "\nChoices:" + "\n\tvalidation :\tGet Validation Result" + "\n\txmlreport :\tGet Report as XML" + "\n\thtmlreport :\tGet Report as HTML" + "\n\thtmlview :\tGet View as HTML" + "\n" + "\nExample:" + "\n" + Package.getPackage(PACKAGE).getImplementationTitle() + "-" + Package.getPackage(PACKAGE).getImplementationVersion() + ".jar -request xmlreport document.xml";
        System.err.println(usageExplanation);
        System.exit(-1);
    }

    private static void executeCommandLineValidation(int request, int rules, String inputFile) {
        String result = "";
        Language language = Language.english;
        switch (rules) {
            case 70: {
                requestedRules = SUMEHR;
                break;
            }
            case 71: {
                requestedRules = SMF;
                break;
            }
            case 72: {
                requestedRules = PMF;
                break;
            }
            default: {
                requestedRules = SUMEHR;
            }
        }
        switch (request) {
            case 0: {
                try {
                    result = String.valueOf((Object)EhValidator.validate(inputFile, requestedRules));
                }
                catch (Exception ex) {
                    logger.fatal(ex);
                    System.err.println("Not a correct kmehr: no report. Exception:\n" + ex.toString());
                    System.exit(-1);
                }
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                switch (request) {
                    case 3: {
                        language = Language.english;
                        break;
                    }
                    case 4: {
                        language = Language.french;
                        break;
                    }
                    case 5: {
                        language = Language.dutch;
                        break;
                    }
                    case 6: {
                        language = Language.german;
                    }
                }
                try {
                    result = EhValidator.getHTMLView(inputFile, language, requestedRules);
                }
                catch (Exception ex) {
                    logger.fatal(ex);
                    logger.fatal(ex);
                    System.err.println("Not a correct file: not viewable. Exception:\n" + ex.toString());
                    System.exit(-1);
                }
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                switch (request) {
                    case 21: {
                        language = Language.english;
                        break;
                    }
                    case 22: {
                        language = Language.french;
                        break;
                    }
                    case 23: {
                        language = Language.dutch;
                        break;
                    }
                    case 24: {
                        language = Language.german;
                    }
                }
            }
            case 1: 
            case 9: {
                try {
                    result = EhValidator.getReport(inputFile, request, language, requestedRules);
                }
                catch (Exception ex) {
                    logger.fatal(ex);
                    System.err.println("Not a correct kmehr: no report. Exception:\n" + ex.toString());
                    System.exit(-1);
                }
                break;
            }
            default: {
                logger.fatal("Unrecognized command-line option for request\"." + (" second parameter:" + String.valueOf(request)) + "\". Aborting.");
                System.err.println("Unsupported argument.");
                EhValidator.showUsage();
            }
        }
        System.out.println(result);
    }

    private static int handleCommandLineArg(String parameter) {
        int value = 999;
        value = parameter.equals("-v") || parameter.equals("-validation") || parameter.equals("--validation") ? 51 : (parameter.equals("-h") || parameter.equals("-help") || parameter.equals("--help") || parameter.equals("-?") ? 52 : (parameter.equals("-r") || parameter.equals("-request") || parameter.equals("--request") ? 50 : (parameter.equals("validation") ? 0 : (parameter.equals("xmlreport") ? 1 : (parameter.equals("htmlreport") ? 21 : (parameter.equals("htmlreporten") ? 21 : (parameter.equals("htmlreportfr") ? 22 : (parameter.equals("htmlreportnl") ? 23 : (parameter.equals("htmlreportde") ? 24 : (parameter.equals("htmlview") ? 3 : (parameter.equals("htmlviewen") ? 3 : (parameter.equals("htmlviewfr") ? 4 : (parameter.equals("htmlviewnl") ? 5 : (parameter.equals("htmlviewde") ? 6 : (parameter.equals("sumehr") ? 70 : (parameter.equals("smf") ? 71 : (parameter.equals("pmf") ? 72 : 999)))))))))))))))));
        return value;
    }

    public static void main(String[] args) {
        long l = System.currentTimeMillis();
        PropertyConfigurator.configure("../cfg/EhValidator.properties");
        if (args.length == 0) {
            EhValidator.showUsage();
        }
        int typeArgs = EhValidator.handleCommandLineArg(args[0]);
        block0 : switch (args.length) {
            case 1: {
                switch (typeArgs) {
                    case 51: {
                        System.err.println(Package.getPackage(PACKAGE).getImplementationTitle().concat("-").concat(Package.getPackage(PACKAGE).getImplementationVersion()));
                        break block0;
                    }
                    case 52: {
                        EhValidator.showUsage();
                        break block0;
                    }
                }
                EhValidator.executeCommandLineValidation(0, 70, args[0]);
                break;
            }
            case 2: {
                switch (typeArgs) {
                    case 70: 
                    case 71: 
                    case 72: {
                        EhValidator.executeCommandLineValidation(0, EhValidator.handleCommandLineArg(args[0]), args[1]);
                        break block0;
                    }
                }
                logger.fatal("Unrecognized command-line option \"." + (" Number Arguments: " + String.valueOf(args.length)) + (" first parameter: " + String.valueOf(args[0])) + "\". Aborting.");
                System.err.println("Invalid arguments");
                EhValidator.showUsage();
                break;
            }
            case 3: {
                switch (typeArgs) {
                    case 50: {
                        EhValidator.executeCommandLineValidation(EhValidator.handleCommandLineArg(args[1]), 70, args[2]);
                        break block0;
                    }
                }
                logger.fatal("Unrecognized command-line option \"." + (" Number Arguments: " + String.valueOf(args.length)) + (" first parameter: " + String.valueOf(args[0])) + "\". Aborting.");
                System.err.println("Invalid arguments");
                EhValidator.showUsage();
                break;
            }
            case 4: {
                switch (typeArgs) {
                    case 50: {
                        switch (EhValidator.handleCommandLineArg(args[1])) {
                            case 70: 
                            case 71: 
                            case 72: {
                                EhValidator.executeCommandLineValidation(EhValidator.handleCommandLineArg(args[2]), EhValidator.handleCommandLineArg(args[1]), args[3]);
                                break block0;
                            }
                        }
                        logger.fatal("Unrecognized command-line option \"." + (" Number Arguments: " + String.valueOf(args.length)) + (" first parameter: " + String.valueOf(args[0])) + "\". Aborting.");
                        System.err.println("Invalid arguments");
                        EhValidator.showUsage();
                        break block0;
                    }
                }
                logger.fatal("Unrecognized command-line option \"." + (" Number Arguments: " + String.valueOf(args.length)) + (" first parameter: " + String.valueOf(args[0])) + "\". Aborting.");
                System.err.println("Invalid arguments");
                EhValidator.showUsage();
                break;
            }
            default: {
                logger.fatal("Unrecognized command-line option \"." + (" Number Arguments: " + String.valueOf(args.length)) + (" first parameter: " + String.valueOf(args[0])) + "\". Aborting.");
                System.err.println("Invalid arguments");
                EhValidator.showUsage();
            }
        }
        logger.info("Done. Elapsed time (ms):" + (System.currentTimeMillis() - l));
        System.exit(0);
    }

    static {
        xsdValidator = new XsdValidator();
        schematronValidator = new SchematronValidator();
        Locale locale = Locale.getDefault();
        rb = ResourceBundle.getBundle("cfg/EhValidatorLang", locale);
    }

    public static enum ValidationResult {
        OK,
        OK_WARN,
        NOK;

    }

    public static enum Language {
        english,
        french,
        dutch,
        german;

    }
}

