/*
 * Decompiled with CFR 0.152.
 */
package org.probatron;

import com.megginson.sax.XMLWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import org.apache.log4j.Logger;
import org.probatron.EnrichmentFilter;
import org.probatron.LocationMapHandler;
import org.probatron.LogicalPhysicalMap;
import org.probatron.NamespacePrefixMappings;
import org.probatron.Session;
import org.probatron.SvrlHarvestHandler;
import org.probatron.Utils;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ValidationReport {
    static Logger logger = Logger.getLogger(ValidationReport.class);
    private byte[] reportBytes;
    LogicalPhysicalMap locMap = new LogicalPhysicalMap();
    private SvrlHarvestHandler harvestHandler = new SvrlHarvestHandler(this);
    private LocationMapHandler locationMapHandler = new LocationMapHandler(this);
    NamespacePrefixMappings nsMap = new NamespacePrefixMappings();
    public static final int REPORT_SVRL_COMPACT = 0;
    public static final int REPORT_SVRL_FULL = 1;
    public static final int REPORT_SVRL_MERGED = 2;

    public ValidationReport(byte[] byArray) {
        this.reportBytes = byArray;
    }

    public void streamOut(OutputStream outputStream) {
        try {
            Utils.transferBytesToEndOfStream(new ByteArrayInputStream(this.reportBytes), outputStream, 0);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public byte[] reportAsBytes() {
        return this.reportBytes;
    }

    public void mergeSvrlIntoCandidate(Session session, URL uRL) {
    }

    public void annotateWithLocators(Session session, URL uRL) {
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setContentHandler(this.harvestHandler);
            xMLReader.parse(new InputSource(new ByteArrayInputStream(this.reportBytes)));
            xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setContentHandler(this.locationMapHandler);
            xMLReader.parse(uRL.toString());
            logger.debug("Mapped " + this.locMap.size() + " XPaths to physical locations");
            XMLReader xMLReader2 = XMLReaderFactory.createXMLReader();
            EnrichmentFilter enrichmentFilter = new EnrichmentFilter(session, this);
            enrichmentFilter.setParent(xMLReader2);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            enrichmentFilter.setContentHandler(new XMLWriter(new OutputStreamWriter(byteArrayOutputStream)));
            enrichmentFilter.parse(new InputSource(new ByteArrayInputStream(this.reportBytes)));
            this.reportBytes = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            logger.fatal(exception);
            exception.printStackTrace();
            throw new RuntimeException(exception.getMessage());
        }
    }
}

