/*
 * Decompiled with CFR 0.152.
 */
package org.probatron;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.transform.TransformerFactory;
import org.apache.log4j.Logger;

public class Utils {
    public static final String SCHEMATRON_NAME = "http://purl.oclc.org/dsdl/schematron";
    public static String SVRL_NAME = "http://purl.oclc.org/dsdl/svrl";
    private static final String PROPERTY_TRAX_IMPLEMENTATION = "javax.xml.transform.TransformerFactory";
    private static final String SAXON_TRAX_CLASS = "net.sf.saxon.TransformerFactoryImpl";
    private static final int READ_BUFFER_SIZE = 32768;
    public static final int CLOSE_NONE = 0;
    public static final int CLOSE_IN = 1;
    public static final int CLOSE_OUT = 16;
    static Logger logger = Logger.getLogger(Utils.class);

    public static TransformerFactory getTransformerFactory() {
        System.setProperty(PROPERTY_TRAX_IMPLEMENTATION, SAXON_TRAX_CLASS);
        return TransformerFactory.newInstance();
    }

    public static byte[] derefUrl(URL uRL) {
        byte[] byArray = null;
        InputStream inputStream = null;
        try {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.connect();
            inputStream = uRLConnection.getInputStream();
            byArray = Utils.getBytesToEndOfStream(inputStream, true);
        }
        catch (IOException iOException) {
            logger.warn(iOException.getMessage());
            return null;
        }
        return byArray;
    }

    public static byte[] getBytesToEndOfStream(InputStream inputStream, boolean bl) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Utils.transferBytesToEndOfStream(inputStream, byteArrayOutputStream, bl ? 17 : 16);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return byArray;
    }

    public static long transferBytesToEndOfStream(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        int n2;
        if (inputStream == null || outputStream == null) {
            logger.fatal("transferBytesToEndOfStream() called with a null parameter");
            throw new IllegalArgumentException();
        }
        byte[] byArray = new byte[32769];
        long l = 0L;
        while ((n2 = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n2);
            l += (long)n2;
        }
        if ((n & 1) != 0) {
            Utils.streamClose(inputStream);
        }
        if ((n & 0x10) != 0) {
            Utils.streamClose(outputStream);
        }
        byArray = null;
        return l;
    }

    public static void streamClose(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception exception) {
            logger.warn(exception.getMessage());
        }
    }

    public static void streamClose(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (Exception exception) {
            logger.warn(exception.getMessage());
        }
    }

    public static void streamToFile(InputStream inputStream, String string, boolean bl) throws IOException {
        File file = new File(string);
        file.createNewFile();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            int n = 16;
            if (bl) {
                n |= 1;
            }
            Utils.transferBytesToEndOfStream(inputStream, fileOutputStream, n);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("File not found when writing: ", fileNotFoundException);
        }
    }

    public static void writeBytesToFile(byte[] byArray, String string) throws IOException {
        File file = new File(string);
        file.createNewFile();
        FileOutputStream fileOutputStream = null;
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            Utils.transferBytesToEndOfStream(byteArrayInputStream, fileOutputStream, 17);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("File not found when writing: ", fileNotFoundException);
        }
    }

    static String trimAttributePart(String string) {
        String string2 = null;
        int n = string.indexOf("@");
        if (n != -1) {
            string2 = string.substring(0, n);
            logger.trace("Trimmed xpath to: " + string2);
        } else {
            string2 = string;
        }
        return string2;
    }
}

