/*
 * Decompiled with CFR 0.152.
 */
package org.probatron;

import org.apache.log4j.Logger;
import org.probatron.PhysicalLocation;
import org.probatron.Utils;
import org.probatron.ValidationReport;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SvrlHarvestHandler
implements ContentHandler {
    static Logger logger = Logger.getLogger(SvrlHarvestHandler.class);
    ValidationReport rpt;

    public SvrlHarvestHandler(ValidationReport validationReport) {
        this.rpt = validationReport;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
        logger.debug("SVRL harvest done; xpath count:" + this.rpt.locMap.size());
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
        logger.debug("Beginning SVRL harvest");
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string.equals(Utils.SVRL_NAME)) {
            if (string2.equals("successful-report") || string2.equals("failed-assert")) {
                String string4 = attributes.getValue("location");
                logger.trace("Harvesting xpath:" + string4);
                if (this.rpt.locMap.get(string4) == null) {
                    string4 = Utils.trimAttributePart(string4);
                    this.rpt.locMap.put(string4, new PhysicalLocation());
                }
            } else if (string2.equals("ns-prefix-in-attribute-values")) {
                String string5 = attributes.getValue("prefix");
                String string6 = attributes.getValue("uri");
                this.rpt.nsMap.registerMapping(string5, string6);
            }
        }
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
    }
}

