/*
 * Decompiled with CFR 0.152.
 */
package org.probatron;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.probatron.SchematronSchema;
import org.probatron.ValidationReport;

public class Session {
    static Logger logger = Logger.getLogger(Session.class);
    private boolean physicalLocators = true;
    private String phase;
    private String schemaDoc;
    private SchematronSchema theSchema;
    private UUID uuid = UUID.randomUUID();
    private int reportFormat;

    public ValidationReport doValidation(String string) throws MalformedURLException {
        ValidationReport validationReport = null;
        this.theSchema = new SchematronSchema(this, new URL(this.schemaDoc));
        validationReport = this.theSchema.validateCandidate(new URL(string));
        if (this.physicalLocators) {
            validationReport.annotateWithLocators(this, new URL(string));
        }
        if (this.getReportFormat() == 2) {
            validationReport.mergeSvrlIntoCandidate(this, new URL(string));
        }
        return validationReport;
    }

    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String string) {
        this.phase = string;
        logger.debug("Using phase: " + string);
    }

    public String getSchemaDoc() {
        return this.schemaDoc;
    }

    public void setSchemaDoc(String string) {
        this.schemaDoc = string;
        logger.debug("Schema document is:" + string);
    }

    public boolean usesPhysicalLocators() {
        return this.physicalLocators;
    }

    public void setUsePhysicalLocators(boolean bl) {
        this.physicalLocators = bl;
        logger.debug("Setting option (use physical locators): " + bl);
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public int getReportFormat() {
        return this.reportFormat;
    }

    public void setReportFormat(int n) {
        this.reportFormat = n;
        logger.debug("Setting option (report format): " + n);
    }
}

