/*
 * Decompiled with CFR 0.152.
 */
package org.probatron;

import com.megginson.sax.XMLWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.probatron.IncludingFilter;
import org.probatron.JarUriResolver;
import org.probatron.Session;
import org.probatron.Utils;
import org.probatron.ValidationReport;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SchematronSchema {
    private byte[] schemaAsBytes;
    static Logger logger = Logger.getLogger(SchematronSchema.class);
    private Session session;
    private URL url;

    public SchematronSchema(Session session, URL uRL) {
        this.session = session;
        logger.debug("Constructing from URL: " + uRL.toString());
        this.schemaAsBytes = Utils.derefUrl(uRL);
        this.url = uRL;
    }

    public SchematronSchema(InputStream inputStream) {
        logger.debug("Constructing from InpuStream");
        try {
            this.schemaAsBytes = Utils.getBytesToEndOfStream(inputStream, false);
        }
        catch (IOException iOException) {
            logger.error(iOException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidationReport validateCandidate(URL uRL) {
        ValidationReport validationReport = null;
        InputStream inputStream = null;
        try {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.connect();
            inputStream = uRLConnection.getInputStream();
            validationReport = this.validateCandidate(inputStream);
        }
        catch (IOException iOException) {
            try {
                logger.fatal(iOException.getMessage());
            }
            catch (Throwable throwable) {
                Utils.streamClose(inputStream);
                throw throwable;
            }
            Utils.streamClose(inputStream);
        }
        Utils.streamClose(inputStream);
        return validationReport;
    }

    static void doIncludePreprocess(byte[] byArray, ByteArrayOutputStream byteArrayOutputStream) {
    }

    private ValidationReport validateCandidate(InputStream inputStream) {
        JarUriResolver jarUriResolver = new JarUriResolver();
        TransformerFactory transformerFactory = Utils.getTransformerFactory();
        transformerFactory.setURIResolver(jarUriResolver);
        ValidationReport validationReport = null;
        Transformer transformer = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = null;
            logger.debug("Performing inclusion ...");
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            IncludingFilter includingFilter = new IncludingFilter(this.url, true);
            includingFilter.setParent(xMLReader);
            includingFilter.setContentHandler(new XMLWriter(new OutputStreamWriter(byteArrayOutputStream)));
            includingFilter.parse(new InputSource(new ByteArrayInputStream(this.schemaAsBytes)));
            byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.reset();
            logger.debug("Running abstract template expansion transform ...");
            Source source = jarUriResolver.resolve("iso_abstract_expand.xsl", null);
            transformer = transformerFactory.newTransformer(source);
            transformer.transform(new StreamSource(new ByteArrayInputStream(byArray)), new StreamResult(byteArrayOutputStream));
            byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.reset();
            logger.debug("Transforming schema to XSLT ...");
            source = jarUriResolver.resolve("iso_svrl_for_xslt2.xsl", null);
            transformer = transformerFactory.newTransformer(source);
            transformer.setParameter("full-path-notation", "4");
            if (this.session.getPhase() != null) {
                transformer.setParameter("phase", this.session.getPhase());
            }
            transformer.transform(new StreamSource(new ByteArrayInputStream(byArray)), new StreamResult(byteArrayOutputStream));
            byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.reset();
            logger.debug("Applying XSLT to candidate");
            source = new StreamSource(new ByteArrayInputStream(byArray));
            transformer = Utils.getTransformerFactory().newTransformer(source);
            transformer.transform(new StreamSource(inputStream), new StreamResult(byteArrayOutputStream));
            validationReport = new ValidationReport(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            logger.fatal(exception.getMessage());
            throw new RuntimeException("Cannot instantiate XSLT transformer, or transformation failure: " + exception.getMessage(), exception);
        }
        return validationReport;
    }

    public URL getUrl() {
        return this.url;
    }
}

