/*
 * Decompiled with CFR 0.152.
 */
package org.probatron;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.xml.sax.helpers.AttributesImpl;

public class NamespacePrefixMappings {
    static Logger logger = Logger.getLogger(NamespacePrefixMappings.class);
    private HashMap<String, String> nsMap = new HashMap();
    private HashMap<String, String> prefixMap = new HashMap();
    private int custom;

    public String prefixForNs(String string) {
        return this.nsMap.get(string);
    }

    public String nsForPrefix(String string) {
        return this.prefixMap.get(string);
    }

    public void registerMapping(String string, String string2) {
        if (this.nsMap.get(string2) != null || this.prefixMap.get(string) != null) {
            throw new IllegalArgumentException("Cannot register a prefix or Namespace name that has already been registered");
        }
        logger.debug("Registering Namespace/prefix binding:" + string + " " + string2);
        this.prefixMap.put(string, string2);
        this.nsMap.put(string2, string);
    }

    public String registerUnprefixed(String string) {
        String string2 = "ns" + this.custom;
        ++this.custom;
        this.registerMapping(string2, string);
        return string2;
    }

    public String fixupXpath(String string) {
        int n;
        String string2 = string.replaceAll("\\{\\}", "");
        while ((n = string2.indexOf("{")) != -1) {
            int n2 = string2.indexOf("}");
            String string3 = string2.substring(n + 1, n2);
            logger.trace("Fixing up URI: <" + string3 + ">");
            String string4 = this.prefixForNs(string3);
            string2 = string2.replaceAll("\\{" + string3 + "\\}", string4 + ":");
        }
        return string2;
    }

    public ArrayList<AttributesImpl> asAttributes() {
        ArrayList<AttributesImpl> arrayList = new ArrayList<AttributesImpl>();
        for (String string : this.prefixMap.keySet()) {
            String string2 = this.nsForPrefix(string);
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute("", "prefix", "prefix", "CDATA", string);
            attributesImpl.addAttribute("", "uri", "uri", "CDATA", string2);
            arrayList.add(attributesImpl);
        }
        return arrayList;
    }
}

