/*
 * Decompiled with CFR 0.152.
 */
package org.probatron;

import java.util.ArrayList;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.probatron.PhysicalLocation;
import org.probatron.Session;
import org.probatron.Utils;
import org.probatron.ValidationReport;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class EnrichmentFilter
extends XMLFilterImpl {
    static Logger logger = Logger.getLogger(EnrichmentFilter.class);
    private ValidationReport rpt;
    private Stack<String> ancestors = new Stack();
    private Session session;

    public EnrichmentFilter(Session session, ValidationReport validationReport) {
        this.rpt = validationReport;
        this.session = session;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        AttributesImpl attributesImpl;
        Object object;
        Object object2;
        this.ancestors.push(string2);
        boolean bl = string.equals(Utils.SVRL_NAME);
        if (bl && (string2.equals("successful-report") || string2.equals("failed-assert"))) {
            object2 = attributes.getValue("location");
            object = this.rpt.nsMap.fixupXpath((String)object2);
            attributesImpl = new AttributesImpl(attributes);
            attributesImpl.removeAttribute(attributesImpl.getIndex("location"));
            attributesImpl.addAttribute("", "location", "location", "CDATA", (String)object);
            attributes = attributesImpl;
            if (this.session.usesPhysicalLocators()) {
                PhysicalLocation physicalLocation = (PhysicalLocation)this.rpt.locMap.get(Utils.trimAttributePart((String)object2));
                if (physicalLocation == null) {
                    logger.warn("Cannot find location of psuedo-XPath: <" + (String)object2 + ">");
                }
                attributes = physicalLocation.addAsAttributes(attributesImpl);
            }
        } else {
            if (bl && string2.equals("ns-prefix-in-attribute-values")) {
                return;
            }
            if (this.session.getReportFormat() != 1 && bl && (string2.equals("fired-rule") || string2.equals("active-pattern"))) {
                return;
            }
        }
        super.startElement(string, string2, string3, attributes);
        if (bl && string2.equals("schematron-output")) {
            object2 = this.rpt.nsMap.asAttributes();
            object = ((ArrayList)object2).iterator();
            while (object.hasNext()) {
                attributesImpl = (AttributesImpl)object.next();
                logger.debug("Creating SVRL mapping for namespace: " + attributesImpl.getValue("uri"));
                this.getContentHandler().startElement(Utils.SVRL_NAME, "ns-prefix-in-attribute-values", "ns-prefix-in-attribute-values", attributesImpl);
                this.getContentHandler().endElement(Utils.SVRL_NAME, "ns-prefix-in-attribute-values", "ns-prefix-in-attribute-values");
            }
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.session.getReportFormat() == 1 || !this.ancestors.peek().equals("schematron-output")) {
            super.characters(cArray, n, n2);
            return;
        }
        for (int i = n; i < n + n2; ++i) {
            char c = cArray[i];
            if (c == ' ' || c == '\t' || c == '\n') continue;
            super.characters(cArray, n, n2);
            return;
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        this.ancestors.pop();
        if (string.equals(Utils.SVRL_NAME) && string2.equals("ns-prefix-in-attribute-values")) {
            return;
        }
        if (this.session.getReportFormat() != 1 && string.equals(Utils.SVRL_NAME) && (string2.equals("fired-rule") || string2.equals("active-pattern"))) {
            return;
        }
        super.endElement(string, string2, string3);
    }
}

