/*
 * Decompiled with CFR 0.152.
 */
package org.probatron;

import java.net.MalformedURLException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.probatron.Session;
import org.probatron.ValidationReport;

public class Driver {
    private static final String PROPERTY_LOGLVL = "property://probatron.org/log-level";
    private static final String DEFAULT_LOGLVL = "WARN";
    static Logger logger = Logger.getLogger(Driver.class);
    static int APP_EXIT_FAIL = -1;
    static int APP_EXIT_OKAY = 0;
    static Session theSession = new Session();

    public static void showUsage() {
        System.err.println("Usage: probatron.jar [options] candidate-doc schema-doc");
        System.err.println("Options:");
        System.err.println("-n0|1     Do not [or do] emit line/col numbers in report");
        System.err.println("-p<phase> Validate using the phase named <phase>");
        System.err.println("-r0       Output report as terse SVRL");
        System.err.println("-r1       Output report as verbose SVRL");
        System.err.println("-v        Show version info and halt");
    }

    private static void handleCommandLineArg(String string) {
        logger.debug("Handling command line argument: " + string);
        if (string.equals("-n1") || string.equals("-n0")) {
            theSession.setUsePhysicalLocators(string.equals("-n1"));
        } else if (string.startsWith("-r")) {
            theSession.setReportFormat(new Integer(string.substring(2, string.length())));
        } else if (string.startsWith("-p")) {
            theSession.setPhase(string.substring(2, string.length()));
        } else {
            logger.fatal("Unrecognized command-line option \"" + string + "\". Aborting.");
            System.exit(APP_EXIT_FAIL);
        }
    }

    static String fixArg(String string) {
        return string.indexOf(":") == -1 ? "file:" + string : string;
    }

    public static void main(String[] stringArray) {
        Object object;
        long l = System.currentTimeMillis();
        logger.info("Starting Probatron");
        if (stringArray.length == 1 && (stringArray[0].equals("-v") || stringArray[0].equals("-version"))) {
            String string = Package.getPackage("org.probatron").getImplementationVersion();
            System.out.println(string);
            System.exit(APP_EXIT_OKAY);
        }
        if (stringArray.length < 2) {
            Driver.showUsage();
            System.exit(0);
        }
        for (int i = 0; i < stringArray.length - 2; ++i) {
            object = stringArray[i];
            if (!((String)object).startsWith("-")) {
                logger.fatal("Unrecognized command line argument: " + (String)object);
                System.exit(APP_EXIT_FAIL);
                continue;
            }
            Driver.handleCommandLineArg((String)object);
        }
        String string = Driver.fixArg(stringArray[stringArray.length - 2]);
        theSession.setSchemaDoc(Driver.fixArg(stringArray[stringArray.length - 1]));
        try {
            object = theSession.doValidation(string);
            ((ValidationReport)object).streamOut(System.out);
        }
        catch (MalformedURLException malformedURLException) {
            logger.fatal(malformedURLException);
        }
        logger.info("Done. Elapsed time (ms):" + (System.currentTimeMillis() - l));
    }

    static {
        String string = System.getProperty(PROPERTY_LOGLVL) == null ? DEFAULT_LOGLVL : System.getProperty(PROPERTY_LOGLVL);
        Properties properties = new Properties();
        properties.setProperty("log4j.rootCategory", string + ",stderr");
        properties.setProperty("log4j.appender.stderr", "org.apache.log4j.ConsoleAppender");
        properties.setProperty("log4j.appender.stderr.layout", "org.apache.log4j.PatternLayout");
        properties.setProperty("log4j.appender.stderr.target", "System.err");
        properties.setProperty("log4j.appender.stderr.layout.ConversionPattern", "%p %m%n");
        PropertyConfigurator.configure(properties);
    }
}

