/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.ehvalidator.gui;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

public class XTableColumnModel
extends DefaultTableColumnModel {
    private static final long serialVersionUID = 1L;
    protected Vector<TableColumn> allTableColumns = new Vector();

    XTableColumnModel() {
    }

    public void setColumnVisible(TableColumn column, boolean visible) {
        if (!visible) {
            super.removeColumn(column);
        } else {
            int noVisibleColumns = this.tableColumns.size();
            int noInvisibleColumns = this.allTableColumns.size();
            int visibleIndex = 0;
            for (int invisibleIndex = 0; invisibleIndex < noInvisibleColumns; ++invisibleIndex) {
                TableColumn visibleColumn = visibleIndex < noVisibleColumns ? (TableColumn)this.tableColumns.get(visibleIndex) : null;
                TableColumn testColumn = this.allTableColumns.get(invisibleIndex);
                if (testColumn == column) {
                    if (visibleColumn != column) {
                        super.addColumn(column);
                        super.moveColumn(this.tableColumns.size() - 1, visibleIndex);
                    }
                    return;
                }
                if (testColumn != visibleColumn) continue;
                ++visibleIndex;
            }
        }
    }

    public void setAllColumnsVisible() {
        int noColumns = this.allTableColumns.size();
        for (int columnIndex = 0; columnIndex < noColumns; ++columnIndex) {
            TableColumn invisibleColumn;
            TableColumn visibleColumn = columnIndex < this.tableColumns.size() ? (TableColumn)this.tableColumns.get(columnIndex) : null;
            if (visibleColumn == (invisibleColumn = this.allTableColumns.get(columnIndex))) continue;
            super.addColumn(invisibleColumn);
            super.moveColumn(this.tableColumns.size() - 1, columnIndex);
        }
    }

    public TableColumn getColumnByModelIndex(int modelColumnIndex) {
        for (int columnIndex = 0; columnIndex < this.allTableColumns.size(); ++columnIndex) {
            TableColumn column = this.allTableColumns.elementAt(columnIndex);
            if (column.getModelIndex() != modelColumnIndex) continue;
            return column;
        }
        return null;
    }

    public boolean isColumnVisible(TableColumn aColumn) {
        return this.tableColumns.indexOf(aColumn) >= 0;
    }

    @Override
    public void addColumn(TableColumn column) {
        this.allTableColumns.addElement(column);
        super.addColumn(column);
    }

    @Override
    public void removeColumn(TableColumn column) {
        int allColumnsIndex = this.allTableColumns.indexOf(column);
        if (allColumnsIndex != -1) {
            this.allTableColumns.removeElementAt(allColumnsIndex);
        }
        super.removeColumn(column);
    }

    @Override
    public void moveColumn(int oldIndex, int newIndex) {
        if (oldIndex < 0 || oldIndex >= this.getColumnCount() || newIndex < 0 || newIndex >= this.getColumnCount()) {
            throw new IllegalArgumentException("moveColumn() - Index out of range");
        }
        TableColumn fromColumn = (TableColumn)this.tableColumns.get(oldIndex);
        TableColumn toColumn = (TableColumn)this.tableColumns.get(newIndex);
        int allColumnsOldIndex = this.allTableColumns.indexOf(fromColumn);
        int allColumnsNewIndex = this.allTableColumns.indexOf(toColumn);
        if (oldIndex != newIndex) {
            this.allTableColumns.removeElementAt(allColumnsOldIndex);
            this.allTableColumns.insertElementAt(fromColumn, allColumnsNewIndex);
        }
        super.moveColumn(oldIndex, newIndex);
    }

    public int getColumnCount(boolean onlyVisible) {
        Vector<TableColumn> columns = onlyVisible ? this.tableColumns : this.allTableColumns;
        return columns.size();
    }

    public Enumeration<TableColumn> getColumns(boolean onlyVisible) {
        Vector<TableColumn> columns = onlyVisible ? this.tableColumns : this.allTableColumns;
        return columns.elements();
    }

    public int getColumnIndex(Object identifier, boolean onlyVisible) {
        if (identifier == null) {
            throw new IllegalArgumentException("Identifier is null");
        }
        Vector<TableColumn> columns = onlyVisible ? this.tableColumns : this.allTableColumns;
        int noColumns = columns.size();
        for (int columnIndex = 0; columnIndex < noColumns; ++columnIndex) {
            TableColumn column = columns.get(columnIndex);
            if (!identifier.equals(column.getIdentifier())) continue;
            return columnIndex;
        }
        throw new IllegalArgumentException("Identifier not found");
    }

    public TableColumn getColumn(int columnIndex, boolean onlyVisible) {
        return (TableColumn)this.tableColumns.elementAt(columnIndex);
    }
}

