/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.ehvalidator.gui;

import be.fgov.ehealth.ehvalidator.core.EhValidator;
import be.fgov.ehealth.ehvalidator.exceptions.EhValidatorSchematronException;
import be.fgov.ehealth.ehvalidator.exceptions.EhValidatorXmlValidationException;
import be.fgov.ehealth.ehvalidator.exceptions.EhValidatorXsltTransformException;
import be.fgov.ehealth.ehvalidator.gui.XTableColumnModel;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;
import org.dom4j.swing.XMLTableModel;
import org.xml.sax.SAXException;

public class EhValidationTool
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(EhValidator.class);
    private static JFrame validatorFrame;
    private JButton btnBrowse;
    private JButton btnValidate;
    private JButton btnViewDoc;
    private JButton btnSaveDoc;
    private JButton btnViewReport;
    private JButton btnSaveReport;
    private static JMenuBar menuBar;
    private JCheckBox cbShowWarnings;
    private JCheckBox cbShowTechInfo;
    private JTextField tfFileName;
    private JComboBox cbRules;
    private String fileName;
    private Locale guilanguage = Locale.getDefault();
    private String language = this.guilanguage.getLanguage();
    private String tableDefString = "<table select=\"/report/messages/message\"><column select=\"number\">No.</column><column select=\"type/" + this.language + "\">" + rb.getString("type") + "</column>" + "<column select=\"subject\">" + rb.getString("subject") + "</column>" + "<column select=\"description/" + this.language + "\">" + rb.getString("message") + "</column>" + "<column select=\"line\">" + rb.getString("line") + "</column>" + "<column select=\"col\">" + rb.getString("col") + "</column>" + "<column select=\"location\">" + rb.getString("location") + "</column>" + "<column select=\"test\">" + rb.getString("test") + "</column>" + "</table>";
    private JLabel lblReportResult;
    private XMLTableModel tableModel;
    private XTableColumnModel columnModel;
    private boolean validReport;
    private int iNumberErrors;
    private int iNumberWarnings;
    private JFileChooser fileChooser = new JFileChooser("./demo");
    private Document report;
    private static ResourceBundle rb;
    private static FileNameExtensionFilter xmlFileFilter;
    private static FileNameExtensionFilter htmlFileFilter;
    private static final String ICON_LOCATION = "/img/eHealth.png";
    private static final String EHEALTH_LOGO_LOCATION = "/img/ehealth.gif";
    private static final String USER_GUIDE_PATH = "/manual/eHealthValidationTool Userguide.pdf";
    private static final String LINK_EHEALTH_WEBSITE = "https://www.ehealth.fgov.be";
    private static final String SUMEHR = "Sumehr";
    private static final String SMF = "SMF";
    private static final String PMF = "PMF";
    private static final String WARNINGS = "warnings";
    private static final String ERRORS = "errors";
    private String rules = "Sumehr";
    private static String storeMess;
    private static Document storeReport;
    private static String storePath;
    private static Color storeColor;
    private static String storeRules;
    private static int[] storeNumErrWarn;
    private static boolean storeShowWarningsState;
    private static boolean storeShowTechInfoState;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnBrowse) {
            this.fileChooser.setSelectedFile(new File(""));
            this.fileChooser.removeChoosableFileFilter(htmlFileFilter);
            this.fileChooser.addChoosableFileFilter(xmlFileFilter);
            this.fileChooser.setFileFilter(xmlFileFilter);
            int returnVal = this.fileChooser.showOpenDialog(this);
            if (returnVal == 0) {
                storePath = "";
                storeMess = "";
                storeColor = Color.black;
                storeReport = null;
                try {
                    this.tfFileName.setText(this.fileChooser.getSelectedFile().getCanonicalPath());
                    storePath = this.fileChooser.getSelectedFile().getCanonicalPath();
                    this.setFileName(this.fileChooser.getSelectedFile().getCanonicalPath());
                    this.report = null;
                    this.fillReportTable(this.report);
                    this.lblReportResult.setText("");
                    this.btnViewDoc.setEnabled(false);
                    this.btnSaveDoc.setEnabled(false);
                    this.btnValidate.setEnabled(true);
                    this.btnViewReport.setEnabled(false);
                    this.btnSaveReport.setEnabled(false);
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(this, e1.getMessage());
                }
            }
        } else if (e.getSource() == this.btnValidate) {
            logger.info((Object)"----------------------------------VALIDATION-----------------------------------");
            this.reInitDisplay();
            if (storePath != "") {
                this.tfFileName.setText(storePath);
                this.setFileName(storePath);
            }
            this.btnValidate.setEnabled(true);
            try {
                this.btnValidate.setCursor(Cursor.getPredefinedCursor(3));
                this.handleValidation();
            }
            catch (FileNotFoundException e1) {
                JOptionPane.showMessageDialog(this, e1.getMessage());
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(this, e1.getMessage());
            }
            finally {
                this.btnValidate.setCursor(Cursor.getDefaultCursor());
            }
        } else if (e.getSource() == this.cbRules) {
            if (this.rules != this.cbRules.getSelectedItem() && storeRules != this.cbRules.getSelectedItem()) {
                this.lblReportResult.setText("");
                storeMess = "";
                storeColor = Color.black;
                this.btnViewDoc.setEnabled(false);
                this.btnSaveDoc.setEnabled(false);
                this.btnViewReport.setEnabled(false);
                this.btnSaveReport.setEnabled(false);
            }
            storeRules = this.rules = (String)this.cbRules.getSelectedItem();
        } else if (e.getSource() == this.tfFileName) {
            this.setFileName(this.tfFileName.getText());
            this.btnValidate.setEnabled(true);
            this.report = null;
            this.fillReportTable(this.report);
            this.btnViewDoc.setEnabled(false);
            this.btnSaveDoc.setEnabled(false);
            this.btnValidate.setEnabled(true);
            this.btnViewReport.setEnabled(false);
        } else if (e.getSource() == this.btnViewDoc) {
            if (storePath != "") {
                this.tfFileName.setText(storePath);
                this.setFileName(storePath);
            }
            try {
                if (this.language == "en") {
                    this.viewHTMLReport(EhValidator.getHTMLView(this.getFileName(), EhValidator.Language.english, this.rules));
                }
                if (this.language == "nl") {
                    this.viewHTMLReport(EhValidator.getHTMLView(this.getFileName(), EhValidator.Language.dutch, this.rules));
                }
                if (this.language == "fr") {
                    this.viewHTMLReport(EhValidator.getHTMLView(this.getFileName(), EhValidator.Language.french, this.rules));
                }
                if (this.language == "de") {
                    this.viewHTMLReport(EhValidator.getHTMLView(this.getFileName(), EhValidator.Language.german, this.rules));
                }
            }
            catch (Exception mye) {
                String msg = mye.getLocalizedMessage();
                JOptionPane.showMessageDialog(this, msg);
                logger.error((Object)mye);
                this.lblReportResult.setText(msg);
                storeMess = msg;
                this.lblReportResult.setForeground(Color.RED);
                storeColor = Color.RED;
                this.reInitDisplay();
            }
        } else if (e.getSource() == this.cbShowWarnings || e.getSource() == this.cbShowTechInfo) {
            this.filterResults();
        } else if (e.getSource() == this.btnViewReport) {
            if (storePath != "") {
                this.tfFileName.setText(storePath);
                this.setFileName(storePath);
            }
            try {
                if (this.language == "en") {
                    this.viewHTMLReport(EhValidator.getHTMLReport(this.getFileName(), EhValidator.Language.english, this.rules));
                }
                if (this.language == "nl") {
                    this.viewHTMLReport(EhValidator.getHTMLReport(this.getFileName(), EhValidator.Language.dutch, this.rules));
                }
                if (this.language == "fr") {
                    this.viewHTMLReport(EhValidator.getHTMLReport(this.getFileName(), EhValidator.Language.french, this.rules));
                }
                if (this.language == "de") {
                    this.viewHTMLReport(EhValidator.getHTMLReport(this.getFileName(), EhValidator.Language.german, this.rules));
                }
            }
            catch (Exception se) {
                String msg = se.getLocalizedMessage();
                JOptionPane.showMessageDialog(this, msg);
                logger.error((Object)se);
                this.lblReportResult.setText(msg);
                storeMess = msg;
                this.lblReportResult.setForeground(Color.RED);
                storeColor = Color.RED;
                this.reInitDisplay();
            }
        } else if (e.getSource() == this.btnSaveReport || e.getSource() == this.btnSaveDoc) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd_HHmmss");
            if (storePath != "") {
                this.tfFileName.setText(storePath);
                this.setFileName(storePath);
            }
            this.fileChooser.removeChoosableFileFilter(xmlFileFilter);
            this.fileChooser.addChoosableFileFilter(htmlFileFilter);
            this.fileChooser.setFileFilter(htmlFileFilter);
            String newFileName = e.getSource() == this.btnSaveReport ? "Report_" : "View_";
            newFileName = new StringBuffer().append(newFileName).append(this.getShortFileName()).append("_").append(formatter.format(new Date())).append(".html").toString();
            this.fileChooser.setSelectedFile(new File(newFileName));
            int returnVal = this.fileChooser.showSaveDialog(this);
            if (returnVal == 0) {
                File file = this.fileChooser.getSelectedFile();
                logger.debug((Object)("Report " + file.getName() + " will be saved. File exists ? " + file.exists()));
                boolean saveOK = false;
                if (file.exists()) {
                    int response = JOptionPane.showConfirmDialog(this, "The selected file already exists. Do you wish to overwrite ?");
                    switch (response) {
                        case 0: {
                            logger.debug((Object)("User selected to overwrite file " + file.getName()));
                            saveOK = true;
                            break;
                        }
                        default: {
                            saveOK = false;
                            break;
                        }
                    }
                } else {
                    saveOK = true;
                }
                if (saveOK) {
                    try {
                        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
                        if (e.getSource() == this.btnSaveReport) {
                            if (this.language == "en") {
                                bw.write(EhValidator.getHTMLReport(this.getFileName(), EhValidator.Language.english, this.rules));
                            }
                            if (this.language == "nl") {
                                bw.write(EhValidator.getHTMLReport(this.getFileName(), EhValidator.Language.dutch, this.rules));
                            }
                            if (this.language == "fr") {
                                bw.write(EhValidator.getHTMLReport(this.getFileName(), EhValidator.Language.french, this.rules));
                            }
                            if (this.language == "de") {
                                bw.write(EhValidator.getHTMLReport(this.getFileName(), EhValidator.Language.german, this.rules));
                            }
                        } else {
                            if (this.language == "en") {
                                bw.write(EhValidator.getHTMLView(this.getFileName(), EhValidator.Language.english, this.rules));
                            }
                            if (this.language == "nl") {
                                bw.write(EhValidator.getHTMLView(this.getFileName(), EhValidator.Language.dutch, this.rules));
                            }
                            if (this.language == "fr") {
                                bw.write(EhValidator.getHTMLView(this.getFileName(), EhValidator.Language.french, this.rules));
                            }
                            if (this.language == "de") {
                                bw.write(EhValidator.getHTMLView(this.getFileName(), EhValidator.Language.german, this.rules));
                            }
                        }
                        bw.close();
                    }
                    catch (Exception ioe) {
                        String msg = ioe.getLocalizedMessage();
                        JOptionPane.showMessageDialog(this, msg);
                        logger.error((Object)ioe);
                        this.lblReportResult.setText(msg);
                        storeMess = msg;
                        this.lblReportResult.setForeground(Color.RED);
                        storeColor = Color.RED;
                        this.reInitDisplay();
                    }
                }
            }
        } else if (e.getActionCommand() == rb.getString("menuHelp-userGuide")) {
            String workingDirName = System.getProperty("user.dir");
            File userGuide = new File(workingDirName + USER_GUIDE_PATH);
            try {
                Desktop.getDesktop().browse(userGuide.toURI());
            }
            catch (IOException ioe) {
                logger.debug((Object)ioe.getMessage());
                JOptionPane.showMessageDialog(this, "Error occured during User Guide opening. (" + userGuide.getPath() + ")");
            }
        } else if (e.getActionCommand() == rb.getString("menuHelp-about")) {
            HyperLinkFrame about = new HyperLinkFrame(rb.getString("menuHelp-about-textAbout") + " " + rb.getString("winTitle"), "<html><style>h1 {font-family:Verdana, Arial, Helvetica, sans-serif;color:#b70606;padding-left:10px;font-size:20px;}p {padding-left:10px;padding-right:5px;font-family:Verdana, Arial, Helvetica, sans-serif;font-size:11px;color:#000;}span.ehealth {color:#3d6a52;font-weight:700;}</style><body><div style=\"margin-left:5em;\"><h1>" + rb.getString("winTitle") + "</h1>" + "<p>" + rb.getString("menuHelp-about-textVersion") + "<span class=\"ehealth\">" + Package.getPackage("be.fgov.ehealth.ehvalidator.gui").getImplementationVersion() + "</span>" + "</p>" + "<p>" + rb.getString("menuHelp-about-textAuthor") + "<span class=\"ehealth\">" + rb.getString("eHealth") + "</span>" + " (<a href='" + LINK_EHEALTH_WEBSITE + "'>" + LINK_EHEALTH_WEBSITE + "</a>)" + "</p>" + "<br />" + "<p>" + rb.getString("menuHelp-about-textKmehr") + "<br />" + rb.getString("menuHelp-about-textSumehr") + "<br />" + rb.getString("menuHelp-about-textSMF") + "<br />" + rb.getString("menuHelp-about-textPMF") + "</p>" + "<br />" + "<br />" + "</div>" + "<img src=\"" + EhValidationTool.class.getResource(EHEALTH_LOGO_LOCATION).toExternalForm() + "\" />" + "</body></html>");
            about.setBounds(300, 300, 500, 455);
            about.setResizable(false);
            about.setVisible(true);
        } else if (e.getActionCommand() == rb.getString("english")) {
            storeShowWarningsState = this.cbShowWarnings.isSelected();
            storeShowTechInfoState = this.cbShowTechInfo.isSelected();
            this.changeGUI("en");
        } else if (e.getActionCommand() == rb.getString("french")) {
            storeShowWarningsState = this.cbShowWarnings.isSelected();
            storeShowTechInfoState = this.cbShowTechInfo.isSelected();
            this.changeGUI("fr");
        } else if (e.getActionCommand() == rb.getString("dutch")) {
            storeShowWarningsState = this.cbShowWarnings.isSelected();
            storeShowTechInfoState = this.cbShowTechInfo.isSelected();
            this.changeGUI("nl");
        } else if (e.getActionCommand() == rb.getString("german")) {
            storeShowWarningsState = this.cbShowWarnings.isSelected();
            storeShowTechInfoState = this.cbShowTechInfo.isSelected();
            this.changeGUI("de");
        } else {
            JOptionPane.showMessageDialog(this, "Unhandled actionevent : " + e.getActionCommand());
        }
    }

    public EhValidationTool() {
        this.initialisePanels();
        this.initialiseMenuBar();
        this.tfFileName.setText(storePath);
        if (storePath != "") {
            this.btnValidate.setEnabled(true);
        }
        if (storeMess != "") {
            this.lblReportResult.setForeground(storeColor);
            this.btnViewDoc.setEnabled(true);
            this.btnSaveDoc.setEnabled(true);
            this.btnViewReport.setEnabled(true);
            this.btnSaveReport.setEnabled(true);
            if (WARNINGS.equals(storeMess)) {
                this.lblReportResult.setText(rb.getString("message-validationOK") + " (" + storeNumErrWarn[1] + " " + rb.getString("message-warnings"));
            } else if (ERRORS.equals(storeMess)) {
                this.lblReportResult.setText(rb.getString("message-validationNOK") + " (" + storeNumErrWarn[0] + " " + rb.getString(ERRORS) + " " + storeNumErrWarn[1] + " " + rb.getString(WARNINGS));
            } else if ("error-handlingSchematronReport".equals(storeMess) || "error-validationFailed".equals(storeMess) || "error-SchematronVerification".equals(storeMess) || "error-generateView".equals(storeMess)) {
                this.btnViewDoc.setEnabled(false);
                this.btnSaveDoc.setEnabled(false);
                this.btnViewReport.setEnabled(false);
                this.btnSaveReport.setEnabled(false);
                this.lblReportResult.setText(rb.getString(storeMess));
            } else if (storeMess.startsWith("INVALID")) {
                this.btnViewDoc.setEnabled(false);
                this.btnSaveDoc.setEnabled(false);
                this.btnViewReport.setEnabled(false);
                this.btnSaveReport.setEnabled(false);
                this.lblReportResult.setText(storeMess.substring(7) + " " + rb.getString("error-access"));
            } else {
                this.lblReportResult.setText(rb.getString(storeMess));
            }
        }
        if (SMF.equals(storeRules)) {
            this.cbRules.setSelectedIndex(1);
        } else if (PMF.equals(storeRules)) {
            this.cbRules.setSelectedIndex(2);
        } else {
            this.cbRules.setSelectedIndex(0);
        }
        this.cbShowTechInfo.setSelected(storeShowTechInfoState);
        this.fillReportTable(storeReport);
        this.cbShowWarnings.setSelected(storeShowWarningsState);
        this.filterResults();
    }

    private void reInitDisplay() {
        this.btnViewDoc.setEnabled(false);
        this.btnSaveDoc.setEnabled(false);
        this.btnValidate.setEnabled(false);
        this.btnViewReport.setEnabled(false);
        this.btnSaveReport.setEnabled(false);
        this.lblReportResult.setText("");
        this.report = null;
        this.fillReportTable(this.report);
    }

    private static void setupGUI() {
        Locale locale = Locale.getDefault();
        PropertyConfigurator.configure((String)"cfg/EhValidator.properties");
        rb = ResourceBundle.getBundle("cfg/EhValidationToolLang", locale);
        htmlFileFilter = new FileNameExtensionFilter("HTML Documents", "html");
        xmlFileFilter = new FileNameExtensionFilter("XML Documents", "xml");
        validatorFrame = new JFrame(rb.getString("winTitle"));
        validatorFrame.setIconImage(Toolkit.getDefaultToolkit().getImage(EhValidationTool.class.getResource(ICON_LOCATION)));
        validatorFrame.setDefaultCloseOperation(3);
        EhValidationTool newContentPane = new EhValidationTool();
        newContentPane.setOpaque(true);
        newContentPane.setLayout(new BoxLayout(newContentPane, 3));
        validatorFrame.setJMenuBar(menuBar);
        validatorFrame.setContentPane(newContentPane);
        validatorFrame.pack();
        validatorFrame.setSize(new Dimension(800, 650));
        validatorFrame.setMinimumSize(new Dimension(800, 600));
        validatorFrame.setLocation(100, 80);
        validatorFrame.setVisible(true);
    }

    private void changeGUI(String lang) {
        Locale.setDefault(new Locale(lang));
        JComponent.setDefaultLocale(new Locale(lang));
        PropertyConfigurator.configure((String)"cfg/EhValidator.properties");
        rb = ResourceBundle.getBundle("cfg/EhValidationToolLang", new Locale(lang));
        EhValidationTool newContentPane = new EhValidationTool();
        newContentPane.setOpaque(true);
        newContentPane.setLayout(new BoxLayout(newContentPane, 3));
        Point p = validatorFrame.getLocationOnScreen();
        Dimension d = validatorFrame.getSize();
        validatorFrame.setLocation(p);
        validatorFrame.setJMenuBar(menuBar);
        validatorFrame.setContentPane(newContentPane);
        validatorFrame.setSize(d);
        validatorFrame.setMinimumSize(new Dimension(800, 600));
        validatorFrame.setLocation(p);
        validatorFrame.validate();
    }

    private void initialiseMenuBar() {
        menuBar = new JMenuBar();
        JMenu menuHelp = new JMenu(rb.getString("menuHelp"));
        menuHelp.getAccessibleContext().setAccessibleDescription("Help menu.");
        menuBar.add(menuHelp);
        JMenu menuLang = new JMenu(rb.getString("language"));
        menuLang.getAccessibleContext().setAccessibleDescription("Language menu.");
        menuBar.add(menuLang);
        JMenuItem menuHelpItem = new JMenuItem(rb.getString("menuHelp-userGuide"));
        menuHelpItem.getAccessibleContext().setAccessibleDescription("Open User Guide PDF in default browser.");
        menuHelpItem.addActionListener(this);
        menuHelp.add(menuHelpItem);
        menuHelpItem = new JMenuItem(rb.getString("menuHelp-about"));
        menuHelpItem.getAccessibleContext().setAccessibleDescription("Validation Tool information.");
        menuHelpItem.addActionListener(this);
        menuHelp.add(menuHelpItem);
        JMenuItem menuLangItem = new JMenuItem(rb.getString("english"));
        menuLangItem.getAccessibleContext().setAccessibleDescription("Change Language in english.");
        menuLangItem.addActionListener(this);
        menuLang.add(menuLangItem);
        menuLangItem = new JMenuItem(rb.getString("french"));
        menuLangItem.getAccessibleContext().setAccessibleDescription("Change Language in french.");
        menuLangItem.addActionListener(this);
        menuLang.add(menuLangItem);
        menuLangItem = new JMenuItem(rb.getString("dutch"));
        menuLangItem.getAccessibleContext().setAccessibleDescription("Change Language in dutch.");
        menuLangItem.addActionListener(this);
        menuLang.add(menuLangItem);
        menuLangItem = new JMenuItem(rb.getString("german"));
        menuLangItem.getAccessibleContext().setAccessibleDescription("Change Language in german.");
        menuLangItem.addActionListener(this);
        menuLang.add(menuLangItem);
    }

    private void initialisePanels() {
        int[] columnToSort;
        JPanel actionsPanel = new JPanel();
        GroupLayout actGrpLayout = new GroupLayout(actionsPanel);
        actGrpLayout.setAutoCreateGaps(true);
        actGrpLayout.setAutoCreateContainerGaps(true);
        actionsPanel.setLayout(actGrpLayout);
        JPanel valPanel = new JPanel();
        GroupLayout valGrpLayout = new GroupLayout(valPanel);
        valGrpLayout.setAutoCreateContainerGaps(true);
        valGrpLayout.setAutoCreateGaps(true);
        valPanel.setLayout(valGrpLayout);
        TitledBorder valPanelTitle = BorderFactory.createTitledBorder(rb.getString("valPanelTitle"));
        valPanel.setBorder(valPanelTitle);
        JLabel instrLbl = new JLabel(rb.getString("select"));
        JLabel typeLbl = new JLabel(rb.getString("typeRule"));
        String[] rulesList = new String[]{SUMEHR, SMF, PMF};
        this.cbRules = new JComboBox<String>(rulesList);
        this.cbRules.setSelectedIndex(0);
        this.cbRules.setMaximumSize(new Dimension(185, 27));
        this.cbRules.setActionCommand("Rules");
        this.cbRules.addActionListener(this);
        this.tfFileName = new JTextField(30);
        this.tfFileName.setActionCommand("confirmFile");
        this.tfFileName.addActionListener(this);
        this.btnBrowse = new JButton(rb.getString("browse"));
        this.btnBrowse.addActionListener(this);
        this.btnValidate = new JButton(rb.getString("validate"));
        this.btnValidate.addActionListener(this);
        this.btnValidate.setEnabled(false);
        this.lblReportResult = new JLabel();
        valGrpLayout.setHorizontalGroup(valGrpLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(instrLbl).addGroup(valGrpLayout.createSequentialGroup().addComponent(typeLbl).addComponent(this.cbRules).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE)).addGroup(valGrpLayout.createSequentialGroup().addComponent(this.tfFileName, -2, -1, -2).addComponent(this.btnBrowse).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE)).addGroup(valGrpLayout.createSequentialGroup().addComponent(this.btnValidate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE)).addComponent(this.lblReportResult));
        valGrpLayout.setVerticalGroup(valGrpLayout.createSequentialGroup().addComponent(instrLbl).addGroup(valGrpLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(typeLbl).addComponent(this.cbRules)).addGroup(valGrpLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tfFileName).addComponent(this.btnBrowse)).addGroup(valGrpLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnValidate)).addComponent(this.lblReportResult));
        valGrpLayout.linkSize(0, this.btnBrowse, this.btnValidate);
        valGrpLayout.linkSize(1, this.tfFileName, this.btnBrowse, this.lblReportResult, this.cbRules);
        JPanel viewPanel = new JPanel();
        GroupLayout viewGrpLayout = new GroupLayout(viewPanel);
        viewGrpLayout.setAutoCreateContainerGaps(true);
        viewGrpLayout.setAutoCreateGaps(true);
        viewPanel.setLayout(viewGrpLayout);
        TitledBorder viewPanelTitle = BorderFactory.createTitledBorder(rb.getString("viewPanelTitle"));
        viewPanel.setBorder(viewPanelTitle);
        this.btnViewDoc = new JButton(rb.getString("viewFile"));
        this.btnViewDoc.addActionListener(this);
        this.btnViewDoc.setEnabled(false);
        this.btnSaveDoc = new JButton(rb.getString("saveFile"));
        this.btnSaveDoc.addActionListener(this);
        this.btnSaveDoc.setEnabled(false);
        viewGrpLayout.setVerticalGroup(viewGrpLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.btnViewDoc).addComponent(this.btnSaveDoc));
        viewGrpLayout.setHorizontalGroup(viewGrpLayout.createSequentialGroup().addComponent(this.btnViewDoc).addComponent(this.btnSaveDoc));
        viewGrpLayout.linkSize(0, this.btnViewDoc, this.btnSaveDoc);
        JPanel repPanel = new JPanel();
        TitledBorder msgPanelTitle = BorderFactory.createTitledBorder(rb.getString("repPanelTitle"));
        repPanel.setBorder(msgPanelTitle);
        this.cbShowWarnings = new JCheckBox(rb.getString("showWarnings"));
        this.cbShowWarnings.addActionListener(this);
        this.cbShowTechInfo = new JCheckBox(rb.getString("showTechInfo"));
        this.cbShowTechInfo.addActionListener(this);
        this.btnViewReport = new JButton(rb.getString("viewReport"));
        this.btnViewReport.addActionListener(this);
        this.btnViewReport.setEnabled(false);
        this.btnSaveReport = new JButton(rb.getString("saveReport"));
        this.btnSaveReport.addActionListener(this);
        this.btnSaveReport.setEnabled(false);
        GroupLayout msgGrpLayout = new GroupLayout(repPanel);
        msgGrpLayout.setAutoCreateContainerGaps(true);
        msgGrpLayout.setAutoCreateGaps(true);
        repPanel.setLayout(msgGrpLayout);
        try {
            this.tableModel = new XMLTableModel(DocumentHelper.parseText((String)this.tableDefString), null);
        }
        catch (DocumentException e) {
            logger.error((Object)e);
        }
        JTable reportTable = new JTable((TableModel)this.tableModel){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText(MouseEvent e) {
                String tip = null;
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                int colIndex = this.columnAtPoint(p);
                tip = this.getValueAt(rowIndex, colIndex).toString();
                return tip;
            }
        };
        this.columnModel = new XTableColumnModel();
        reportTable.setColumnModel(this.columnModel);
        reportTable.createDefaultColumnsFromModel();
        this.columnModel.setColumnVisible(this.columnModel.getColumnByModelIndex(4), false);
        this.columnModel.setColumnVisible(this.columnModel.getColumnByModelIndex(5), false);
        this.columnModel.setColumnVisible(this.columnModel.getColumnByModelIndex(6), false);
        this.columnModel.setColumnVisible(this.columnModel.getColumnByModelIndex(7), false);
        this.columnResizing();
        reportTable.setAutoCreateRowSorter(true);
        TableRowSorter rowsorter = (TableRowSorter)reportTable.getRowSorter();
        int[] arr$ = columnToSort = new int[]{0, 4, 5};
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer i = arr$[i$];
            rowsorter.setComparator(i, new Comparator<String>(){

                @Override
                public int compare(String str1, String str2) {
                    return Integer.parseInt(str1) - Integer.parseInt(str2);
                }
            });
        }
        JScrollPane tablePane = new JScrollPane(reportTable);
        msgGrpLayout.setHorizontalGroup(msgGrpLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(msgGrpLayout.createSequentialGroup().addGroup(msgGrpLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnViewReport).addComponent(this.cbShowWarnings)).addGroup(msgGrpLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnSaveReport).addComponent(this.cbShowTechInfo))).addComponent(tablePane));
        msgGrpLayout.setVerticalGroup(msgGrpLayout.createSequentialGroup().addGroup(msgGrpLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(msgGrpLayout.createSequentialGroup().addGroup(msgGrpLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnViewReport).addComponent(this.btnSaveReport)).addGroup(msgGrpLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbShowWarnings).addComponent(this.cbShowTechInfo)))).addComponent(tablePane));
        msgGrpLayout.linkSize(0, this.btnViewReport, this.btnSaveReport);
        actGrpLayout.setHorizontalGroup(actGrpLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(valPanel, -2, -1, Short.MAX_VALUE).addComponent(viewPanel, -2, -1, Short.MAX_VALUE).addComponent(repPanel, -2, -1, Short.MAX_VALUE));
        actGrpLayout.setVerticalGroup(actGrpLayout.createSequentialGroup().addComponent(valPanel).addComponent(viewPanel).addComponent(repPanel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE));
        this.add(actionsPanel);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EhValidationTool.setupGUI();
            }
        });
    }

    private void setFileName(String fileName) {
        this.fileName = fileName;
    }

    private String getFileName() {
        return this.fileName;
    }

    private String getShortFileName() {
        File f = new File(this.getFileName());
        String shortFileName = f.getName().lastIndexOf(46) > 0 ? f.getName().substring(0, f.getName().lastIndexOf(46)) : f.getName();
        return shortFileName;
    }

    private void handleValidation() throws FileNotFoundException, IOException {
        block19: {
            File file = new File(this.getFileName());
            this.btnViewReport.setEnabled(true);
            this.btnSaveReport.setEnabled(true);
            try {
                String reportValidationText = "";
                if (file.exists()) {
                    Color textColor;
                    try {
                        this.validReport = false;
                        this.btnViewReport.setEnabled(this.validReport);
                        this.btnSaveReport.setEnabled(this.validReport);
                        byte[] rep = EhValidator.getXMLReport(this.getFileName(), this.rules).getBytes();
                        String s = null;
                        try {
                            s = new String(rep, "UTF-8");
                        }
                        catch (UnsupportedEncodingException e1) {
                            logger.fatal((Object)"Error while converting to UTF-8");
                        }
                        this.report = DocumentHelper.parseText((String)s);
                        this.report.setXMLEncoding("utf-8");
                        this.checkReportValidity(this.report);
                        storeReport = this.report;
                        this.btnViewReport.setEnabled(true);
                        this.btnSaveReport.setEnabled(true);
                        this.btnViewDoc.setEnabled(true);
                        this.btnSaveDoc.setEnabled(true);
                        this.filterResults();
                        boolean cacheOK = false;
                        String workingDirName = System.getProperty("user.dir");
                        File cacheDir = new File(workingDirName + "/cache");
                        cacheOK = cacheDir.exists();
                        if (!cacheOK) {
                            cacheOK = cacheDir.mkdir();
                        }
                        File f2 = new File(workingDirName + "/cache/temp.xml");
                        try {
                            int len;
                            FileInputStream in = new FileInputStream(file);
                            FileOutputStream out = new FileOutputStream(f2);
                            byte[] buf = new byte[1024];
                            while ((len = ((InputStream)in).read(buf)) > 0) {
                                ((OutputStream)out).write(buf, 0, len);
                            }
                            ((InputStream)in).close();
                            ((OutputStream)out).close();
                            f2.deleteOnExit();
                        }
                        catch (FileNotFoundException e) {
                            logger.error((Object)e);
                        }
                        catch (IOException e) {
                            logger.error((Object)e);
                        }
                    }
                    catch (DocumentException de) {
                        JOptionPane.showMessageDialog(this, de.getMessage());
                        reportValidationText = rb.getString("error-handlingSchematronReport");
                        storeMess = "error-handlingSchematronReport";
                        textColor = Color.RED;
                        this.btnViewDoc.setEnabled(false);
                        this.btnSaveDoc.setEnabled(false);
                    }
                    catch (EhValidatorXmlValidationException evxve) {
                        JOptionPane.showMessageDialog(this, evxve.getMessage());
                        reportValidationText = rb.getString("error-validationFailed");
                        storeMess = "error-validationFailed";
                        textColor = Color.RED;
                        this.btnViewDoc.setEnabled(false);
                        this.btnSaveDoc.setEnabled(false);
                    }
                    catch (EhValidatorSchematronException evse) {
                        JOptionPane.showMessageDialog(this, evse.getMessage());
                        reportValidationText = rb.getString("error-SchematronVerification");
                        storeMess = "error-SchematronVerification";
                        textColor = Color.RED;
                        this.btnViewDoc.setEnabled(false);
                        this.btnSaveDoc.setEnabled(false);
                    }
                    catch (EhValidatorXsltTransformException evxte) {
                        JOptionPane.showMessageDialog(this, evxte.getMessage());
                        reportValidationText = rb.getString("error-generateView");
                        storeMess = "error-generateView";
                        textColor = Color.RED;
                        this.btnViewDoc.setEnabled(false);
                        this.btnSaveDoc.setEnabled(false);
                    }
                    if (this.validReport) {
                        reportValidationText = rb.getString("message-validationOK");
                        storeMess = "message-validationOK";
                        textColor = Color.decode("#228B22");
                        if (this.iNumberWarnings > 0) {
                            reportValidationText = new StringBuffer().append(reportValidationText).append(" (" + this.iNumberWarnings + " " + rb.getString("message-warnings")).toString();
                            storeMess = WARNINGS;
                            storeNumErrWarn = new int[]{this.iNumberErrors, this.iNumberWarnings};
                            textColor = Color.decode("#FF8C00");
                        }
                    } else {
                        if (reportValidationText.length() == 0) {
                            reportValidationText = rb.getString("message-validationNOK") + " (" + this.iNumberErrors + " " + rb.getString(ERRORS) + " " + this.iNumberWarnings + " " + rb.getString(WARNINGS) + " ";
                            storeMess = ERRORS;
                            storeNumErrWarn = new int[]{this.iNumberErrors, this.iNumberWarnings};
                        }
                        textColor = Color.RED;
                    }
                    this.lblReportResult.setText(reportValidationText);
                    this.lblReportResult.setForeground(textColor);
                    storeColor = textColor;
                    break block19;
                }
                JOptionPane.showMessageDialog(this, this.getFileName() + " - " + rb.getString("error-badCommand"));
                this.reInitDisplay();
                this.lblReportResult.setForeground(Color.RED);
                storeColor = Color.RED;
                this.lblReportResult.setText("File " + this.getFileName() + " " + rb.getString("error-access"));
                storeMess = "INVALIDFile " + this.getFileName();
                this.btnViewDoc.setEnabled(false);
                this.btnSaveDoc.setEnabled(false);
                this.btnValidate.setEnabled(true);
            }
            catch (SAXException se) {
                JOptionPane.showMessageDialog(this, se.getLocalizedMessage());
                logger.error((Object)se);
            }
        }
    }

    private void columnResizing() {
        block10: for (int i = 0; i < this.columnModel.getColumnCount(); ++i) {
            TableColumn col = this.columnModel.getColumnByModelIndex(i);
            switch (i) {
                case 0: {
                    col.setPreferredWidth(50);
                    continue block10;
                }
                case 1: {
                    col.setPreferredWidth(80);
                    continue block10;
                }
                case 2: {
                    col.setPreferredWidth(100);
                    continue block10;
                }
                case 3: {
                    col.setPreferredWidth(350);
                    continue block10;
                }
                case 4: {
                    col.setPreferredWidth(50);
                    continue block10;
                }
                case 5: {
                    col.setPreferredWidth(50);
                    continue block10;
                }
                case 6: {
                    col.setPreferredWidth(100);
                }
                case 7: {
                    col.setPreferredWidth(50);
                }
            }
        }
    }

    private void viewHTMLReport(String reportString) {
        logger.debug((Object)"Entering viewHTMLReport");
        boolean cacheOK = false;
        String workingDirName = System.getProperty("user.dir");
        File cacheDir = new File(workingDirName + "/cache");
        cacheOK = cacheDir.exists();
        if (!cacheOK) {
            cacheOK = cacheDir.mkdir();
        }
        if (cacheOK) {
            File htmlReport = new File(workingDirName + "/cache/report.html");
            try {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(htmlReport)));
                writer.write(reportString);
                writer.flush();
                writer.close();
                Desktop.getDesktop().browse(htmlReport.toURI());
                htmlReport.deleteOnExit();
            }
            catch (IOException e) {
                logger.debug((Object)e.getMessage());
            }
        } else {
            logger.error((Object)new StringBuilder().append("mkdir operation failed on ").append(cacheDir.getPath()));
            JOptionPane.showMessageDialog(this, "Could not create temporary directory. Check the logs for details.");
        }
        logger.debug((Object)"Leaving viewHTMLReport");
    }

    private void fillReportTable(Document argReport) {
        this.tableModel.setSource((Object)argReport);
        if (this.cbShowTechInfo.isSelected()) {
            this.columnModel.setColumnVisible(this.columnModel.getColumnByModelIndex(4), true);
            this.columnModel.setColumnVisible(this.columnModel.getColumnByModelIndex(5), true);
            this.columnModel.setColumnVisible(this.columnModel.getColumnByModelIndex(6), true);
            this.columnModel.setColumnVisible(this.columnModel.getColumnByModelIndex(7), true);
        } else {
            this.columnModel.setColumnVisible(this.columnModel.getColumnByModelIndex(4), false);
            this.columnModel.setColumnVisible(this.columnModel.getColumnByModelIndex(5), false);
            this.columnModel.setColumnVisible(this.columnModel.getColumnByModelIndex(6), false);
            this.columnModel.setColumnVisible(this.columnModel.getColumnByModelIndex(7), false);
        }
        this.tableModel.fireTableDataChanged();
    }

    private void filterResults() {
        this.cbShowWarnings.isSelected();
        if (this.report != null || storeReport != null) {
            String nodeSelection = "";
            if (!this.cbShowWarnings.isSelected()) {
                nodeSelection = "//report/messages/message[type[en='WARNING']]";
            }
            Document tempReport = this.report != null ? (Document)this.report.clone() : (Document)storeReport.clone();
            if (nodeSelection.length() > 0) {
                List list = tempReport.selectNodes(nodeSelection);
                ArrayList<Node> nodeList = new ArrayList<Node>();
                for (Object e : list) {
                    nodeList.add((Node)e);
                }
                if (nodeList.size() > 0) {
                    for (Node node : nodeList) {
                        node.detach();
                    }
                }
            }
            this.fillReportTable(tempReport);
        } else {
            this.fillReportTable(null);
        }
    }

    private void checkReportValidity(Document argReport) {
        Node node;
        List list = argReport.selectNodes("//report/header/validationResult/errors");
        ArrayList<Node> nodeList = new ArrayList<Node>();
        for (Object node2 : list) {
            nodeList.add((Node)node2);
        }
        if (nodeList.size() == 1) {
            node = (Node)nodeList.get(0);
            this.iNumberErrors = Integer.parseInt(node.getText());
            logger.debug((Object)("Number of errors found in the report: " + this.iNumberErrors));
            this.validReport = this.iNumberErrors <= 0;
        }
        list = argReport.selectNodes("//report/header/validationResult/warnings");
        nodeList = new ArrayList();
        for (Object node2 : list) {
            nodeList.add((Node)node2);
        }
        if (nodeList.size() == 1) {
            node = (Node)nodeList.get(0);
            this.iNumberWarnings = Integer.parseInt(node.getText());
            logger.debug((Object)("Number of warnings found in the report: " + this.iNumberWarnings));
        }
    }

    static {
        storeMess = "";
        storePath = "";
        storeColor = Color.BLACK;
        storeNumErrWarn = new int[]{0, 0};
    }

    private class HyperLinkFrame
    extends JFrame {
        private static final long serialVersionUID = 1L;

        public HyperLinkFrame(String title, String text) {
            this.setTitle(title);
            Container cp = this.getContentPane();
            JEditorPane p = new JEditorPane("text/html", text);
            p.setEditable(false);
            p.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                        try {
                            Desktop.getDesktop().browse(e.getURL().toURI());
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(HyperLinkFrame.this, ex.getMessage());
                        }
                    }
                }
            });
            cp.add(new JScrollPane(p));
        }
    }
}

